<?php
	
	/* Endless Scrolling for Portfolio and Gallery */
	add_action('init', 'check_endless_scrolling_req');
	
	function check_endless_scrolling_req()
	{
		add_action('wp_ajax_endless_get_results', 'endless_scroll_get_results');
		add_action('wp_ajax_nopriv_endless_get_results', 'endless_scroll_get_results');
	}
	
	
	function endless_scroll_get_results()
	{
		global $wpdb;
		
		$page 					= $_REQUEST['page'];
		$portfolio_category 	= $_REQUEST['portfolio_category'];
		$post_id				= $_REQUEST['page_id'];
		
		$post 					= get_post($post_id);
		$post_type 				= $_REQUEST['post_type'];
				
		if($post)
		{
			$portfolio_options = get_portfolio_options($post_id);
			
			if($post_type == 'gallery')
				$portfolio_options = get_gallery_options($post_id);
			
			extract($portfolio_options);
			
			$arr = array(
				'post_type' => $post_type,
				'paged' => $page,
				'posts_per_page' => $items_per_page
			);
			
			if($portfolio_category)
			{
				$arr['portfolio-category'] = $portfolio_category;
			}
			
			$portfolio_items = new WP_Query($arr);	
			
			
			while($portfolio_items->have_posts()): $portfolio_items->the_post();
			
				global $post;
				
				$post_id = $post->ID;
				$title = get_the_title();
				
				if($post_type == 'gallery')
				{					
					$thumbnail_size = '';
					
					switch($columns)
					{
						case 2:
							$thumbnail_size = 'portfolio-thumb-4';
							$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
							break;
							
						case 3:
							$thumbnail_size = 'portfolio-thumb-3';
							$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
							break;
							
						default:
							$thumbnail_size = 'portfolio-thumb-1';
							$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
					}
					
					
					# [Alternative] If there is no post thumnail attached, check for other attachments inside the post
					if( ! $post_thumbnail)
					{
						$other_attachment = reset(get_children(array('post_parent' => $post_id, 'post_type' => 'attachment', 'posts_per_page' => 1, 'orderby' => 'menu_order', 'order' => 'ASC')));
						
						$post_thumbnail = wp_get_attachment_image($other_attachment->ID, $thumbnail_size);
						$post_thumbnail = preg_replace('/width=.[0-9]+.|height=.[0-9]+./', '', $post_thumbnail);
					}
					
					$album_date = get_post_meta($post_id, 'album_date', TRUE);
					$album_place = get_post_meta($post_id, 'album_place', TRUE);
					
					if($album_date)
					{
						$album_date = strtotime($album_date);
						$album_date = date("d F Y", $album_date);
					}
					
					$album_second_line = $album_date . ($album_date && $album_place ? ' - ' : '') . $album_place . '&nbsp;';
						
					
			?>
				<!-- portfolio entry -->
				<div class="portfolio_entry_item <?php echo $columns == 3 ? 'one-third column' : ($columns == 2 ? 'eight columns' : 'four columns'); ?>">
					
					<div class="portfolio_entry<?php echo ! $gallery_bottom_titles ? ' no_titles' : ''; ?>" data-filter="" data-row-1="<?php echo esc_attr($title); ?>" data-row-2="<?php echo esc_attr($album_second_line); ?>">
						
						<a href="<?php the_permalink(); ?>" class="image portfolio_hover gallery_hover">
							<?php echo $post_thumbnail; ?>
						</a>
						
						<?php if($gallery_bottom_titles): ?>
							<!-- item title -->
							<div class="meta">					
								<a href="<?php the_permalink(); ?>" class="title"><?php the_title(); ?></a>
								
								<div class="right_panel">
									<span class="category gallery_category"><?php echo $album_second_line; ?></span>
									
									<?php if($allow_likes): ?>
									<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikeGalleryItem'); ?>" data-is-gallery-item="1" class="like<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>">Like</a>
									<?php endif; ?>
								</div>
							</div>
							<!-- end: item title -->
						<?php endif; ?>
									
					</div>
					
				</div>
				<!-- end: portfolio entry -->
				<?php
				}
				else
				{
					$post_categories = get_the_terms($post_id, 'portfolio-category');
					
					if( ! $post_categories)
						$post_categories = array();
					
					$thumbnail_size = '';
					
					switch($columns)
					{
						case 2:
							$thumbnail_size = 'portfolio-thumb-4';
							$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
							break;
							
						case 3:
							$thumbnail_size = 'portfolio-thumb-3';
							$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
							break;
							
						default:
							$thumbnail_size = 'portfolio-thumb-1';
							$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
					}
					
					
					# [Alternative] If there is no post thumnail attached, check for other attachments inside the post
					if( ! $post_thumbnail)
					{
						$other_attachment = reset(get_children(array('post_parent' => $post_id, 'post_type' => 'attachment', 'posts_per_page' => 1, 'orderby' => 'menu_order', 'order' => 'ASC')));
						
						$post_thumbnail = wp_get_attachment_image($other_attachment->ID, $thumbnail_size);
						$post_thumbnail = preg_replace('/width=.[0-9]+.|height=.[0-9]+./', '', $post_thumbnail);
					}
					
					# Category Slugs
					$cslugs = array();
					$cnames = array();
					
					foreach($post_categories as $cat_term)
					{
						array_push($cslugs, $cat_term->slug);
						array_push($cnames, $cat_term->name);
					}
			
					?>
					<!-- portfolio entry -->
					<div class="portfolio_entry_item <?php echo $columns == 3 ? 'one-third column' : ($columns == 2 ? 'eight columns' : 'four columns'); ?>">
						
						<div class="portfolio_entry<?php echo ! $portfolio_bottom_titles ? ' no_titles' : ''; ?>" data-filter="<?php echo implode(' ', $cslugs); ?>" data-row-1="<?php echo esc_attr($title); ?>" data-row-2="<?php echo esc_attr(implode(', ', $cnames)); ?>">
							
							<a href="<?php the_permalink(); ?>" class="image portfolio_hover">
								<?php echo $post_thumbnail; ?>
							</a>
							
							<?php if($portfolio_bottom_titles): ?>
								<!-- item title -->
								<div class="meta">					
									<a href="<?php the_permalink(); ?>" class="title"><?php the_title(); ?></a>
									
									<div class="right_panel">
										<span class="category"><?php echo implode(', ', $cnames); ?></span>
										
										<?php if($allow_likes): ?>
										<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikePortfolioItem'); ?>" class="like<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>">Like</a>
										<?php endif; ?>
									</div>
								</div>
								<!-- end: item title -->
							<?php else: ?>
								<?php if($allow_likes): ?>
								<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikePortfolioItem'); ?>" class="like<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>"><?php _e('Like'); ?></a>
								<?php endif; ?>
							<?php endif; ?>
										
						</div>
						
					</div>
					<!-- end: portfolio entry -->
					<?php
				}
			
			endwhile;
		
			die();	
		}
	}