<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */

# Get Template File being in use
function template_file()
{
	global $template;
	
	return basename($template);
}

# Excerpt Length
function kolor_excerpt_length()
{
	return 80;
}

# Excerpt Length (for 2 columns blog posts)
function kolor_excerpt_length_2()
{
	return 40;
}

# Excerpt more string (appended in the end)
function kolor_excerpt_more()
{
	return '...';
}


# Comment Form Default Fields
function kolor_comment_fields($fields)
{
	foreach($fields as $field_type => $field_html)
	{
		preg_match("/<label(.*?)>(.*?)<\/label>/", $field_html, $html_label);
		preg_match("/<input(.*?)\/>/", $field_html, $html_input);
		
		$html_label = $html_label[0];
		$html_input = $html_input[0];
		
		$html_input = str_replace(' />', ' class="input" />', $html_input);
		
		$fields[$field_type] = "<div class=\"placeholder\">
	{$html_label}
	{$html_input}
</div>";
	}
	
	
	return $fields;
}


# List Comments Loop
function kolor_list_comments($comment, $args, $depth)
{
	global $post;
		
	$comment_ID 		= $comment->comment_ID;
	$comment_author 	= $comment->comment_author;
	$comment_author_url	= $comment->comment_author_url;
	$comment_author_email= $comment->comment_author_email;
	$comment_date 		= $comment->comment_date;
	$comment_content 	= $comment->comment_content;
	
	$avatar				= preg_replace("/\s?(height='[0-9]+'|width='[0-9]+')/", "", get_avatar($comment));
	
	$comment_timespan 	= human_time_diff(strtotime($comment_date), time());
	
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php echo $comment_ID; ?>">
		<div id="comment-<?php echo $comment_ID; ?>" class="comment">
			<div class="clearfix">
				<?php echo $avatar; ?>

				<div class="comment-details">
					
					<div class="comment_head">
						<h6>
							<a href="<?php echo $comment_author_url ? $comment_author_url : ($comment_author_url . '#comment-' . $comment_ID); ?>" rel="external nofollow" class="url"><?php echo $comment_author; ?></a>
						</h6>
						
						<span><?php echo $comment_timespan . ' ' . __('ago', TD); ?></span>
					</div>
					
					<div class="comment_section">
						<?php echo wpautop($comment_content); ?>
						
						<!-- <a class="comment-reply-link" href="#">Reply</a> -->
						<?php edit_comment_link(__('Edit Comment'), '', ''); ?>
						<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'Reply <span>&darr;</span>', TD), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ), $comment, $post ); ?>
					</div>
					
				</div>
			</div>
		</div>
		
	<?php
}


/* Filter: Post Password Form */
function kolor_post_password_form($output)
{
	global $post;
	
	$warn_text = __("This post is password protected. To view it please enter your password below:", TD);
	
	$label = 'pwbox-' . ( empty($post->ID) ? rand() : $post->ID );
	
	
	if(get_option('kolor_pass_protected_show_excerpt') == 'true'):
	
		$words_num = get_option('kolor_pass_protected_stories_words_num');
		$words_num = $words_num ? $words_num : 55;
		$post_content = wp_trim_words($post->post_content, $words_num);
		
		$_output = '<div class="excerpt_pre_pass">' . $post_content . '</div>';
		
	endif;
	
	$_output .= '<form action="' . esc_url( site_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" method="post">
	<p>' . get_option('kolor_pass_protected_stories_text_hint') . '</p>
	<div class="placeholder"><label for="' . $label . '">' . __("Password:") . '</label> <input name="post_password" id="' . $label . '" type="password" size="20" class="input" /> <button type="submit" class="button">' . esc_attr(get_option('kolor_pass_protected_stories_button_text')) . '</button></div>
</form>
	';
	
	return $_output;
}



/* Function to generate Pagination From-To Numbers */
function pagination_generate_from_to($current_page, $max_num_pages, $numbers_to_show = 5)
{
	$add_sub_1 = round($numbers_to_show/2);
	$add_sub_2 = round($numbers_to_show - $add_sub_1);
	
	$from = $current_page - $add_sub_1;
	$to = $current_page + $add_sub_2;
	
	$limits_exceeded_l = FALSE;
	$limits_exceeded_r = FALSE;
	
	if($from < 1)
	{
		$from = 1;
		$limits_exceeded_l = TRUE;
	}
	
	if($to > $max_num_pages)
	{
		$to = $max_num_pages;
		$limits_exceeded_r = TRUE;
	}
	
	
	if($limits_exceeded_l)
	{
		$from = 1;
		$to = $numbers_to_show;
	}
	else
	if($limits_exceeded_r)
	{
		$from = $max_num_pages - $numbers_to_show + 1;
		$to = $max_num_pages;
	}
	else
	{
		$from += 1;
	}
	
	if($from < 1)
		$from = 1;
	
	if($to > $max_num_pages)
	{
		$to = $max_num_pages;
	}
	
	return array('from' => $from, 'to' => $to);
}



/* Get Portfolio Options function (for page) */
function get_portfolio_options($get_post_id = 0)
{
	global $post, $post_id;
	
	$items_per_page 			= get_option('kolor_portfolio_items_per_page');
	$pagination_position 		= get_option('kolor_portfolio_pagination_position');
	
	
	$disable_isotope 			= get_option('kolor_portfolio_disable_isotope');
	
	$allow_likes 				= get_option('kolor_portfolio_allow_likes') == 'true';
	$like_logging_method 	 	= get_option('kolor_portfolio_like_logging_method');
	$portfolio_unlike_support	= get_option('kolor_portfolio_unlike_support');
	
	$show_views 				= get_option('kolor_portfolio_show_views') == 'true';

	
	
	# Process Vars
	if( ! is_numeric($items_per_page) || $items_per_page < 2)
		$items_per_page = 12;
	
	# Build Options Array
	$portfolio_options = array(
		'disable_isotope' 			=> $disable_isotope,
		
		'allow_likes' 				=> $allow_likes,
		'like_logging_method'		=> $like_logging_method,
		'portfolio_unlike_support'	=> $portfolio_unlike_support,
		
		'show_views' 				=> $show_views,
		
		# Pagination
		'items_per_page' 			=> $items_per_page,
		'pagination_position'		=> $pagination_position,
		'numbers_to_show'			=> 5,
		
		# Portfolio Template
		'columns'					=> 4,
		'portfolio_bottom_titles'	=> FALSE
	);
	
	if(is_page() || $get_post_id)
	{
		$post_id = $get_post_id ? $get_post_id : get_the_ID();
		
		$portfolio_columns = get_post_meta($post_id, 'portfolio_columns', TRUE);
		$portfolio_bottom_titles = get_post_meta($post_id, 'portfolio_bottom_titles', TRUE);
		
		
		$infinite_scroll = get_post_meta($post_id, 'infinite_scroll', TRUE);
		$infinite_scroll_manual = get_post_meta($post_id, 'infinite_scroll_manual', TRUE);
		
		$browse_portfolio_category = get_post_meta($post_id, 'browse_portfolio_category', TRUE);
		
		
		# Set Columns Number
		if($portfolio_columns)
		{
			$portfolio_options['columns'] = $portfolio_columns;
		}
		
		# Set view with titles
		if($portfolio_bottom_titles && ($portfolio_columns == 3 || $portfolio_columns == 2))
		{
			$portfolio_options['portfolio_bottom_titles'] = $portfolio_bottom_titles;
		}
		
		# Infinite Scrolling
		if($infinite_scroll)
		{
			$portfolio_options['infinite_scroll'] = $infinite_scroll ? TRUE : FALSE;
			$portfolio_options['infinite_scroll_manual'] = $infinite_scroll_manual ? TRUE : FALSE;
		}
		
		# Browse Portfolio Category
		$portfolio_options['browse_portfolio_category'] = $browse_portfolio_category;
	}
	
	return $portfolio_options;
}


/* Get Gallery Options function (for page) */
function get_gallery_options($get_post_id = 0)
{
	global $post, $post_id;
	
	$items_per_page 			= get_option('kolor_gallery_items_per_page');
	$pagination_position 		= get_option('kolor_gallery_pagination_position');
	
	$allow_likes 				= get_option('kolor_gallery_allow_likes') == 'true';
	$like_logging_method 	 	= get_option('kolor_gallery_like_logging_method');
	$gallery_unlike_support		= get_option('kolor_gallery_unlike_support');
	
	$show_views 				= get_option('kolor_gallery_show_views') == 'true';
	
	# Process Vars
	if( ! is_numeric($items_per_page) || $items_per_page < 2)
		$items_per_page = 12;
	
	# Build Options Array
	$portfolio_options = array(
		
		'allow_likes' 				=> $allow_likes,
		'like_logging_method'		=> $like_logging_method,
		'portfolio_unlike_support'	=> $gallery_unlike_support,
		
		'show_views' 				=> $show_views,
		
		# Pagination
		'items_per_page' 			=> $items_per_page,
		'pagination_position'		=> $pagination_position,
		'numbers_to_show'			=> 5,
		
		# Portfolio Template
		'columns'					=> 4,
		'gallery_bottom_titles'		=> FALSE
	);
	
	if(is_page() || $get_post_id)
	{
		$post_id = $get_post_id ? $get_post_id : get_the_ID();
		
		$portfolio_columns = get_post_meta($post_id, 'portfolio_columns', TRUE);
		$portfolio_bottom_titles = get_post_meta($post_id, 'portfolio_bottom_titles', TRUE);
		
		$infinite_scroll = get_post_meta($post_id, 'infinite_scroll', TRUE);
		$infinite_scroll_manual = get_post_meta($post_id, 'infinite_scroll_manual', TRUE);
		
		# Set Columns Number
		if($portfolio_columns)
		{
			$portfolio_options['columns'] = $portfolio_columns;
		}
		
		# Set view with titles
		if($portfolio_bottom_titles && ($portfolio_columns == 3 || $portfolio_columns == 2))
		{
			$portfolio_options['gallery_bottom_titles'] = $portfolio_bottom_titles;
		}
		
		# Infinite Scrolling
		if($infinite_scroll)
		{
			$portfolio_options['infinite_scroll'] = $infinite_scroll ? TRUE : FALSE;
			$portfolio_options['infinite_scroll_manual'] = $infinite_scroll_manual ? TRUE : FALSE;
		}
	}
	
	return $portfolio_options;
}



# Detect Youtube and Vimeo Links
function get_video_frames_links($text)
{
	if(strstr($text, "youtube.com"))
	{
		preg_match("#v=(\w+)#", $text, $youtube_video_id);
		$youtube_video_id = end($youtube_video_id);
		
		$href = "http://www.youtube.com/v/{$youtube_video_id}";
		
		return $href;
	}
	else
	# Detect Vimeo Link
	if(strstr($text, "vimeo.com"))
	{
		preg_match("#com/(\d+)#", $text, $vimeo_video_id);
		$vimeo_video_id = end($vimeo_video_id);
		
		$href = "http://vimeo.com/moogaloop.swf?clip_id={$vimeo_video_id}";
		
		return $href;
	}
	
	return null;
}


# Check if wpml is installed and running
function is_wpml()
{
	return function_exists('icl_get_home_url') && defined('ICL_LANGUAGE_CODE') ? TRUE : FALSE;
}


# Custom CSS Styling
function show_custom_css()
{
	$custom_css = get_option('kolor_custom_css');
	
	if(strlen($custom_css))
	{
		# Get URLS
		preg_match_all("/(http(.*?)\.css)/", $custom_css, $urls);
		
		$urls = $urls[1];
		
		$custom_css = str_replace($urls, '', $custom_css);
		
		$custom_css = preg_replace('/\s{3,}/', ' ', $custom_css);
		
		foreach($urls as $css_url)
		{
			echo '<link rel="stylesheet" type="text/css" href="' . $css_url . '">' . PHP_EOL;
		}
		
		?>
<style>
<?php echo $custom_css; ?>

</style>
<?php
	}
}