<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */


/* On Init Execute Commands */


/* Fonts */
$theme_fonts = array(
	'opensans' 	=> array(
							'http://fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,700italic,400,300,600,700', 
							'http://fonts.googleapis.com/css?family=Vollkorn:400,700',
							'kolor' => THEMEURL . 'css/kolor-opensans.css'
						),
	'droid' 	=> array(
							'http://fonts.googleapis.com/css?family=Dosis:400,500,600,700', 
							'http://fonts.googleapis.com/css?family=Vollkorn:400,700',
							'kolor' => THEMEURL . 'css/kolor-dosis.css'
						),
	'lato' 		=> array(
							'http://fonts.googleapis.com/css?family=Lato:300,400,700,400italic', 
							'http://fonts.googleapis.com/css?family=Vollkorn:400,700',
							'kolor' => THEMEURL . 'css/kolor-lato.css'
						),
	'pt-sans'	=> array(
							'http://fonts.googleapis.com/css?family=PT+Sans:400,700,400italic', 
							'http://fonts.googleapis.com/css?family=Vollkorn:400,700',
							'kolor' => THEMEURL . 'css/kolor-pt-sans.css'
						),
	'cabin' 	=> array(
							'http://fonts.googleapis.com/css?family=Cabin:400,700,400italic', 
							'http://fonts.googleapis.com/css?family=Vollkorn:400,700',
							'kolor' => THEMEURL . 'css/kolor-cabin.css'
						)
);

define("THEME_FONTS", serialize($theme_fonts));


/* Load Vars JS */
if(isset($_GET['jsvars']))
{
	header('Content-Type: text/javascript');
	include THEMEDIR . 'js/vars.js';
	exit;
}


/* Admin Print Styles */
add_action('admin_print_styles', 'kolor_admin_print_styles');

function kolor_admin_print_styles()
{

?>
<style>
    /* Admin Menu - 16px 
       Use only if you put your plugin or option page in the top level via add_menu_page()
    */
    #toplevel_page_kolor_options .wp-menu-image {
    	background: url(<?php bloginfo('template_url') ?>/images/admin/laborator-icon-adminmenu16-sprite.png) no-repeat 6px 6px !important;
    }
    /* We need to hide the generic.png img element inserted by default */
    #toplevel_page_kolor_options .wp-menu-image img {
    	display: none;
    }
    #toplevel_page_kolor_options:hover .wp-menu-image, #toplevel_page_kolor_options.wp-has-current-submenu .wp-menu-image {
        background-position: 6px -26px !important;
    }
   	
    
</style>
<?php
}



/* Register Scripts */
wp_register_script('kolor_vars',		WPURL . 'index.php?jsvars=true', null, null);

wp_register_script('kolor_hover', 		THEMEURL . 'js/jquery.hover.js', null, null, TRUE);
wp_register_script('kolor_ancarousel', 	THEMEURL . 'js/jquery.ancarousel.js', null, null, TRUE);
wp_register_script('kolor_angallery', 	THEMEURL . 'js/jquery.angallery.js', null, null, TRUE);
wp_register_script('kolor_asyncslider', THEMEURL . 'js/jquery.asyncslider.js', null, null, TRUE);
wp_register_script('kolor_elmagnifier', THEMEURL . 'js/jquery.el-magnifier.js', null, null, TRUE);
wp_register_script('kolor_hpfeatures', 	THEMEURL . 'js/jquery.hp_features.js', null, null, TRUE);
wp_register_script('kolor_wideslider', 	THEMEURL . 'js/jquery.wideslider.js', null, null, TRUE);
wp_register_script('kolor_winres',	 	THEMEURL . 'js/jquery.winres.js', null, null, TRUE);
wp_register_script('kolor_mediahelper',	THEMEURL . 'js/media-helper.js', null, null, TRUE);
wp_register_script('kolor_mobilemenu',	THEMEURL . 'js/mobile-menu.js', null, null, TRUE);
wp_register_script('kolor_archives',	THEMEURL . 'js/archives.js', null, null, TRUE);
wp_register_script('kolor_contact',		THEMEURL . 'js/contact.js', null, null, TRUE);
wp_register_script('kolor_custom',		THEMEURL . 'js/custom.js', null, null, TRUE);


wp_register_script('jquery_ui',		 	THEMEURL . 'js/jquery-ui-1.8.22.custom.min.js', null, null, TRUE);
wp_register_script('isotope',		 	THEMEURL . 'js/jquery.isotope.min.js', null, null, TRUE);
wp_register_script('masonry',		 	THEMEURL . 'js/jquery.masonry.min.js', null, null, TRUE);
wp_register_script('ba_hashchange', 	THEMEURL . 'js/jquery.ba-hashchange.js', null, null, TRUE);
wp_register_script('jquery_easing', 	THEMEURL . 'js/jquery.easing.1.3.js', null, null, TRUE);
wp_register_script('roundabout_slider', THEMEURL . 'js/fredhq/jquery.roundabout.js', null, null, TRUE);
wp_register_script('flexslider', 		THEMEURL . 'js/flexslider/jquery.flexslider-min.js', null, null, TRUE);

wp_register_script('less',		 		THEMEURL . 'js/less.js', null, null, TRUE);

wp_register_script('infinitescroll', 	THEMEURL . 'js/jquery.infinitescroll.js', null, null, TRUE);
wp_register_script('shadowbox', 		THEMEURL . 'js/shadowbox/shadowbox.js', null, null, TRUE);

wp_register_script('greensock', 		THEMEURL . 'js/gs/TweenMax.min.js', null, null, TRUE);
wp_register_script('greensock_easing',	THEMEURL . 'js/gs/easing/EasePack.min.js', null, null, TRUE);

wp_register_script('google_maps',		'http://maps.google.com/maps/api/js?sensor=false', null, null);


/* Register Styles */

wp_register_style('skeleton_base', 		THEMEURL . 'css/base.css', null, null);
wp_register_style('skeleton_fw', 		THEMEURL . 'css/skeleton.css', null, null);

wp_register_style('isotope',	 		THEMEURL . 'css/isotope.css', null, null);
wp_register_style('flexslider',			THEMEURL . 'js/flexslider/flexslider.css', null, null);

wp_register_style('shadowbox',			THEMEURL . 'js/shadowbox/shadowbox.css', null, null);

wp_register_style('kolor_layout', 		THEMEURL . 'css/layout.css', null, null);
wp_register_style('kolor_highres', 		THEMEURL . 'css/highres.css', null, null);



// Register Fonts
foreach($theme_fonts as $font => $font_urls)
{
	foreach($font_urls as $i => $font_url)
	{
		$id = is_string($i) ? $i : $i + 1;
		wp_register_style("{$font}_{$id}", $font_url, null, null);
	}
}


/* Resources import on Frontend */
wp_enqueue_script('kolor_vars');

add_action('wp_enqueue_scripts', 'kolor_enqueue_scripts_frontend');

function kolor_enqueue_scripts_frontend()
{
	$theme_fonts = unserialize(THEME_FONTS);
	
	// CSS
	wp_enqueue_style('skeleton_base');
	wp_enqueue_style('skeleton_fw');

		// Set Selected Font First
		$font_type = get_option('kolor_font_type');
		
		if( ! $theme_fonts[$font_type])
			$font_type = reset(array_keys($theme_fonts));
		
		$selected_font = $theme_fonts[$font_type];

	
	// Kolor Style under Development
	if(KOLOR_DEV)
	{
		wp_enqueue_style('droid_sans', 'http://fonts.googleapis.com/css?family=Dosis:400,500,600,700');
		wp_enqueue_style('volkorn', 'http://fonts.googleapis.com/css?family=Vollkorn:400,700');

		wp_enqueue_script('less');
	}
	else
	{
		foreach($selected_font as $i => $font_url)
		{
			$id = is_string($i) ? $i : $i + 1;
			wp_enqueue_style("{$font_type}_{$id}");
		}
		
		wp_enqueue_style('kolor_layout');
	}
	
	if(get_option('kolor_retina_ready_enable') == 'true')
		wp_enqueue_style('kolor_highres');

	# Custom Stylesheet (Applied by WordPress site owner)
	wp_enqueue_style('main-style', THEMEURL . 'style.css');
	
	
	
	// JavaScript
	wp_enqueue_script('jquery');
	wp_enqueue_script('jquery_ui');
	wp_enqueue_script('jquery_easing');
	
	wp_enqueue_script('masonry'); # Images Loaded Function (for each page)
	
	# Animation Engine
	wp_enqueue_script('greensock');
	wp_enqueue_script('greensock_easing');
	

	# Responsive
	wp_enqueue_script('kolor_winres');
	wp_enqueue_script('kolor_mobilemenu');
	
	# Main JS File
	wp_enqueue_script('kolor_custom');
	
	# Responsive
	wp_enqueue_script('kolor_mediahelper');
}


# Post ID Constant
add_action('get_header', 'post_id_constant');

function post_id_constant()
{
	global $post_id;
	
	define("CURRENT_POST_ID", $post_id);
}