<?php
/**
 *	LaboratorBlogStats
 *
 *	Twitter Widget by Arlind Nushi
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */


class LaboratorBlogStats extends WP_Widget {

	public static $self_instance;
	
	public function __construct()
	{
		parent::__construct(false, '[Laborator] Blog Stats', array('description' => 'Show your blog stats for the public. This widget is developed by Laborator team.'));
		
		self::$self_instance = $this;
		
		add_action('save_post', 'laborator_blogstats_save_post');
		
		function laborator_blogstats_save_post()
		{			
			LaboratorBlogStats::$self_instance->check_for_stats(true);
		}
	}
	
	
	public function widget($args, $instance)
	{
		extract($args);
		
		$description = $instance['description'];
		
		// Before Widget
		echo PHP_EOL . $before_widget;
		
		// Display Title
		$title = apply_filters('widget_title', empty($instance['title']) ? 'Tweets' : $instance['title'], $instance, $this->id_base);
		
		if($title)
			echo PHP_EOL . $before_title . $title . $after_title . PHP_EOL;
		
		echo wpautop(trim($description));
		
		$this->check_for_stats();
		
		$blog_posts_count = get_option("laborator_blog_posts_count");
		$tags_count = get_option("laborator_tags_count");
		$authors_count = get_option("laborator_authors_count");
		
		?>		
		<!-- stats section (list) -->
		<ul class="stats">
		
			<?php if($instance['blog_posts_count'] == 1): ?><li><span><?php echo $blog_posts_count < 10 ? "0{$blog_posts_count}" : $blog_posts_count; ?></span> <?php echo _x('Blog Posts', 'Blog Stats Widget', TD); ?></li><?php endif; ?>
			<?php if($instance['tags_count'] == 1): ?><li><span><?php echo $tags_count < 10 ? "0{$tags_count}" : $tags_count; ?></span> <?php _e('Tags', TD); ?></li><?php endif; ?>
			<?php if($instance['authors_count'] == 1): ?><li><span><?php echo $authors_count < 10 ? "0{$authors_count}" : $authors_count; ?></span> <?php _e('Authors', TD); ?></li><?php endif; ?>
		</ul>
		<!-- end: stats section -->
		<?php
		
		// After Widget
		echo $after_widget . PHP_EOL;
	}
	
	
	public function update($new_instance, $old_instance)
	{
		// Title		
		$title = $_POST['title'];
		$old_instance['title'] = $title;
		
		// Description		
		$description = $_POST['description'];
		$old_instance['description'] = $description;
		
		
		$old_instance['blog_posts_count'] = $_POST['blog_posts_count'] ? 1 : -1;
		$old_instance['tags_count'] = $_POST['tags_count'] ? 1 : -1;
		$old_instance['authors_count'] = $_POST['authors_count'] ? 1 : -1;
		
		return $old_instance;
	}
	
	
	public function form($instance)
	{	
		?>
		<p>
			<label for="title">Display Title:</label>
			<input type="text" id="title" name="title" value="<?php echo $instance['title']; ?>" />
		</p>
		
		
		<p>
			<label for="description">Description:</label>
			<textarea name="description" id="description" cols="28" rows="5"><?php echo stripslashes($instance['description']); ?></textarea>
		</p>
		

		<p>
			<label>
				<input type="checkbox" id="blog_posts_count" name="blog_posts_count" value="1"<?php echo $instance['blog_posts_count'] != -1 ? ' checked="checked"' : ''; ?> />
				Blog posts count
			</label>
			<br />
			<label>
				<input type="checkbox" id="tags_count" name="tags_count" value="1"<?php echo $instance['tags_count'] != -1 ? ' checked="checked"' : ''; ?> />
				Tags count
			</label>
			<br />
			<label>
				<input type="checkbox" id="authors_count" name="authors_count" value="1"<?php echo $instance['authors_count'] != -1 ? ' checked="checked"' : ''; ?> />
				Authors count
			</label>
		</p>
		
		<?php
	}
	
	
	public function check_for_stats($force = false)
	{
		global $wpdb;
		
		$timeout = get_option('laborator_stats_check_timeout');
		$dtimeout = 3600;
		
		
		if(time() > $timeout || $force)
		{				
			$wpdb->get_results( $wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_type = '%s' GROUP BY post_author", array('post')) );
			$total_authors = $wpdb->num_rows;
			
			
			update_option('laborator_blog_posts_count', wp_count_posts('post')->publish);
			update_option('laborator_tags_count', wp_count_terms('post_tag'));
			update_option('laborator_authors_count', $total_authors);
			
					
			update_option('laborator_stats_check_timeout', time() + $dtimeout);
		}
	}
	
}

// Register widget
add_action('widgets_init', 'init_laborator_blog_stats_widget');

function init_laborator_blog_stats_widget(){
	
	register_widget('LaboratorBlogStats');

}