<?php
/**
 *	LaboratorSubscribe
 *
 *	Latest Portfolio Items Widget by Arlind Nushi
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */


class LaboratorLatestPortfolioItems extends WP_Widget {
	
	public function __construct()
	{
		parent::__construct(false, '[Laborator] Latest Portfolio Items', array('description' => 'Widget to show up as a photostream the latest of your work - portfolio.'));
	}
	
	
	public function widget($args, $instance)
	{
		extract($args);
		
		// Before Widget
		echo PHP_EOL . $before_widget;
		
		// Display Title
		$title = apply_filters('widget_title', empty($instance['title']) ? 'Tweets' : $instance['title'], $instance, $this->id_base);
		
		if($title)
			echo PHP_EOL . $before_title . $title . $after_title . PHP_EOL;
		
		# Cache Timeout
		$cache_timeout = 600; # 10 minutes
		
		# Items Count
		$items_count = $instance['items_count'];
		
		# Items array (cached)
		$portfolio_items = get_transient('laborator_portfolio_latest_items');
		
		# Ordering
		$order_by = $instance['order_by'];
		$order_type = $instance['order_type'] == 'ASC' ? 'ASC' : 'DESC';
		
		if( ! $portfolio_items)
		{
			$items_count = $items_count > 0 ? $items_count : 24;
			
			$portfolio_items = get_posts(array('post_type' => 'portfolio', 'posts_per_page' => $items_count, 'orderby' => 'date', 'order' => $order_type));
			
			foreach($portfolio_items as $portfolio_item)
			{
				$portfolio_item->views = get_portfolio_item_views($portfolio_item->ID, TRUE);
				$portfolio_item->likes = get_portfolio_item_likes($portfolio_item->ID, TRUE);
			}
			
			define('LABORATOR_PL_ORDER_TYPE', $order_type);
			
			if($order_by == 'views')
			{
				uasort($portfolio_items, array(&$this, 'order_by_views'));
			}
			elseif($order_by == 'likes')
			{
				uasort($portfolio_items, array(&$this, 'order_by_likes'));
			}
			
			
			set_transient('laborator_portfolio_latest_items', $portfolio_items, $cache_timeout);
		}
		
		
		?>
		<div class="portfolio_sneakpeak">
		<?php
		foreach($portfolio_items as $portfolio_item):
		?>
		<a href="<?php echo get_permalink($portfolio_item->ID); ?>" class="portfolio_small_item"><?php echo laborator_show_img($portfolio_item->ID, 'min-thumb'); ?></a>
		<?php
		endforeach;
		?>
		</div>
		<?php
		
		// After Widget
		echo $after_widget . PHP_EOL;
	}
	
	
	public function update($new_instance, $old_instance)
	{
		# Delete Transient
		delete_transient('laborator_portfolio_latest_items');
		
		// Title		
		$title = $_POST['title'];
		$old_instance['title'] = $title;
		
		// Items Count		
		$items_count = $_POST['items_count'];
		$old_instance['items_count'] = $items_count;
		
		// Order Column		
		$order_by = $_POST['order_by'];
		$old_instance['order_by'] = $order_by;
		
		
		// Order Type		
		$order_type = $_POST['order_type'];
		$old_instance['order_type'] = $order_type;
		
		return $old_instance;
	}
	
	
	public function form($instance)
	{	
		if( ! $instance['items_count'])
			$instance['items_count'] = 24;
		
		$order_by = $instance['order_by'];
		$order_type = $instance['order_type'];
		?>
		<p>
			<label for="title">Display Title:</label>
			<input type="text" id="title" name="title" style="width: 220px;" value="<?php echo $instance['title']; ?>" />
		</p>
		
		<p>
			<label for="items_count">Items Count:</label>
			
			<br />
			
			<select name="items_count" style="width: 220px; margin-top: 5px;">
			<?php for($i=4; $i<=30; $i+=2): ?>
			<option<?php echo $instance['items_count'] == $i ? ' selected="selected"' : ''; ?>><?php echo $i; ?></option>
			<?php endfor; ?>
			</select>
		</p>
		
		<p>
			<label for="order_type">Order Column & Type:</label>
			
			<br />
			
			<select name="order_by" style="width: 220px; margin-top: 5px;">
				<option value="date">Date</option>
				<option value="likes"<?php echo $order_by == 'likes' ? ' selected="selected"' : ''; ?>>Likes</option>
				<option value="views"<?php echo $order_by == 'views' ? ' selected="selected"' : ''; ?>>Views</option>
			</select>
			
			<select name="order_type" style="width: 220px; margin-top: 5px;">
				<option value="ASC">Ascending</option>
				<option value="DESC"<?php echo $order_type != 'ASC' ? ' selected="selected"' : ''; ?>>Descending</option>
			</select>
		</p>
		<?php
	}
	
	
	public function order_by_views($a, $b)
	{
		$order_type = LABORATOR_PL_ORDER_TYPE;
		
		if($order_type == 'DESC')
		{
			return $a->views > $b->views ? -1 : 1;
		}
		
		return $a->views < $b->views ? -1 : 1;
	}
	
	
	public function order_by_likes($a, $b)
	{
		$order_type = LABORATOR_PL_ORDER_TYPE;
		
		if($order_type == 'DESC')
		{
			return $a->likes > $b->likes ? -1 : 1;
		}
		
		return $a->likes < $b->likes ? -1 : 1;
	}
	
}

// Register widget
add_action('widgets_init', 'init_laborator_portfolio_latest_widget');

function init_laborator_portfolio_latest_widget(){
	
	register_widget('LaboratorLatestPortfolioItems');

}