<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	WordPress Module for adding 'Views' counter feature to the posts!
 */


/* Add +1 View Count */
function portfolio_item_set_impression($post_id)
{
	$post = get_post($post_id);
	
	if($post)
	{	
		if(is_item_viewed($post_id) == -1)
		{
			$session_id = session_id();
			$post_views = get_portfolio_item_views($post_id);
			
			$post_views[$session_id] = array('time' => time(), 'ip' => $ip, 'user' => get_current_user_id());
			
			update_post_meta($post_id, 'laborator_post_views', $post_views);
			
			return TRUE;
		}
	}
	
	return FALSE;
}


/* Check If portfolio item is viewed already */
function is_item_viewed($post_id)
{
	$post = get_post($post_id);
	$status = 0;
	
	if($post)
	{	
		$post_views = get_portfolio_item_views($post_id);
			
		$arr_key = '';
		
		$session_id = session_id();
		
		if( ! isset($post_views[$session_id]))
		{
			$status = -1;
		}
		else
		{
			$status = 1;
		}
	}
	
	return $status;
}


/* Get views for a portfolio item */
function get_portfolio_item_views($post_id, $count = FALSE)
{
	$post_views = get_post_meta($post_id, 'laborator_post_views', TRUE);
		
	if( ! is_array($post_views))
		$post_views = array();
	
	if($count)
		return count($post_views);
	
	return $post_views;
}