/* WYSIWYG Shortcode Buttons for Better User Experience */
(function()
{
	// Defined vars: laborator_wysiwyg_images
	
	tinymce.create('tinymce.plugins.laborator_wysiwyg', 
	{
		createControl: function(id, controlManager)
		{
			// Laborator 'block' Shortcode Button
			if(id == 'laborator_block')
			{
				var button = controlManager.createButton('laborator_block', {
                    title : 'Add Content Block',
                    image : laborator_wysiwyg_images + 'block.png',
                    onclick : function()
                    {
                    	var ed = tinymce.activeEditor;
                    	var selected = ed.selection.getContent();
                    	
                    	tinymce.execCommand('mceInsertContent', false, '[block]<br><br>');
                    	
                    	tinymce.execCommand('mceInsertContent', false, selected);
                    	var bm = ed.selection.getBookmark();
                    	tinymce.execCommand('mceInsertContent', false, '<br><br>');
                    	
                    	tinymce.execCommand('mceInsertContent', false, '[/block]');
                    	ed.selection.moveToBookmark(bm);
                    }
                });
                
                return button;
			}
			else
			// Laborator 'cols' Shortcode Button
			if(id == 'laborator_cols')
			{
				var button = controlManager.createButton('laborator_cols', {
                    title : 'Add Columns',
                    image : laborator_wysiwyg_images + 'columns.png',
                    onclick : function()
                    {
                    	tb_show( 'Insert Columns', '#TB_inline?width=500&height=300&inlineId=laborator_wysiwyg_cols' );
                    }
                });
                
                return button;
			}
			else
			// Laborator 'dropcap' Shortcode Button
			if(id == 'laborator_dropcap')
			{
				var button = controlManager.createButton('laborator_dropcap', {
                    title : 'Start with Dropcap',
                    image : laborator_wysiwyg_images + 'dropcap.png',
                    onclick : function()
                    {
                    	var ed = tinymce.activeEditor;
                    	var selected = ed.selection.getContent();
                    	
                    	tinymce.execCommand('mceInsertContent', false, '[dropcap]');
                    	
                    	tinymce.execCommand('mceInsertContent', false, selected);
                    	var bm = ed.selection.getBookmark();
                    	
                    	tinymce.execCommand('mceInsertContent', false, '[/dropcap]');
                    	ed.selection.moveToBookmark(bm);
                    }
                });
                
                return button;
			}
			else
			// Laborator 'code' Shortcode Button
			if(id == 'laborator_code')
			{
				var button = controlManager.createButton('laborator_code', {
                    title : 'Code',
                    image : laborator_wysiwyg_images + 'code.png',
                    onclick : function()
                    {
                    	var ed = tinymce.activeEditor;
                    	var selected = ed.selection.getContent();
                    	
                    	tinymce.execCommand('mceInsertContent', false, '[code]');
                    	
                    	tinymce.execCommand('mceInsertContent', false, selected);
                    	var bm = ed.selection.getBookmark();
                    	
                    	tinymce.execCommand('mceInsertContent', false, '[/code]');
                    	ed.selection.moveToBookmark(bm);
                    }
                });
                
                return button;
			}
			else
			// Laborator 'button' Shortcode Button
			if(id == 'laborator_button')
			{
				var button = controlManager.createButton('laborator_button', {
                    title : 'Add Button-Link',
                    image : laborator_wysiwyg_images + 'button.png',
                    onclick : function()
                    {
                    	var ed = tinymce.activeEditor;
                    	var selected = ed.selection.getContent();
                    	
                    	jQuery("#laborator_button_text").val(selected);
                    	
                    	tb_show( 'Add Button-Link', '#TB_inline?width=700&inlineId=laborator_wysiwyg_button' );
                    }
                });
                
                return button;
			}
			else
			// Laborator 'alert' Shortcode Button
			if(id == 'laborator_alert')
			{
				var button = controlManager.createButton('laborator_alert', {
                    title : 'Alert Message',
                    image : laborator_wysiwyg_images + 'alert.png',
                    onclick : function()
                    {
                    	var ed = tinymce.activeEditor;
                    	var selected = ed.selection.getContent();
                    	
                    	jQuery("#laborator_alert_text").val(selected);
                    	
                    	tb_show( 'Alert Message', '#TB_inline?width=800&height=600&inlineId=laborator_wysiwyg_alert' );
                    }
                });
                
                return button;
			}
			else
			// Laborator 'tabs' Shortcode Button
			if(id == 'laborator_tabs')
			{
				var button = controlManager.createButton('laborator_tabs', {
                    title : 'Tabs',
                    image : laborator_wysiwyg_images + 'tabs.png',
                    onclick : function()
                    {
                    	var ed = tinymce.activeEditor;
                    	
                    	tb_show( 'Insert Tabbed Content', '#TB_inline?width=800&height=600&inlineId=laborator_wysiwyg_tabs' );
                    	
                    	//laborator_set_tab_entries(1);
                    }
                });
                
                return button;
			}
			else
			// Laborator 'youtube' Shortcode Button
			if(id == 'laborator_youtube')
			{
				var button = controlManager.createButton('laborator_youtube', {
                    title : 'YouTube Link',
                    image : laborator_wysiwyg_images + 'youtube.png',
                    onclick : function()
                    {                    	
                    	var youtube_link = prompt('Enter YouTube Link', 'http://youtube.com/watch?v=video_id');
                    	
                    	if(youtube_link.length > 10)
	                    	tinymce.execCommand('mceInsertContent', false, '[youtube href="' + youtube_link + '"]');
                    }
                });
                
                return button;
			}
			else
			// Laborator 'vimeo' Shortcode Button
			if(id == 'laborator_vimeo')
			{
				var button = controlManager.createButton('laborator_vimeo', {
                    title : 'Vimeo Link',
                    image : laborator_wysiwyg_images + 'vimeo.png',
                    onclick : function()
                    {                    	
                    	var vimeo_link = prompt('Enter YouTube Link', 'http://vimeo.com/video_id');
                    	
                    	if(vimeo_link.length > 10)
                    		tinymce.execCommand('mceInsertContent', false, '[vimeo href="' + vimeo_link + '"]');
                    }
                });
                
                return button;
			}
			
			return null;
		}
	});
	
	tinymce.PluginManager.add('laborator_wysiwyg', tinymce.plugins.laborator_wysiwyg);
	
	function setCursor(ed, node, start, return_node){

		tn = ed.getDoc().createTextNode(".");
		if (start){
			node.insertBefore(tn, node.firstChild);
		} 
		else 
			node.appendChild(tn);
		
		rng = ed.selection.getRng();
		rng.selectNode(tn);
		rng.setStartBefore(tn);
		rng.setStartAfter(tn);
		
		ed.selection.setRng(rng);
		
		if (return_node) return tn;
		
		node.removeChild(tn);
	}
})();