<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */


	# Shortcodes Supported by this theme 
	add_shortcode('block', 		'_shortcode_block');
	add_shortcode('row', 		'_shortcode_row');
	add_shortcode('cols', 		'_shortcode_cols');
	add_shortcode('dropcap',	'_shortcode_dropcap');
	add_shortcode('code',		'_shortcode_code');
	add_shortcode('button',		'_shortcode_button');
	add_shortcode('tabs',		'_shortcode_tabs');
	add_shortcode('tab',		'_shortcode_tab');
	add_shortcode('accordion',	'_shortcode_accordion');
	add_shortcode('alert',		'_shortcode_alert');
	add_shortcode('youtube',	'_shortcode_youtube');
	add_shortcode('vimeo',		'_shortcode_vimeo');
	

	# [block] shortcode
	function _shortcode_block($atts, $content = '')
	{		
		$default_atts = array(
			'title' => null
		);
		
		# Shortcode the content inside
		$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		# Show Title (optional)
		if($title || (!isset($atts['title'])))
		{
			if( ! isset($atts['title']))
				$title = get_the_title();
			
			$show_title = '<h2 class="ct_title">';
			$show_title .= $title;
			$show_title .= '</h2>';
		}
		
		# Prepare Output
		$output = <<<EOD
<div class="container white_block content_block">
	{$show_title}
	{$content}
</div>
EOD;
		
		return $output;
	}
	
	
	function _shortcode_row($atts, $content = '')
	{
		$default_atts = array(
			'sep' => 0, # Add Separator
		);
			
		# Shortcode the content inside
		$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		# Separator
		$separator = '';
		
		if($sep)
		{
			$separator = '<div class="separator"></div>';
		}
		
		
		# Prepare Output
		$output = <<<EOD
{$separator}
<div class="row">
	{$content}
</div>
EOD;
		
		return $output;
	}
	
	
	function _shortcode_cols($atts, $content = '')
	{
		$number_of_cols = array(
			2 => 'two columns',
			4 => 'four columns',
			8 => 'eight columns',
			16 => 'sixteen columns',
			'1-3' => 'one-third column',
			'2-3' => 'two-third column',
			'1-2' => 'eight columns'
		);
		
		$default_atts = array(
			'num' => 16, # Columns Number
		);
		
		# Shortcode the content inside
		$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		# Number of columns
		if( ! $number_of_cols[$num])
			$num = $default_atts['num'];
		
		$class = $number_of_cols[$num];	
		
		# Prepare Output
		$output = <<<EOD
<div class="{$class}">
	{$content}
</div>
EOD;
		
		return $output;
	}
	
	
	function _shortcode_dropcap($atts, $content = '')
	{
		$default_atts = array(
		);
		
		# Shortcode the content inside
		$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		# Prepare Output
		$output = <<<EOD
<p class="dropcap">
	{$content}
</p>
EOD;
	
		return $output;
	}
	
	
	function _shortcode_button($atts, $content = '')
	{
		$valid_button_types = array('read','buy','download');
		
		$default_atts = array(
			'type' => '', # read,buy,download
			'href' => '#',
			'target' => '',
		);
		
		# Shortcode the content inside
		$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		$type = strtolower($type);
		
		if( ! in_array($type, $valid_button_types))
			$type = $default_atts['type'];
		
		$href = esc_attr($href);
		$target = esc_attr($target);
		
		$button_type = "button {$type}";
		
		# Prepare Output
		$output = '<a href="' . $href . '" target="' . $target . '" class="' . $button_type . '"><span>' . $content . '</span></a>';
	
		return $output;
	}
	
	
	function _shortcode_code($atts, $content = '')
	{
		$default_atts = array(
		);
		
		# Shortcode the content inside
		#$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		# Prepare Output
		$output = <<<EOD
<pre>{$content}</pre>
EOD;
	
		return $output;
	}
	
	
	function _shortcode_tabs($atts, $content = '')
	{
		$default_atts = array(
		);
		
		# Shortcode the content inside
		#$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		# Tabs		
		$pattern = get_shortcode_regex();
		
		preg_match_all("/{$pattern}/", $content, $matches);
		
		$tabs = $matches[0];
		$tab_attrs = $matches[3];
		$tab_contents = $matches[5];
		
		#print_r($matches);
		#exit;
		
		extract($atts);
		
		# Prepare Output
		$output = '<div class="tabs">';
		
			# Tab Titles
			$output .= '<ul>';
			
			foreach($tabs as $i => $tab)
			{
				$id = $i + 1;
				$is_current = preg_match("/current=(\"|\')(.*?)(\"|\')/", $tab_attrs[$i]);
				
				preg_match("/title=(\"|\')(.*?)(\"|\')/", $tab_attrs[$i], $tab_title);
				
				$output .= '<li'.($i == 2 ? ' class="active")' : '').'>';
				$output .= '<a href="#tab-' . $id . '"' . ($is_current ? ' class="current"' : '') . '>' . $tab_title[2] . '</a>';
				$output .= '</li>';
			}
			
			$output .= '</ul>';
			
			
			# Tab Contents
			foreach($tabs as $i => $tab)
			{
				$id = $i + 1;
				
				$output .= '<div id="tab-' . $id . '">';
				$output .= $tab_contents[$i];
				$output .= '</div>';
			}
		
		$output .= '</div>';
		
	
		return $output;
	}
	
	
	function _shortcode_tab($atts, $content = '')
	{
		return '';
	}
	
	
	function _shortcode_accordion($atts, $content = '')
	{
		$default_atts = array(
		);
		
		# Shortcode the content inside
		#$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		# Tabs		
		$pattern = get_shortcode_regex();
		
		preg_match_all("/{$pattern}/", $content, $matches);
		
		$tabs = $matches[0];
		$tab_attrs = $matches[3];
		$tab_contents = $matches[5];
		
		#print_r($matches);
		#exit;
		
		extract($atts);
		
		# Prepare Output
		$output = '<div class="accordion">';
		
			# Tab Toggles
			
			foreach($tabs as $i => $tab)
			{
				$is_current = preg_match("/current=(\"|\')(.*?)(\"|\')/", $tab_attrs[$i]);
				
				preg_match("/title=(\"|\')(.*?)(\"|\')/", $tab_attrs[$i], $tab_title);
				
				$output .= '<h3><a href="#"' . ($is_current ? ' class="current"' : '') . '>' . $tab_title[2] . '</a></h3>';
				$output .= '<div>';
				$output .= $tab_contents[$i];
				$output .= '</div>';
			}
			
		
		$output .= '</div>';
		
	
		return $output;
	}
	
	
	function _shortcode_alert($atts, $content = '')
	{
		$valid_alert_types = array('info','warning','success','error');
		
		$default_atts = array(
			'type' => reset($valid_alert_types)
		);
		
		# Shortcode the content inside
		$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		$type = strtolower($type);
		
		if( ! in_array($type, $valid_alert_types))
			$type = $default_atts['type'];
			
		
		$alert_type = "alert {$type}";
		
		# Prepare Output
		$output = '<div class="' . $alert_type . '">';
		$output .= $content;
		$output .= '</div>';
	
		return $output;
	}
	
	
	# Insert Youtube Link
	function _shortcode_youtube($atts, $content = '')
	{		
		$default_atts = array(
			'width' => 560,
			'height' => 360,
			'href' => ''
		);
		
		# Shortcode the content inside
		$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		# Numeric width and height
		if( ! is_numeric($width) || $width < 1)
		{
			$width = $default_atts['width'];
		}
		
		if( ! is_numeric($height) || $height < 1)
		{
			$height = $default_atts['height'];
		}
		
		# Youtube ID
		preg_match("#v=(\w+)#", $href, $youtube_video_id);
		$youtube_video_id = end($youtube_video_id);
		
		$href = "http://www.youtube.com/v/{$youtube_video_id}";
		
		# Prepare Output
		$output = '<div class="youtube_link">';
		$output .= '<iframe width="' . $width . '" height="' . $height . '" src="' . $href . '" frameborder="0" allowfullscreen></iframe>';
		$output .= '</div>';
	
		return $output;
	}
	
	
	# Insert Vimeo Link
	function _shortcode_vimeo($atts, $content = '')
	{		
		$default_atts = array(
			'width' => 560,
			'height' => 360,
			'href' => ''
		);
		
		# Shortcode the content inside
		$content = do_shortcode($content);
		
		# Overwrite Default Attributes
		$atts = shortcode_atts($default_atts, $atts);
		
		extract($atts);
		
		# Numeric width and height
		if( ! is_numeric($width) || $width < 1)
		{
			$width = $default_atts['width'];
		}
		
		if( ! is_numeric($height) || $height < 1)
		{
			$height = $default_atts['height'];
		}
		
		# Youtube ID
		preg_match("#com/(\d+)#", $href, $vimeo_video_id);
		$vimeo_video_id = end($vimeo_video_id);
		
		$href = "http://vimeo.com/moogaloop.swf?clip_id={$vimeo_video_id}";
		
		# Prepare Output
		$output = '<div class="vimeo_link">';
		$output .= '<iframe width="' . $width . '" height="' . $height . '" src="' . $href . '" frameborder="0" allowfullscreen></iframe>';
		$output .= '</div>';
	
		return $output;
	}
	
	
	
	# Shortcode Helper (Editor Buttons)
	if(current_user_can('edit_posts') || current_user_can('edit_pages'))
	{
		add_filter('mce_buttons', 'laborator_wysiwyg_shortcode_buttons');
		add_filter('mce_external_plugins', 'laborator_wysiwyg_plugins');
		
		add_action('admin_print_scripts', 'laborator_shortcodes_admin_print_scripts');
		
		function laborator_shortcodes_admin_print_scripts()
		{
			?>
			<script type="text/javascript">
				var laborator_wysiwyg_images = '<?php echo THEMEURL; ?>images/admin/';
			</script>
			<?php
		}
		
		# Shortcode WYSIWYG Templates
		add_action('admin_footer', 'laborator_shortcodes_admin_footer');
		
		function laborator_shortcodes_admin_footer()
		{
			?>
			<style>
				.laborator_template {
					display: none;
				}
				
				#add_row_separator {
				}
				
				
				.row_sep_container {
					margin-top: 15px;
					display: none;
				}
				
				#insert_new_row:checked ~ .row_sep_container {
					display: block;
				}
				
				.btn_type {
					background: url(<?php echo THEMEURL; ?>images/admin/button_types.png) no-repeat left top;
					width: 150px;
					padding-top: 55px;
					font-weight: bold;
					margin-right: 10px;
					text-align: center;
					display: block;
					margin-bottom: 8px;
					float: left;
				}
				
				.btn_type.simple {
					background-position: -454px 0px;
					width: 135px;
				}
				
				.btn_type.readmore {
					background-position: -300px 0px;
					width: 145px;
				}
				
				.btn_type.download {
					background-position: -5px 0px;
					width: 145px;
				}
				
				.btn_type.buynow {
					background-position: -155px 0px;
					width: 145px;
				}
				
				.insert_tabs_entries {
					width: 600px;
					max-height: 380px;
					overflow: auto;
					display: none;
				}
				
				.clear {
					clear: both;
				}
				
				.tab_entry {
					display: none;
				}
				
				.tentry {
					background: #FAFAFA;
					border: 1px solid #F0F0F0;
					padding: 8px;
					border-radius: 8px;
					width: 500px;
					margin-top: 10px;
				}
				
				.tentry h3 {
					margin: 0px;
					padding: 0px;
					font-size: 12px;
					text-transform: uppercase;
				}
				
				.tentry .laborator_current_tab {
					float: right;
					margin-right: 8px;
				}
				
				.tentry .tab_title_input {
					width: 492px;
					margin-bottom: 4px;
					margin-top: 3px;
				}
			</style>
			
			<script type="text/javascript">
			jQuery(function()
			{
				var $ = jQuery;
				
				$("#laborator_wysiwyg_cols #insert_cols_btn").click(function(ev)
				{
					ev.preventDefault();
					
					// Active Editor
					var ed = tinymce.activeEditor;
                    var selected = ed.selection.getContent();
					
					// Fields
					var laborator_cols_num 		= $("#laborator_cols_num");
					var insert_new_row 			= $("#insert_new_row").is(':checked');
					var add_row_separator 		= $("#add_row_separator").is(':checked');
					
					if(insert_new_row)
						ed.execCommand('mceInsertContent', 0, '[row' + (add_row_separator ? ' sep="1"' : '') + ']<br><br>');
					
					ed.execCommand('mceInsertContent', 0, '[cols num="' + laborator_cols_num.val() + '"]<br><br>');
					ed.execCommand('mceInsertContent', false, selected);
					
					var bm = ed.selection.getBookmark();
					
					ed.execCommand('mceInsertContent', 0, '[/cols]');
					
					if(insert_new_row)
						ed.execCommand('mceInsertContent', 0, '<br>[/row]');
					
					ed.selection.moveToBookmark(bm);
					
					tb_remove();
					
					// Reset Form
					laborator_cols_num.find('option').first().attr('selected', true);
					$("#insert_new_row").attr('checked', false);
					$("#add_row_separator").attr('checked', false);
					
				});
				
				$("#laborator_wysiwyg_button #laborator_insert_button").click(function(ev)
				{
					ev.preventDefault();
					
					// Active Editor
					var ed = tinymce.activeEditor;
                    var selected = ed.selection.getContent();
					
					// Fields
					var laborator_button_text 		= $("#laborator_button_text");
					var laborator_button_link 		= $("#laborator_button_link");
					var laborator_button_new_win 	= $("#laborator_button_new_win").is(':checked');
					var laborator_button_type 		= $('.laborator_button_type').filter(':checked').val();
					
					var button_type = '';
					
					switch(laborator_button_type)
					{
						case '2':
							button_type = 'read';
							break;
							
						case '3':
							button_type = 'download';
							break;
							
						case '4':
							button_type = 'buy';
							break;
					}
					
					ed.execCommand('mceInsertContent', false, '[button' + (button_type ? (' type="' + button_type + '"') : '') + ' href="' + laborator_button_link.val() + '"' + (laborator_button_new_win ? ' target="_blank"' : '') + ']');
					ed.execCommand('mceInsertContent', false, laborator_button_text.val());
					//ed.execCommand('mceInsertContent', false, selected);
					
					var bm = ed.selection.getBookmark();
					
					ed.execCommand('mceInsertContent', 0, '[/button]');
					
					ed.selection.moveToBookmark(bm);
					
					tb_remove();
				});
				
				$("#laborator_wysiwyg_alert #laborator_insert_alert").click(function(ev)
				{
					ev.preventDefault();
					
					// Active Editor
					var ed = tinymce.activeEditor;
                    var selected = ed.selection.getContent();
					
					// Fields
					var laborator_alert_text = $("#laborator_alert_text");
					var laborator_alert_type = $('.laborator_alert_type').filter(':checked').val();
					
					var alert_type = '';
					
					switch(laborator_alert_type)
					{
						case '2':
							alert_type = 'warning';
							break;
							
						case '3':
							alert_type = 'success';
							break;
							
						case '4':
							alert_type = 'error';
							break;
						
						default:
							alert_type = 'info';
					}
					
					var text = laborator_alert_text.val();
					
					// Replace New lines
					text = text.replace(/\n/g, '<br>');
					
					ed.execCommand('mceInsertContent', false, '[alert' + (alert_type ? (' type="' + alert_type + '"') : '') + ']');
					ed.execCommand('mceInsertContent', false, text);
					
					var bm = ed.selection.getBookmark();
					
					ed.execCommand('mceInsertContent', 0, '[/alert]');
					
					ed.selection.moveToBookmark(bm);
					
					tb_remove();
				});
				
				
				// Tabs
				$("#laborator_tabs_count").change(function()
				{
					var val = $(this).val();
					
					laborator_set_tab_entries(parseInt(val, 10));
				});
				
				
				$("#laborator_wysiwyg_tabs #laborator_insert_tabs").click(function(ev)
				{
					ev.preventDefault();
					
					// Added Tabs
					var added_tabs = get_added_tabs();
					
					// Active Editor
					var ed = tinymce.activeEditor;
                    var selected = ed.selection.getContent();
					
					// Fields
					var laborator_tabs_type = $("#laborator_tabs_type").val();
					
					var tabs_type = 'tabs';
					
					if(laborator_tabs_type == 'accordion')
						tabs_type = 'accordion';
					
					ed.execCommand('mceInsertContent', false, '[' + tabs_type + ']<br><br>');
					
					for(var i=0; i<added_tabs.length; i++)
					{
						var is_current = added_tabs[i].current;
						var title = added_tabs[i].title;
						var content = added_tabs[i].content;
						
						ed.execCommand('mceInsertContent', false, '[tab title="' + title + '"' + (is_current ? ' current="yes"' : '') + ']');
						ed.execCommand('mceInsertContent', false, content);
						ed.execCommand('mceInsertContent', false, '[/tab]<br><br>');
					}
					
					ed.execCommand('mceInsertContent', false, '[/' + tabs_type + ']');
					
					tb_remove();
					laborator_set_tab_entries(0);
					laborator_set_tab_entries(1);
				});
				
				var current_number_of_tabs = 0;
				
				laborator_set_tab_entries(1);
				
				function laborator_set_tab_entries(number)
				{
					var tab_entry = $($(".tab_entry").html());
					
					var insert_tabs_entries = $(".insert_tabs_entries");
					
					insert_tabs_entries.show();
					
					if(current_number_of_tabs < number)
					{
						// Add Tabs
						for(var i=1; i<=number-current_number_of_tabs; i++)
						{
							var tab_entry_clone = tab_entry.clone();
							
							if(current_number_of_tabs == 0 && i == 1)
							{
								tab_entry_clone.find('input[type="radio"]').attr('checked', 1);
							}
							
							var id = current_number_of_tabs + i;
							
							tab_entry_clone.find('h3').text('Tab ' + id);
							tab_entry_clone.find('.laborator_current_tab').val(id);
							tab_entry_clone.find('textarea').attr({name: 'tab_entry_' + id, id: 'tab_entry_' + id});
							tab_entry_clone.find('input[type="text"]').attr({name: 'tab_entry_text_' + id, id: 'tab_entry_text_' + id});
							
							insert_tabs_entries.append(tab_entry_clone);
						}
					}
					else
					{
						// Remove Tabs
						for(var i=current_number_of_tabs; i>number; i--)
						{
							$(insert_tabs_entries.find('.tentry').get(i-1)).remove();
						}
					}
					
					current_number_of_tabs = number;
				}
				
				function get_added_tabs()
				{
					var insert_tabs_entries = $(".insert_tabs_entries .tentry");
					
					var tab_entries = [];
					
					insert_tabs_entries.each(function()
					{
						var $this = $(this);
						
						var is_current = $this.find('input[type="radio"]').is(':checked');
						var tab_title = $this.find('.tab_title_input').val();
						var tab_text = $this.find('textarea').val();
						
						tab_entries.push({current: is_current, title: tab_title, content: tab_text});
					})
					
					return tab_entries;
				}
			})
			</script>
			
			<?php /* Add Columns Shortcode */ ?>
			<div class="laborator_template" id="laborator_wysiwyg_cols">
				<table class="form-table">
					<tr>
						<th><label for="laborator_cols_num">Number of Columns</label></th>
						<td>
							<select name="laborator_cols_num" id="laborator_cols_num">
								<option value="16">Sixteen Columns</option>
								<option value="1-2">Eight Columns</option>
								<option value="4">Four Columns</option>
								<option value="2">Two Columns</option>
								<option value="1-3">One-Third Column</option>
								<option value="2-3">Two-Third Column</option>
							</select>
							<br />
							<small>specify the number of columns</small>
						</td>
					</tr>
					<tr>
						<th><label for="insert_new_row">Is it new row?</label></th>
						<td>
							<input type="checkbox" name="insert_new_row" id="insert_new_row" />
							<label for="insert_new_row">Create new row break</label>
							
							<div class="row_sep_container">
								<label>
									<input type="checkbox" name="add_row_separator" id="add_row_separator" />
									Add row separator line (at top of the row)
								</label>
							</div>
							
						</td>
					</tr>
				</table>
				
				<p class="submit">
					<input type="button" id="insert_cols_btn" class="button-primary" value="Insert Columns" name="insert_cols_btn" />
				</p>
			</div>
			
			<?php /* Add Button Shortcode */ ?>
			<div class="laborator_template" id="laborator_wysiwyg_button">
				<table class="form-table">
					<tr>
						<th><label for="laborator_button_text">Button Text</label></th>
						<td>
							<input type="text" name="laborator_button_text" id="laborator_button_text" placeholder="Sample Button" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th><label for="laborator_button_link">Link href</label></th>
						<td>
							<input type="text" name="laborator_button_link" id="laborator_button_link" placeholder="http://" class="regular-text" />
						</td>
					</tr>
					<tr>
						<th><label for="laborator_button_new_win">Open in new window:</label></th>
						<td>
							<input type="checkbox" name="laborator_button_new_win" id="laborator_button_new_win" />
						</td>
					</tr>
					<tr>
						<th>Button Type</th>
						<td>
							<label class="btn_type simple">
								<input type="radio" name="laborator_button_type" class="laborator_button_type" value="1" checked="checked" autofocus="yes" />
								<span>Simple button</span>
							</label>
							
							<label class="btn_type readmore">
								<input type="radio" name="laborator_button_type" class="laborator_button_type" value="2"  />
								<span>Read more button</span>
							</label>
							
							<div class="clear"></div>
							
							<label class="btn_type download">
								<input type="radio" name="laborator_button_type" class="laborator_button_type" value="3" />
								<span>Download button</span>
							</label>
							
							<label class="btn_type buynow">
								<input type="radio" name="laborator_button_type" class="laborator_button_type" value="4" />
								<span>Buy button</span>
							</label>
						</td>
					</tr>
				</table>
				
				<p class="submit">
					<input type="button" id="laborator_insert_button" class="button-primary" value="Insert Button" name="laborator_insert_button" />
				</p>
				
			</div>
			
			<?php /* Add Alert Shortcode */ ?>
			<div class="laborator_template" id="laborator_wysiwyg_alert">
				<table class="form-table">
					<tr>
						<th><label for="laborator_alert_text">Alert Text</label></th>
						<td>
							<textarea name="laborator_alert_text" id="laborator_alert_text" cols="50" rows="4" autofocus="1"></textarea>
						</td>
					</tr>
					<tr>
						<th>Alert Type</th>
						<td>
							
							<label>
								<input type="radio" name="laborator_alert_type" class="laborator_alert_type" value="1" checked="checked" />
								Information
							</label>
							<br />
							<label>
								<input type="radio" name="laborator_alert_type" class="laborator_alert_type" value="2" />
								Warning
							</label>
							<br />
							<label>
								<input type="radio" name="laborator_alert_type" class="laborator_alert_type" value="3" />
								Success
							</label>
							<br />
							<label>
								<input type="radio" name="laborator_alert_type" class="laborator_alert_type" value="4" />
								Error
							</label>
						</td>
					</tr>
				</table>
				
				<p class="submit">
					<input type="button" id="laborator_insert_alert" class="button-primary" value="Insert Alert" name="laborator_insert_alert" />
				</p>
				
			</div>
			
			
			<?php /* Add Tabs Shortcode */ ?>
			<div class="laborator_template" id="laborator_wysiwyg_tabs">
				<table class="form-table">
					<tr>
						<th><label for="laborator_tabs_type">Type</label></th>
						<td>	
							<select name="laborator_tabs_type" id="laborator_tabs_type">
								<option value="tabs">Tabs</option>
								<option value="accordion">Accordion</option>
							</select>
						</td>
					</tr>
					<tr>
						<th><label for="laborator_tabs_count">Tabs Count</label></th>
						<td>
							<select name="laborator_tabs_count" id="laborator_tabs_count">
							<?php for($i=1; $i<=10; $i++): ?>
								<option value="<?php echo $i; ?>"><?php echo $i; ?></option>
							<?php endfor; ?>
							</select>
							<br />
							<small>specify the number of tabs to add</small>
						</td>
					</tr>
				</table>
				
				<div class="insert_tabs_entries">
				</div>
				
				
				<div class="tab_entry">
					<div class="tentry">
						<label>
							<input type="radio" name="laborator_current_tab" class="laborator_current_tab" value="x" />
							<h3>Tab #</h3>
						</label>
						
						<input type="text" name="tab_entry_title_x" id="tab_entry_title_x" placeholder="Tab Title" class="tab_title_input" />
						
						<textarea name="tab_entry_x" id="tab_entry_x" cols="67" rows="4"></textarea>
					</div>
				</div>
				
				<p class="submit">
					<input type="button" id="laborator_insert_tabs" class="button-primary" value="Insert Tabs" name="laborator_insert_tabs" />
				</p>
				
			</div>
			<?php	
		}
	}
	
	
	
	function laborator_wysiwyg_shortcode_buttons($buttons)
	{
		array_push($buttons, '|', 'laborator_block', 'laborator_cols', '|', 'laborator_dropcap', 'laborator_code', 'laborator_button', 'laborator_alert', '|', 'laborator_tabs', '|', 'laborator_youtube', 'laborator_vimeo');
		
		return $buttons;
	}
	
	function laborator_wysiwyg_plugins($plugins)
	{	
		$laborator_wysiwyg_url = THEMEURL . 'inc/' . TD . '/laborator_wysiwyg.js';
		
		$plugins['laborator_wysiwyg'] = $laborator_wysiwyg_url;
		
		return $plugins;
	}