<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */


class Kolor_Walker_Nav extends Walker_Nav_Menu {
	
	
	public function start_el( &$output, $item, $depth = 0, $args = array())
	{
		if( ! $item->title)
		{
			$item->title = $item->post_title;
			$item->url = get_permalink($item->ID);
		}
					
		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		
		#$class_names = ' class="'. esc_attr( $class_names ) . '"';
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
		
		$class_names_arr = explode(' ', $class_names);
		
		
		if( in_array('current-menu-item', $class_names_arr) || in_array('current-menu-parent', $class_names_arr) )
		{
			array_push($class_names_arr, 'active');
		}
		
		# Start LI Menu Item
		$menu_item = '<li id="menu-item-' . $item->ID . '" class="' . implode(' ', $class_names_arr) . '">';
		
		# Create Link
		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';
		
		# Start A Menu Item
		$menu_item .= '<a' . $attributes . '>' . apply_filters('the_title', $item->title, $item->ID);
		
			# Add Description (only to level 0)
			$description = $item->description;
			
			if( ! $description && $item->post_excerpt)
				$description = $item->post_excerpt;
			
			if($depth == 0)
			{
				$menu_item .= '<span>' . ($description ? esc_attr($description) : '&nbsp;') . '</span>';
			}
		
		$menu_item .= '</a>';
		
		
		$output .= $menu_item;
		$output .= apply_filters( 'walker_nav_menu_start_el', '', $item, $depth, $args );
		
	}
}