<?php
/**
 *	Laborator
 *
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	Gallery post type metaboxes
 */

class LaboratorInlineMediaMetabox
{
	# Post ID to apply metabox
	private $post_id;
	
	# Title of the Metabox
	private $metabox_title;
	
	# Post
	private $post;
	
	
	public function __construct($post_id = 0, $metabox_title = 'Inline Media Gallery')
	{
		$this->post_id = $post_id;
		$this->metabox_title = $metabox_title;
		
		$this->post = get_post($post_id);
		
		wp_enqueue_script('jquery');
		
		add_action('add_meta_boxes', array($this, 'add_metabox'));
		add_action('admin_print_scripts-media-upload-popup', array($this, 'laborator_inline_media_gallery_iframe_resize'));
		add_action('media_upload_external_gallery', array($this, 'external_media_gallery'));
		
		add_filter('image_send_to_editor', array($this, 'laborator_inline_media_gallery_insert_image'), 10, 3);
		add_filter('media_upload_tabs', array($this, 'media_upload_tabs'));
		
		add_filter('attachment_fields_to_edit', array($this, 'link_to_post_id'), 11, 3);
		add_filter('attachment_fields_to_save', array($this, 'link_to_post_id_save'));
	}
	
	public function add_metabox()
	{
		add_meta_box("laborator_inline_media_metabox", $this->metabox_title, array($this, 'laborator_inline_media_metabox'), $this->post->post_type, 'normal');
	}
	
	public function media_upload_tabs($tabs)
	{
			unset($tabs['type_url']);
			unset($tabs['library']);
			
			$tabs['external_gallery'] = "External Post Slider";
			
			return $tabs;
	}
	
	public function laborator_inline_media_gallery_insert_image()
	{
		$post_id = $_GET['post_id'];
		
		if($post_id == $this->post_id)
		{
			$send = $_REQUEST['send'];
			
			foreach($send as $attachment_id => $text)
			{
				# Check if it already included in the album
				$is_included = get_post($attachment_id)->post_parent;
				
				wp_update_post(array('ID' => $attachment_id, 'post_parent' => ($is_included ? 0 : $post_id)));
			}
			
			wp_redirect(admin_url("media-upload.php?post_id={$post_id}&tab=gallery"));
		}
	}
	
	function laborator_inline_media_metabox($post)
	{
		$post_id = $post->ID;
		
		?>
		<style>
			#laborator_inline_media_metabox .inside {
				margin: 0px;
				padding: 0px;
			}
			
			
			#laborator_inline_media_metabox {
				width: 100%;
				min-height: 400px;
				background: transparent;
			}
			
			#laborator_inline_media_metabox.closed {
				min-height: auto;
			}
			
			.mceIframeContainer {
				background: #FFF !important;
			}
		</style>
		<iframe id="laborator_inline_media_metabox" scrolling="yes" frameborder="0" src="<?php echo admin_url("media-upload.php?post_id={$post_id}&tab=gallery"); ?>"></iframe>
		<?php
	}


	function laborator_inline_media_metabox_iframe_resize()
	{
		$post_id = $_GET['post_id'];
		
		$post = get_post($post_id);
		
		if($post->post_type == $this->post->post_type)
		{
			wp_enqueue_script('jquery');
			
			add_filter('media_upload_tabs', 'inline_media_upload_tabs');
			
			function inline_media_upload_tabs($tabs)
			{
				unset($tabs['type_url']);
				unset($tabs['library']);
				
				return $tabs;
			}
	?>
<style>
#gallery-settings, tr.image-size, tr.url, tr.align {
	display: none;
}

</style>
<script type="text/javascript">
window.onload = function()
{	
	// Other Customizations
	jQuery("#gallery-settings").hide();
	jQuery(".savesend .button").attr('value', 'Add to album');
	jQuery("#gallery-form .savesend .button").attr('value', 'Remove from album');
	
	
	var doc_height = document.height + 25;
	var iframe_parent = parent.document.getElementById('laborator_gallery_images_iframe');
	
	if(iframe_parent && iframe_parent.hasOwnProperty('height'))
	{
		iframe_parent.height = doc_height + 'px';
	}
}
</script>
<?php
		}
	}
	
	
	public function laborator_inline_media_gallery_iframe_resize()
	{
		$post_id = $_GET['post_id'];
		
		$post = get_post($post_id);
			
		?>
<style>
#gallery-settings, tr.image-size, tr.url, tr.align {
	display: none;
}

</style>
<script type="text/javascript">
window.onload = function()
{	
	// Other Customizations
	jQuery("#gallery-settings").hide();
	jQuery("#gallery-form .savesend .button").attr('value', 'Remove image');
	
	
	var doc_height = document.height + 25;
	var iframe_parent = parent.document.getElementById('laborator_inline_media_metabox');
	
	
	if(iframe_parent)
	{
		iframe_parent.height = doc_height + 'px';
	}
}
</script>
<?php
		
	}
	
	public function external_media_gallery()
	{		
		return wp_iframe(array($this, 'view_external_media_gallery'));
	}
	
	public function view_external_media_gallery()
	{
		wp_enqueue_style( 'media' );
		wp_enqueue_script( 'jquery' );
		media_upload_header();
		
		if(isset($_POST['save_external_slider']))
		{
			$post_id = $_REQUEST['post_id'];
			$external_slider_post_id = 	isset($_REQUEST['external_slider_post_id']) ? $_REQUEST['external_slider_post_id'] : '';
			
			update_post_meta($post_id, 'external_slider_post_id', $external_slider_post_id);
			
			?>
			<div id="epe_changes_saved" class="updated"> 
				<p><strong>Changes have been saved.</strong></p>
			</div>
			<?php
		}
		
		$external_slider_post_id = get_post_meta($_REQUEST['post_id'], 'external_slider_post_id', TRUE);
		
		$posts = get_posts(array('post_type' => 'page', 'posts_per_page' => -1));
		
		?>
		<style>
		
			.external_post_entry {
				background: #FAFAFA;
				padding: 5px;
				border-radius: 3px;
				border: 1px solid #EEE;
				margin: 10px 5px 0px 5px;
			}
			
			.external_post_entry  .epe_image {
				float: left;
				margin-right: 10px;
			}
			
			.external_post_entry  .epe_image img {
				display: block;
				padding: 3px;
				background: #FFF;
				box-shadow: 0px 0px 3px rgba(0,0,0,.2);
				max-width: 40px;
				max-height: 40px;
			}
			
			.external_post_entry  .epe_title .date {
				display: block;
				color: #999;
				font-style: italic;
				margin-top: 2px;
			}
			
			.external_post_entry  .epe_check {
				float: right;
				margin-right: 10px;
				margin-top: 15px;
			}
			
			#save_external_slider {
				margin-top: 15px;
			}
			
			.clear {
				clear: both;
			}
			
			#warning_1, #epe_changes_saved {
				margin-top: 15px;
			}
		
		</style>
		<script type="text/javascript">
			jQuery(document).ready(function($)
			{
				var check = $(".external_post_entry .epe_check input");
				
				check.each(function()
				{
					var $this = $(this);
					
					$this.change(function()
					{
						check.not($this).attr('checked', false);
					});
				});
			});
		</script>
		<form method="post" action="">
		<?php
		
		$posts_count = 0;
		
		foreach($posts as $post):
			
			$post_id = $post->ID;
			
			$attachments = get_children(array('post_parent' => $post_id, 'numberposts' => -1));
			$attachments_count = count($attachments);
			$has_attachments = $attachments_count > 0 ? TRUE : FALSE;
			
			if($has_attachments && $_REQUEST['post_id'] != $post_id):
				
				$first_attachment = reset($attachments);
				$attachment_id = $first_attachment->ID;
				
				$title = $post->post_title;
				$date = strtotime($post->post_date);
				
			?>
			<div class="external_post_entry">
				
				<div class="epe_check">
					<input type="checkbox"<?php echo $external_slider_post_id == $post_id ? ' checked="checked"' : ''; ?> name="external_slider_post_id" id="external_slider_post_id_<?php echo $post_id; ?>" value="<?php echo $post_id; ?>" />
				</div>
				
				<div class="epe_image">
				<?php echo wp_get_attachment_image($attachment_id, 'min-thumb', false); ?>
				</div>
				
				<div class="epe_title">
					<label for="external_slider_post_id_<?php echo $post_id; ?>">
						<strong><?php echo $title; ?></strong>
						<span class="date"><?php echo $attachments_count . ($attachments_count == 1 ? ' image' : ' images'); ?></span>
					</label>
				</div>
				
				<div class="clear"></div>
			</div>
			<?php
				$posts_count++;
			endif;
			
		endforeach;
		
		if($posts_count)
		{
			?>
			<button type="submit" class="button" name="save_external_slider" id="save_external_slider">Save Changes</button>
			<?php
		}
		
		?>
			<p class="description" id="warning_1">
				Warning: If you choose to use external slider ID, images attached to this post will not be used.
			</p>
		</form>
		<?php
	}
	

	public function link_to_post_id_save($post)
	{
		$attachment_id = $post['ID'];	

		update_post_meta($attachment_id, 'link_to_post_id', $_POST['attachments'][$attachment_id]['link_to_post_id']);
		
		return $post;
	}
	
	public function link_to_post_id($form_fields, $post)
	{
		$link_to_post_id = get_post_meta($post->ID, 'link_to_post_id', TRUE);
		
		
		$select_posts = '<select name="attachments[' . $post->ID . '][link_to_post_id]" style="width: 460px"><option value="">None</option>';
		
		# Pages
		$posts = get_posts(array('post_type' => 'page', 'orderby' => 'menu_order', 'order' => 'asc'));
		$select_posts .= '<optgroup label="Pages">';
		foreach($posts as $_post)
		{
			$select_posts .= '<option' . ($link_to_post_id == $_post->ID ? ' selected="selected"' : '') . ' value="'.$_post->ID.'">' . $_post->post_title . '</option>';
		}
		
		# Posts
		$posts = get_posts(array('post_type' => 'post', 'orderby' => 'date', 'order' => 'desc'));
		$select_posts .= '<optgroup label="Posts">';
		foreach($posts as $_post)
		{
			$select_posts .= '<option' . ($link_to_post_id == $_post->ID ? ' selected="selected"' : '') . ' value="'.$_post->ID.'">' . $_post->post_title . '</option>';
		}
		
		$select_posts .= '</optgroup>';
		
		$select_posts .= '</select>';
		
		$form_fields['link_to_post_id'] = array(
			'value' => 1,
			'input' => 'html',
			'label' => 'Link to Post',
			'html'	=> $select_posts
		);
		
		return $form_fields;
	}
}




