<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	Template Name: Homepage (Index)
 */

define("IS_HOMEPAGE", TRUE);

# Get Globals
global $post, $wp_query;

# Post ID
$post_id = $post->ID;


# Paged
$paged = isset($wp_query->query['paged']) ? $wp_query->query['paged'] : null;

# Slides
$slider_items = get_posts(array('post_type' => 'attachment', 'post_parent' => $post_id, 'orderby' => 'menu_order', 'order' => 'ASC'));

# Use External Post Images
if($external_slider_post_id = get_post_meta($post_id, 'external_slider_post_id', TRUE))
{
	$slider_items = get_posts(array('post_type' => 'attachment', 'post_parent' => $external_slider_post_id, 'orderby' => 'menu_order', 'order' => 'ASC'));
}

$slider_items_count = count($slider_items);


# Post Meta
if($post_id)
{
	$slider_type				= get_post_meta($post_id, 'slider_type', TRUE);
	$homepage_sections_ordering	= get_post_meta($post_id, 'homepage_sections_ordering');
	$visible_sections 			= get_post_meta($post_id, 'visible_sections', TRUE);
	$clients_logos_show 		= get_post_meta($post_id, 'clients_logos_show', TRUE);
	$blog_posts_per_page 		= get_post_meta($post_id, 'blog_posts_per_page', TRUE);
	$portfolio_rows		 		= get_post_meta($post_id, 'portfolio_rows', TRUE);
	$sidebar_color		 		= get_post_meta($post_id, 'sidebar_color', TRUE);
	
	$homepage_sections_ordering = reset($homepage_sections_ordering);
	$blog_posts_per_page		= is_numeric($blog_posts_per_page) ? $blog_posts_per_page : 5;
	
	
	# Post custom query - filter
	$category_filter = get_post_meta($post_id, 'category_filter', TRUE);
}


# CSS Background Add
$css_add_bg = $post->post_type != 'page' || ! $slider_items_count;


# Import Required Resources
wp_enqueue_script(array('kolor_elmagnifier', 'kolor_hover'));

if($post_id && count($slider_items_count))
{
	switch($slider_type)
	{
		# AsyncSlider
		case 2:
			wp_enqueue_script(array('kolor_asyncslider'));
			$css_add_bg = TRUE;
			break;
			
		# Roundabout Slider
		case 3:
			wp_enqueue_script(array('roundabout_slider'));
			$css_add_bg = TRUE;
			break;
		
		# Wide Slider (default)	
		default:
			wp_enqueue_script(array('kolor_wideslider'));
	}
}

// Header
get_header();


?>
<!-- site header -->
<div class="site_header<?php echo $css_add_bg ? ' bg_02' : ''; ?>">
<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

	
	// Wide Slider
	if($post->post_type == 'page')
	{
		switch($slider_type)
		{
			# AsyncSlider
			case 2:
				get_template_part('tpls/sliders', 'asyncslider');
				break;
				
			# Roundabout Slider
			case 3:
				get_template_part('tpls/sliders', 'roundabout');
				break;
				
			default:
				get_template_part('tpls/sliders', 'wideslider');
		}
	}
?>	
</div>
<!-- end: site header -->

<!-- stripped border -->
<div class="stripped_border"></div>
<!-- end: stripped border -->
<?php

echo '<br />';

# Apply Ordering for Sections
if(is_array($homepage_sections_ordering))
{
	foreach($homepage_sections_ordering as $section_id)
	{
		switch($section_id)
		{
			case 'featured_tabs':
				if($visible_sections[$section_id])
				{
					get_template_part('tpls/blocks', 'featurestabs');
				}
				break;
			
			case 'portfolio':
				if($visible_sections[$section_id])
				{
					get_template_part('tpls/blocks', 'homepageportfolio');
				}
				break;
			
			case 'blog_sidebar':
				if($visible_sections[$section_id])
				{
					// Get Latest Posts From the Blog
					query_posts(array('post_type' => 'post', 'paged' => $paged, 'posts_per_page' => $blog_posts_per_page));
					
					get_template_part('tpls/blocks', 'blogandsidebar');
					
					wp_reset_postdata();
					wp_reset_query();
				}
				break;
			
			case 'content_block':
				if($visible_sections[$section_id])
				{
					get_template_part('tpls/blocks', 'contenthomepage');
				}
				break;
		}
	}
} 
else
{
	get_template_part('tpls/blocks', 'featurestabs');
	
	get_template_part('tpls/blocks', 'homepageportfolio');
	
	// Get Latest Posts From the Blog
	$blog_query = array('post_type' => 'post', 'paged' => $paged, 'posts_per_page' => $blog_posts_per_page);
	
	if(is_array($category_filter) && count($category_filter))
	{
		$blog_query['cat'] = implode(',', $category_filter);
		define("CUSTOM_POSTS_FILTER", TRUE);
	}

	query_posts($blog_query);
	
	get_template_part('tpls/blocks', 'blogandsidebar');
	
	wp_reset_postdata();
	wp_reset_query();
}



// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();