/**
 *	Kolor Theme
 *	
 *	Developed by: Arlind Nushi
 */


// Global Vars
var roundabout_slider;
var portfolio_items, portfolio_items_options;


// On Window Load
jQuery(window).load(function()
{
	jQuery(window).trigger('resize')
});

// On document ready
jQuery(document).ready(function()
{
	// Search Site Placeholder
	jQuery("input#s").attr('placeholder', str_search_site);
	
	/* Menu */
	var subMenuHoverSetup = function(item, level)
	{
		if( ! level)
			level = 1;
		
		var sub_menu = item.find('> ul');
		
		var has_sub_menu = sub_menu.length > 0;
		
		var fade_delay = 400;
		var easing = 'easeInOutQuad';
		
		// Has Sub Menu (1st level)
		if(has_sub_menu)
		{
			
			// Hover In
			item.on('mouseenter', function(ev)
			{
				sub_menu.stop().fadeTo(fade_delay, 1, easing, function()
				{
				});
			});
			
			
			// Hover Out
			item.on('mouseleave', function(ev)
			{
				sub_menu.stop().fadeTo(fade_delay, 0, easing, function()
				{
					sub_menu.hide();
				});
			});
			
			
			// Continue Recusrion
			var sub_menu_items = sub_menu.find('> li');
			
			sub_menu_items.each(function(i)
			{
				var sub_menu_item = jQuery(this);
				
				subMenuHoverSetup(sub_menu_item, parseInt(level, 10)+1);
			});
		}
	}
	
	var main_menu_items = jQuery(".site_header .main_menu > li");
	
	
	main_menu_items.each(function(i)
	{
		var item = jQuery(this);
		
		subMenuHoverSetup(item);
	});
	

	
	
	/* RoundAbout Slider */
	roundabout_slider = jQuery(".roundabout_slider");
	
	var ras_items_length = roundabout_slider.children().length;
	
	var ras_caption = jQuery(".ras_caption");
	var ras_slider_nav = jQuery(".ras_slider_nav");
	
	var getFocusedRASItem = function()
	{
		var focused = roundabout_slider.find('.roundabout-in-focus');
		
		return focused;
	}
	
	var updateCaption = function(no_animation, index)
	{		
		var data = roundabout_slider.data('roundabout');
		index = typeof index != 'undefined' ? index : data.childInFocus
		
		var slide = jQuery(roundabout_slider.children().get(index));
		var caption = slide.data('caption');
		
		var visible_caption = roundabout_slider.data('captions').filter(':visible');
		
		
		setActiveSliderNavIndex(index, true);
		
		if(no_animation)
		{
			visible_caption.hide();
			caption.show();
						
			return;
		}
		
		if(visible_caption.length == 0)
		{
			caption.stop().fadeTo(ras_caption_fade_duration / 2, 1, ras_caption_easing);
		}
		else
		{
			var current_height = ras_caption.height();
			var next_height = caption.height();
			
			ras_caption.stop().css({height: current_height}).animate({height: next_height});
			
		
			visible_caption.stop().fadeTo(data.duration / 2, 0, data.easing, function()
			{
				visible_caption.hide();

				caption.stop().fadeTo(data.duration / 2, 1, data.easing, function()
				{
					// Put your code here (at the end of animation)
				});
			});
		}
	}
	
	var preSetupSlider = function()
	{
		roundabout_slider.data('captions', roundabout_slider.find('.caption'));
		
		var ras_items = roundabout_slider.children();
		
		ras_items.each(function(i)
		{
			var slide = jQuery(this);
			var caption = slide.find('.caption');
			
			slide.data({
				caption: caption
			});
			
			// Re-place the caption
			caption.detach().appendTo(ras_caption).hide();
			
			// Add Slider Nav Button
			if(ras_slider_nav.length)
			{
				var slider_nav_item = jQuery('<a href="#" />');
				slider_nav_item.text(i+1).data('index', i);
				
				ras_slider_nav.append(slider_nav_item);
			}
		});
		
		// Assign Events for Slider Nav
		var ras_slider_nav_items = ras_slider_nav.find('a');
		ras_slider_nav_items.on('click', function(ev)
		{
			ev.preventDefault();
			var $this = jQuery(this);
			
			var index = $this.data('index');
			setActiveSliderNavIndex(index);
		});
	}
	
	var setActiveSliderNavIndex = function(index, no_animate)
	{
		var ras_slider_nav_items = ras_slider_nav.find('a');
		ras_slider_nav_items.removeClass('active');
		
		jQuery(ras_slider_nav_items.get(index)).addClass('active');
		
		if( ! no_animate)
		{
			roundabout_slider.roundabout('animateToChild', index);
		}
	}
	
	if(jQuery.isFunction(roundabout_slider.roundabout) && roundabout_slider.length)
	{
		var ras_items = roundabout_slider.children().show();
		var ras_autoswitch = roundabout_slider.data('autoswitch');
		
		
		var opts = {
			
			startingChild: 0, // index to start on
			
			minOpacity: 0.8,
			maxOpacity: 1,
			
			minScale: 0.85,
			maxScale: 1,
			
			minZ: 1,
			maxZ: 10,
			
			
			shape: 'lazySusan',
			responsive: true,
			enableDrag: false,
			
			autoplayPauseOnHover: false,
			
			
			btnNext: '.ras_nav.next',
			btnPrev: '.ras_nav.prev'
		};
		
		// Parse Some of the attributes
		var _autoplay = roundabout_slider.data('autoplay');
		var _pause_on_hover = roundabout_slider.data('pause-on-hover');
		
		
			if(_autoplay)
			{
				var _autoplay_delay = parseInt(ras_autoswitch, 10);
				
				if(_autoplay_delay > 0)
				{
					opts.autoPlay = true;
					opts.autoplayDuration = _autoplay_delay;
				}
			}
			
			if(_pause_on_hover.toString().toLowerCase() == 'true' || _pause_on_hover == '1' || _pause_on_hover == 'yes')
			{
				opts.autoplayPauseOnHover = true;
			}
		
		preSetupSlider();
		
		
		roundabout_slider.roundabout(opts);
		updateCaption(true);	
		
		roundabout_slider.bind('change', function(e, index)
		{			
			updateCaption(false, index);
		});
		
		jQuery(window).trigger('resize');
	}
	//*/
	
	/* Outer Title Markup */
	var outer_title_table = jQuery('<table />');
	outer_title_table.addClass('outer_title_table').attr('width', '100%');
	
	var otb_row = jQuery('<tr />');
	
	var left_border = jQuery('<td />').addClass('left_border');
	var text_env = jQuery('<td />').addClass('text_env');
	var right_border = jQuery('<td />').addClass('right_border');
	
	otb_row.append(left_border).append(text_env).append(right_border);
	outer_title_table.append(otb_row);
	
	
	
	// Back to Top
	jQuery("a.top, .top a").on('click', function(ev)
	{
		ev.preventDefault();
		
		jQuery("html,body").animate({scrollTop: 0}, {duration: 800, easing: 'easeInOutQuad'});
	});
	
	
	jQuery("h1.title, h2.title, h3.title, h4.title").each(function()
	{
		var $this = jQuery(this);
		var tag_name = $this.get(0).tagName;
		
		var html = $this.html().toString();
		var heading = jQuery('<'+tag_name+' />').html(html);
		
		var table_ins = outer_title_table.clone();
		
		$this.after(table_ins).detach();
		
		table_ins.find('.text_env').html(heading);
		
	});
	
	
	
	// Tweet Roller for Tweets on Footer
	var _show_tweets	= 2; // Tweets per row
	var _tweet_timeout	= 5; // Seconds to switch tweets
	
	var tweets = jQuery(".site_footer ul.tweets");
	
	if(tweets.data('tweets'))
		_show_tweets = parseInt(tweets.data('tweets'), 10);
		
	if(tweets.data('timeout'))
		_tweet_timeout = parseInt(tweets.data('timeout'), 10);
	
	var tweets_ch = tweets.children();
	
	tweets_ch.hide().slice(0, _show_tweets).show();
	
	var _tw_options = {
		container: tweets, 
		tweets: tweets_ch, 
		tweets_per_page: _show_tweets,
		timeout: _tweet_timeout * 1000,
		pause_on_hover: true
	};
	
	var tweet_roller = new TweetRoller(_tw_options);
	
	if(tweets_ch.length > 0)
		tweet_roller.start();
	
	
	// Portfolio Photostream
	var portfolio_sneakpeak = jQuery(".portfolio_sneakpeak");
	
	setupPhotoStream(portfolio_sneakpeak, 6);

		
	// Setup Partners/Client Carousel
	var partners_carousel = jQuery(".partners_carousel");
	
	if(jQuery.isFunction(partners_carousel.anCarousel))
	{
		var anc_timeout = parseInt(partners_carousel.data('autoswitch'), 10) * 1000;
		
		
		partners_carousel.anCarousel({
	        itemsPerRow: 5,
	        autoSlide: anc_timeout,
	        pauseOnHover: true,
	        animationEngine: 'gsap' // jquery or gsap
	    });
	    
	    partnersCarouselFit();
    }
    
    
    // Portfolio Magnifier
    portfolio_items = jQuery(".index_portfolio_env .portfolio_items");
    
    if(jQuery.isFunction(jQuery.fn.elementMagnifier))
    {
    	portfolio_items_options = {
	    	easing: 'swing',
	    	animationEngine: 'gsap'
    	};
    	
    	var _magnify = portfolio_items.data('magnify');
    	
    	if(_magnify)
    	{
	    	portfolio_items_options.magnify = _magnify;
    	}
    	
    	if(jQuery.isFunction(test_device_type) && test_device_type() == 'large_screen')
	    	portfolio_items.elementMagnifier(portfolio_items_options);
    }
    
    
    // Sidebar Height Tailing
    /*var sidebar = jQuery(".homepage_blog_entries .sidebar");
    sbHeightSetup(sidebar);
    
    jQuery(window).load(function()
    {
    	sbHeightSetup(sidebar);
    });*/
    
    
    // Masonry Tags
    if(jQuery.isFunction(jQuery.fn.masonry))
    {
		jQuery('.sidebar .tagcloud').masonry({
			itemSelector : 'a',
			columnWidth : 7
		});
	}
	
	
	// Hover Image [by Arlind Nushi]
	if(jQuery.isFunction(jQuery.fn.imagesLoaded))
	{	
		jQuery(".hover").imagesLoaded(function()
		{
			if(jQuery.isFunction(jQuery.fn.imageHover))
			{
				jQuery(".hover").imageHover({
					background: '#FFF',
					opacity: 0.5,
					responsive: true,
					animationEngine: 'gsap', // jquery or gsap
					
					icon: {
						el: jQuery('<div class="hover_icon" />'),
						setup: function(ic, ol, w, h, opts) { ic.css({top: h + ic.height()}); },
						hoverIn: function(ic, ol, w, h, opts) {
							var top = parseInt(h/2, 10);
							var duration = opts.duration * 0.5;
						
							if(opts.animationEngine == 'gsap') // GreenSock Animation Platform TweenMax
							{
								var ic_el = ic.get(0);
								
								TweenMax.to(ic_el, duration / 1000, {css: {top: top}, yoyo: true, ease: Back.easeInOut});
							}
							else
							if(opts.animationEngine == 'jquery') // jQuery Animation Engine 
							{
								ic.animate({ top: top}, {duration: duration, easing: 'easeInOutBack'}); 
							}
						},
						hoverOut: function(ic, ol, w, h, opts) { 
							
							var top = h + ic.height();
							var duration = opts.duration * 0.5;
						
							if(opts.animationEngine == 'gsap') // GreenSock Animation Platform TweenMax
							{
								var ic_el = ic.get(0);
								
								TweenMax.to(ic_el, duration / 1000, {css: {top: top}, yoyo: true, ease: Back.easeOut});
							}
							else
							if(opts.animationEngine == 'jquery') // jQuery Animation Engine 
							{
								ic.animate({ top: top}, {duration: duration, easing: 'easeInOutBack'}); 
							}
						}
					}
				});
			}
		});
	}
	
	
	
	// Wide Slider
	var wideslider_env = jQuery(".wideslider ul");
	
	if(jQuery.isFunction(wideslider_env.wideslider))
	{
		var autoswitch_timeout = wideslider_env.data('autoswitch');
		
		
		wideslider_env.wideslider({
			animationEngine: 'gsap', // jquery or gsap
			
			delay: 800,
			autoSwitch: autoswitch_timeout,
			//nextPrev: jQuery(".wideslider_nextprev"),
			prevNextOnKeyboard: true,
			sliderNav: jQuery(".wideslider_nav"),
			
			autoCenter: jQuery(".wideslider"),
			autoCenterTop: -25 // Extra Margin to AutoCenter Element
		});
		
		wideslider_env.wideslider('autoCenter');
	}
	
	
	// Async Slider
	var asyncslider = jQuery('.asyncslider');
	if(jQuery.isFunction(asyncslider.asyncSlider))
	{
		var slide_item = asyncslider.find('.slide_item');
		var timeout = asyncslider.data('autoswitch');


		slide_item.first().show();
		asyncslider.asyncSlider({
			prevNextNav: '.asyncslider .container',
			numbersNav: '.asyncslider .container',
			onSetup: function()
			{
				centerAsyncSliderItems();
			},
			// Center Image with text (vertically)
			onSetup: function(){
				
				slide_item.each(function(i)
				{
					var $slide = jQuery(this), do_hide = false;
					
					if( ! $slide.is(':visible'))
					{
						$slide.show();
						do_hide = true;
					}
					
					var $rpart = $slide.find('.right_part');
					var $lpart = $slide.find('.left_part');
					var $img = $lpart.find('img');
					
					var rpart_height = $rpart.height();
					var img_height = $img.height();
					
					if($img.length)
					{
						if(rpart_height > img_height)
						{
							var top_margin = parseInt((rpart_height - img_height)/2, 10);
							
							$img.css({marginTop: top_margin});
						}
					}
					
					if(do_hide)
					{
						$slide.hide();
						do_hide = false;
					}
				})
			}
		});
		
	}
	
	
	// Forms
	var forms = jQuery('form');
	var active_class_marker = 'active';
	
	forms.each(function(i)
	{
		var form = jQuery(this);
		var input_with_placeholders = jQuery('.placeholder .input');
		
		input_with_placeholders.each(function()
		{
			var input = jQuery(this);
			var label = input.prev();
			
			var placeholder_container = jQuery(this).parent();
			
			if( ! placeholder_container.hasClass(active_class_marker))
			{
				input.on('focus', function()
				{
					placeholder_container.addClass(active_class_marker);
				});
				
				input.on('blur', function()
				{
					placeholder_container.removeClass(active_class_marker);
				});
			}
			
			if(input.is('textarea'))
			{
				var input_height = input.outerHeight();
				label.height(input_height);
			}
			
			if(input.hasClass('error'))
			{
				placeholder_container.addClass('error');
			}
		});
	});
	
	
	if(jQuery.isFunction(jQuery.fn.tabs))
	{
		// Tabs
		var tabs = jQuery('div.tabs');
		
		tabs.each(function()
		{
			var tab_env = jQuery(this);
			
			tab_env.tabs();
			
			// Set Current Tab
			var tab_links = tab_env.find('ul a');
			
			tab_links.each(function(i)
			{
				if(jQuery(this).hasClass('current'))
				{
					var wscroll = jQuery(window).scrollTop();
					
					tab_env.tabs('select', i);
					
					jQuery(window).scrollTop(wscroll);
				}
			});
		});
		
		
		// Accordion
		var accordion = jQuery('div.accordion');
		
		accordion.each(function()
		{
			var accordion_env = jQuery(this);
			
			accordion_env.accordion();
			
			// Set Current Tab
			var tab_links = accordion_env.find('h3 a');
			
			tab_links.each(function(i)
			{
				if(jQuery(this).hasClass('current'))
				{
					var wscroll = jQuery(window).scrollTop();
					
					accordion_env.accordion('activate', i);
					
					jQuery(window).scrollTop(wscroll);
				}
			});
		});
	}
	
	// Automatically Conver Simple Lists to Styled Lists
	//jQuery(".content_block ul, .content_block ol").addClass('list');
	
	// Block Quotes
	var blockquotes = jQuery('blockquote');
	
	blockquotes.each(function(i)
	{
		var blockquote = jQuery(this);
		var quotes = jQuery('<div class="quotes" />');
		
		blockquote.append(quotes);
	});
	
	// Code Blocks
	var pres = jQuery('pre');
	
	pres.each(function(i)
	{
		var pre = jQuery(this);
		var hash = jQuery('<div class="hash" />');
		
		pre.append(hash);
	});
	
	
	
	// Comments
	jQuery('.comments_view ul .comment-details').append('<i class="comment-arrow"></i>');
	jQuery('.comments_view ul ul .comment-details').append('<i class="comment-arrow-sub"></i>');
	
	
	// Categories
	jQuery(".head_title .categories li").each(function(i)
	{
		var sep = jQuery('<li class="separator"></li>');
		
		if(i > 0)
		{
			jQuery(this).before(sep);
		}
	});
	
	
	
	// Portfolio Hover Image
	if(jQuery.isFunction(jQuery.fn.imageHover))
	{
		var portfolio_hover = jQuery('.portfolio_hover');
				
		portfolioItemHoverSetup(portfolio_hover);
	}
	
	
	
	// Portfolio Ordering
	var portfolio_entries = jQuery(".portfolio_entries");
	
	if(jQuery.isFunction(jQuery.fn.isotope) && portfolio_entries.length && portfolio_entries.hasClass('categorizing'))
	{
		var categories = {};
		
		// Switch Filter to Parent Category
		/*portfolio_entries.find('.portfolio_entry').each(function()
		{
			var $this = jQuery(this);
			var columns = $this.parent();
			
			//columns.attr('class', $this.data('filter'));
		});*/
		
		
		var isotope_options = {
			masonry: 
			{
				itemSelector: '.columns',
				gutterWidth: 20,
				columnWidth: 1/4
			},
			animationOptions: {
				duration: 750,
				easing: 'linear',
				queue: false
			}
		};
		
		
		// Four Columns Setup
		if(portfolio_entries.hasClass('portfolio_columns_4'))
		{
			isotope_options.masonry.columnWidth = 1/4;
		}
		else
		if(portfolio_entries.hasClass('portfolio_columns_3'))
		{
			isotope_options.masonry.columnWidth = 1/3;
		}
		
		// Setup Isotope when Images are loaded
		portfolio_entries.imagesLoaded(function()
		{
			portfolio_entries.isotope(isotope_options);
		});
		
		
		// Filterer
		var portfolio_filter = jQuery("#portfolio_filter");
		var endless_scroll_pagination_link = jQuery(".endless_scroll_pagination a");
		
		portfolio_filter.find('a').each(function(ev)
		{
			var $this = jQuery(this);			
			
			$this.on('click', function(ev)
			{
				if(portfolio_filter.data('isotope') == '0')
				{
					return;
				}
				
				ev.preventDefault();				
				
				var filter = jQuery(this).data('filter');
				var filter_clear = filter;
				
				if(filter != '*')
				{	
					filter = categories[filter];
					filter =  '.' + filter;
				}
				
				portfolio_filter.find('li').removeClass('active');
				jQuery(this).parent().addClass('active');
				
				
				portfolio_entries.isotope({filter: function(item)
					{
						var _portfolio_entry_filters = jQuery(this).find('.portfolio_entry').data('filter').split(' ');
						var resp = false;
						
						if(filter_clear == '*' || filter_clear == 'all')
							return true;
						
						jQuery.each(_portfolio_entry_filters, function(key, element)
						{
							if(element == filter_clear)
								resp = true;
						})
						
						return resp;
					}
				});
			});
		});
		
		
		// Setup Filter Classes
		setupPortfolioFilterClasses(categories, portfolio_entries, portfolio_filter);
	}
	
	/* Infinite Scroll */
	var endless_scrolling = jQuery(".endless_scrolling");
	
	if(jQuery.isFunction(jQuery.fn.infinitescroll) && endless_scrolling.length > 0)
	{
		var pagination_link = jQuery('.endless_scroll_pagination a');
		
		
		endless_scrolling.infinitescroll({
			navSelector: pagination_link,
			nextSelector: pagination_link,
			itemSelector: '.portfolio_entry_item',
			onIsDone: function(){		
				TweenMax.to(pagination_link, .5, {css: {autoAlpha: 0}});
			},
			loading: {
				finishedMsg: '',
				img: '',
				msgText: ''
			}
			//,debug: true
		},
		function(newElements){
		
			var new_items = jQuery(newElements);
			var active_category = jQuery("#portfolio_filter .active a").data('filter');
			
			new_items.hide();
			
			pagination_link.fadeTo(0,0);
			TweenMax.to(pagination_link, .5, {css: {autoAlpha: 1}});
			
			new_items.imagesLoaded(function()
			{
				endless_scrolling.isotope('addItems', new_items, function()
				{
					var portfolio_hover = jQuery(new_items).find('.portfolio_hover');
					
					new_items.show();
					
					// Filter Results
					endless_scrolling.isotope({filter: function(){
				
							var $item = jQuery(this).find('.portfolio_entry');
							var filters = $item.data('filter');
							
							if( ! active_category || active_category == '*' || active_category == 'all')
							{
								return true;
							}
							
							return filters.indexOf(active_category) >= 0;
						}
					});
					
					// Hover Popup		
					portfolioItemHoverSetup(portfolio_hover);
									
					// Like Item
					setLikeEvent(jQuery(new_items).find('.like'));
					
				});
				
			});
			
		});
		
		
		// Make Manual Scroller via Button
		if(endless_scrolling.hasClass('endless_scrolling_manual'))
		{
			jQuery(window).unbind('.infscr');
		}
		
		
		var infscr = endless_scrolling.data('infinitescroll');
		
		pagination_link.on('click', function(ev)
		{
			ev.preventDefault();
			infscr.retrieve();
			
			if( infscr.options.state.isDone )
			{
				pagination_link.fadeTo(500, 0);
			}
		});
	}
	
	
	// Portfilio Showcase Slider
	if(jQuery.isFunction(jQuery.fn.flexslider))
	{
		var portfolio_showcase = jQuery("#portfolio_showcase");
		
		if(portfolio_showcase.find('.slides').length > 0)
		{
			portfolio_showcase.flexslider({
				startAt: 0,
				pauseOnHover: 1,
				slideshow: true,
				slideshowSpeed: 7000,
				animationSpeed: 500,
				easing: 'easeInOutSine',
				smoothHeight: true
			});
		}
	}
	
	
	// Gallery Plugin by Arlind Nushi
	if(jQuery.isFunction(jQuery.fn.anGallery))
	{
		jQuery("#an_gallery").anGallery({
			slideShow: jQuery('.showing_image'),
			detectHashChange: true
		});
	}
	
	
	// Features Tabs Hover
	if(jQuery.isFunction(jQuery.fn.homepageFeatures))
	{
		jQuery(".features_tabs").homepageFeatures({
			itemSelector: '.feature_item',
			contentElement: '.feature_content',
			moreTextElement: '.more'
		});
	}
	
	
	// AutoCenter Div
	jQuery(".centered_div").each(function()
	{
		var $this = jQuery(this);
		
		autoCenterDiv($this);
	});
	
	
	// Preload Images
	var _preload_images = [kolorurl + 'images/gallery_loading.gif', kolorurl + 'images/gallery_loading2.gif', kolorurl + 'images/gallery_loading3.gif'];
	
	for(var i in _preload_images)
	{
		var _image = new Image();
		_image.src = _preload_images[i];
	}
	
	// Like Item
	setLikeEvent( jQuery(".project_details .likes, .portfolio_entry .like, .right_panel .like, .portfolio_items .favorite") );
	
	
	/* ShadowBox */
	if(window.hasOwnProperty('Shadowbox'))
	{
		// Post Images Gallery
		var post_gallery = jQuery(".blog_post .gallery .gallery-item");
		
		if(post_gallery.length > 0)
		{
			var post_gallery_id = jQuery(".blog_post .gallery").attr('id');
			
			post_gallery.each(function()
			{
				var image = jQuery(this);
				
				var image_link = image.find('.gallery-icon a');
				var image_alt = image_link.find('img').attr('alt');
				var caption = image.find('.gallery-caption').text();
				
				// Detect Youtube
				var matches;
				if(image_alt.length && (matches = image_alt.match(/v=(\w+)/)))
				{
					var youtube_id = matches[1];
					
					image_link.attr('href', 'http://www.youtube.com/v/' + youtube_id).attr('rel', 'width=700;height=450');
				}
				else
				// Detect Vimeo
				if(image_alt.length && (matches = image_alt.match(/vimeo\.com\/(\d+)/)))
				{
					var vimeo_id = matches[1];
					
					image_link.attr('href', 'http://vimeo.com/moogaloop.swf?clip_id=' + vimeo_id).attr('rel', 'width=700;height=450');;
				}
				
				image_link.attr('rel', 'shadowbox['+post_gallery_id+'];' + image_link.attr('rel'));
				image_link.attr('title', caption)
			});
		}
		
		Shadowbox.init({
			handleOversize: 'resize',
			continuous: true
		});
	}
	

	
	/* Features tabs click feature v1.6 */
	jQuery(".feature_item[data-url]").on('click', function(ev)
	{
		var href = jQuery(this).data('url');
		
		window.location.href = href;
	});
	
});


/* Setup Portfolio Classes */
function setupPortfolioFilterClasses(categories, portfolio_entries, portfolio_filter)
{
	portfolio_entries = portfolio_entries.find('.portfolio_entry');
	portfolio_filter = portfolio_filter.find('a');
	
	var filter_prefix = 'filter_cat';
	
	
	portfolio_filter.each(function()
	{
		var category = jQuery(this).data('filter');
		
		if(category != '*')
		{
			categories[category] = filter_prefix + '_' + category;
		}
	});
	
	
	// Assign filters
	portfolio_entries.each(function()
	{
		var portfolio_entry = jQuery(this);
		var pe_parent = portfolio_entry.parent();
		
		
		var filters = portfolio_entry.data('filter');
		filters = filters.split(' ');
		
		for(var i=0; i<filters.length; i++)
		{
			var _filter = categories[ filters[i] ];
			
			if(_filter)
			{
				pe_parent.addClass(_filter);
			}
		}
		
	});
}


/* Relayout Roundabout Slider */

function relayoutRoundAboutSlider()
{
	roundabout_slider.roundabout("relayoutChildren");
}


/* Sidebar height setup */
/*function sbHeightSetup(sidebar)
{
	if( ! sidebar)
		sidebar = jQuery(".sidebar");
	
	if(typeof test_device_type == 'undefined')
	{
		return;
	}
	
	var device_type = test_device_type();
	
	if(device_type == 'iphone' || device_type == 'iphone_landscape')
	{
	    sidebar.height('auto');
		return;
	}	
		
    var sidebar_parent = sidebar.parent();
    
    var s_height = sidebar.height();
    var sp_height = sidebar_parent.height();
    
    if(s_height < sp_height)
    {
	    sidebar.height(sp_height);
    }
}*/


/* Tweet Roller plugin by Arlind Nushi */
var TweetRoller = function(_options)
{
	var self = this;
	
	var options = {
		container: null,
		tweets: null,
		tweets_per_page: 2,
		timeout: 0,
		pause_on_hover: true,
		show_hide_speed: 500
	};
	
	jQuery.extend(options, _options);
	
	// Define Variables
	var container = options.container;
	var tweets = options.tweets;
	var tweets_per_page = options.tweets_per_page;
	var timeout = options.timeout;
	var pause_on_hover = options.pause_on_hover;
	var show_hide_speed = options.show_hide_speed;
	
	var interval = null;
	
	container.css({
		position: 'relative'
	});
	
	// Class Variables
	this.index = 0;
	this.total = tweets.length;
	
	var move_px = 15;
	
	return {
		next: function()
		{
			var indexes = this.get_indexes();
			
			var to_hide = this.get_for_indexes(indexes[0], indexes[1]);
			
			this.next_index();
			
			indexes = this.get_indexes();
			var to_show = this.get_for_indexes(indexes[0], indexes[1]);
			
			
			to_show.show(); to_hide.hide();
			
			var animate_to_height = 0;
			var tweets_p = options.container;
			var animate_to_height = tweets_p.height();
			
			to_show.hide(); to_hide.show();
			
			
			// Animate Height
			TweenLite.to(tweets_p, (options.show_hide_speed / 1000) * 0.5, {css: {height: animate_to_height}});
			
			to_hide.stop().css({position: 'relative'}).animate({top: move_px, opacity: 0}, {
				duration: show_hide_speed,
				complete: function()
				{
					to_hide.css({top: 0}).hide();
					
					to_show.fadeTo(0,0);
					
					to_show.stop().css({
						top: move_px,
						position: 'relative'
					}).animate({
						top: 0,
						opacity: 1
					}, {
						duration: show_hide_speed
					});
					
					tweets_p.height('auto');
				}
			});
		},
		
		get_for_indexes: function(i1, i2)
		{
			var items = [];
			
			if(i1 > i2)
			{	
				var ti1 = i1, ti2 = i2;
				
				i1 = 0;
				i2 = i2;
					
				for(var i=ti1; i<tweets.length; i++)
				{
					items.push( tweets.get(i) );
				}
				
				for(var i=i1; i<i2; i++)
				{
					items.push( tweets.get(i) );
				}
				
				items = items.reverse();
			}
			else
			{			
				for(var i=i1; i<i2; i++)
				{
					items.push( tweets.get(i) );
				}
			}
			
			return jQuery(items);
		},
		
		get_indexes: function()
		{
			var index_1 = self.index;
			var index_2 = self.index + tweets_per_page;
			index_2 %= self.total;
			
			return [index_1, index_2];
		},
		
		next_index: function()
		{
			self.index += tweets_per_page;
			self.index = self.index % self.total;
		},
		
		start: function()
		{
			var _self = this;
			
			// Auto Scroller
			if(timeout > 0)
			{
				var auto_scroller = function()
				{
					_self.next();
				};
				
				interval = setInterval(auto_scroller, timeout);
				
				// Pause on Hove
				if(pause_on_hover)
				{
					container.hover(function()
					{
						window.clearInterval(interval);
						interval = null;
					},
					function()
					{
						interval = setInterval(auto_scroller, timeout);
					});
				}
			}
		}
	};
}



/* Photo Stream by Arlind Nushi */
function setupPhotoStream(photostream_env, images_per_tab)
{
	if( ! images_per_tab)
		images_per_tab = 6;
	
	var images = photostream_env.find('a img');
	var images_count = images.length;
	
	// Setup Data
	photostream_env.data('images_per_tab', images_per_tab).data('current_tab', 1);
	
	
	if(images_count > images_per_tab)
	{
		var total_tabs = Math.ceil(images_count / images_per_tab);
		var first_tab = images.slice(0, images_per_tab);
		
		images.parent().hide();
		first_tab.parent().show();
		
		var tabs = jQuery('<div class="photostream_tabs" />');
		
		
		for(var i=1; i<=total_tabs; i++)
		{
			var tab = jQuery('<a href="#">'+i+'</a>');
			tab.data('index', i);
			
			if(i == 1)
				tab.addClass('active');
			
			tab.on('click', function(ev)
			{
				ev.preventDefault();
				var _tab = jQuery(this);
				
				switchPhotostreamTab(photostream_env, _tab);
			});
			
			tabs.append(tab);
		}
		
		photostream_env.append(tabs);
		tabs.before('<div class="clear" />');
	}
}

function switchPhotostreamTab(photostream_env, tab)
{
	var _timeout = 80;
	var _delay = 500;
	
	var tabs = photostream_env.find('.photostream_tabs a');
	var index = tab.data('index');
	
	tabs.removeClass('active');
	tab.addClass('active');
	
	
	// Photostream
	var ps_images_per_tab = photostream_env.data('images_per_tab');
	var ps_current_tab = photostream_env.data('current_tab');
	
	var images = photostream_env.find('a img');
	
	// To Hide
	var to_hide_offset = (ps_current_tab - 1) * ps_images_per_tab;
	var to_hide_limit = to_hide_offset + ps_images_per_tab;
	
	var to_hide = images.slice(to_hide_offset, to_hide_limit);
	
	// To Show
	var to_show_offset = (index - 1) * ps_images_per_tab;
	var to_show_limit = to_show_offset + ps_images_per_tab;
	
	var to_show = images.slice(to_show_offset, to_show_limit);
	
	to_hide.parent().hide();
	to_show.parent().fadeIn(_delay);
	
	
	photostream_env.data('current_tab', index);
}


/* Partners Caoursel */
function partnersCarouselFit()
{
	var partners_carousel_instance = jQuery(".partners_carousel").data('ancarouselinstance');
	
	if(typeof partners_carousel_instance != 'undefined')
	{
		switch(test_device_type())
		{
			case "large_screen":
				partners_carousel_instance.updateItemsPerRowNumber(5);
				break;
				
			case "ipad":
				partners_carousel_instance.updateItemsPerRowNumber(4);
				break;
				
			case "iphone_landscape":
			case "iphone":
				partners_carousel_instance.updateItemsPerRowNumber(2);
				break;
		}
	}
}


/* Enable/Disable Portfolio Items */
function enablePortolioMagnifier()
{
	if(jQuery.isFunction(jQuery.fn.elementMagnifier))
	{
		if(portfolio_items.data('is-setup'))
			portfolio_items.elementMagnifier("enable");
		else
			portfolio_items.elementMagnifier(portfolio_items_options);
	}
}

function disblePortolioMagnifier()
{
	if(jQuery.isFunction(jQuery.fn.elementMagnifier))
		portfolio_items.elementMagnifier("disable");
}

/* Center AsyncSlider Items */
function centerAsyncSliderItems(reset_height)
{
	var asyncslider = jQuery('.asyncslider');
	
	if(asyncslider.length == 0)
		return;
		
	if(test_device_type() == 'iphone' || test_device_type() == 'iphone_landscape')
	{
		asyncslider.find('.right_part').css({marginTop: 0});
		asyncslider.height('auto');
		return;
	}
		
	var slide_item = asyncslider.find('.slide_item');
	
	slide_item.each(function()
	{
		var slide = jQuery(this);
		var slide_height = slide.height();
		
		var right_part = slide.find('.right_part');
		var right_part_height = right_part.height();
		
		if(right_part_height == 0)
		{
			slide.show();
			right_part_height = right_part.height();
			slide.hide();
		}
		
		var top_margin = parseInt((slide_height - right_part_height) / 2, 10);
		
		right_part.css({marginTop: top_margin});
	});
	
	
	if(reset_height)
	{
		asyncslider.height('auto');
	}
}


/* AutoCenter Divider Element */
function autoCenterDiv(el)
{
	var width = el.outerWidth();
	var height = el.outerHeight();
	
	
	el.css({
		position: 'absolute',
		left: '50%',
		top: '50%',
		marginLeft: -parseInt(width/2, 10),
		marginTop: -parseInt(height/2, 10)
	});
	
	
	jQuery(window).resize(function()
	{		
		width = el.outerWidth();
		height = el.outerHeight();
		
		el.css({
			marginLeft: -parseInt(width/2, 10),
			marginTop: -parseInt(height/2, 10)
		});
	});
}


function portfolioItemHoverSetup(elements)
{
	elements.each(function()
	{
		var hover_image = jQuery(this);
		var portfolio_item = hover_image.parent();
		
		var hover_el_details = jQuery('<div class="hi_on_hover"></div>');
		
		var row_1 = portfolio_item.data('row-1');
		var row_2 = portfolio_item.data('row-2');
		
		var heading_1 = jQuery('<h2>' + row_1 + '</h2>');
		var heading_2 = jQuery('<h3>' + row_2 + '</h3>');
		var separator = jQuery('<div class="separator"></div>');
		
		hover_el_details
			.append(heading_1)
			.append(separator)
			.append(heading_2);
		
		
		hover_image.imageHover({
			background: '#FFF',
			opacity: 0.95,
			responsive: true,
			animationEngine: 'gsap', // jquery or gsap
			
			icon: {
				el: hover_el_details,
				setup: function(ic, ol, w, h, opts) { 
					ic.css({top: h + ic.height()});
				},
				hoverIn: function(ic, ol, w, h, opts) {
					var top = parseInt((h-ic.height())/2, 10);
					var duration = opts.duration * 0.5;
					
					if(opts.animationEngine == 'gsap') // GreenSock Animation Platform TweenMax
					{
						var ic_el = ic.get(0);
						
						TweenMax.to(ic_el, duration / 1000, {css: {top: top}, yoyo: true, ease: Sine.easeInOut});
					}
					else
					if(opts.animationEngine == 'jquery') // jQuery Animation Engine
					{ 
						ic.animate({ top: top}, {duration: duration, easing: 'easeInOutSine'}); 
					}
				},
				hoverOut: function(ic, ol, w, h, opts) {
					var top = h + ic.height();
					var duration = opts.duration * 0.5;
					
					if(opts.animationEngine == 'gsap') // GreenSock Animation Platform TweenMax
					{
						var ic_el = ic.get(0);
						
						TweenMax.to(ic_el, duration / 1000, {css: {top: top}, yoyo: true, ease: Sine.easeInOut});
					}
					else
					if(opts.animationEngine == 'jquery') // jQuery Animation Engine
					{
						ic.animate({top: top}, {duration: duration, easing: 'easeInOutSine'}); 
					}
				}
			}
		});
		
	});
}


function setLikeEvent(like_el)
{
	like_el.on({
		click: function(ev)
		{
			ev.preventDefault();
			
			var $this = jQuery(this);
			var id = $this.data('id');
			var nonce = $this.data('nonce');
			
			var is_gallery_item = $this.data('is-gallery-item') == '1' ? 1 : 0;
			
			
			var num = $this.find('span');
			
			$this.fadeTo(100, 0.65);
			
			jQuery.post(ajaxurl, {action: 'portfolio_like_item', ID: id, nonce: nonce, is_gallery_item: is_gallery_item}, function(resp)
			{
				$this.stop().fadeTo(100, 1);
				
				if(+resp == 1)
				{
					$this.addClass('liked');
					
					num.text(+num.text() + 1); 
				}
				else 
				// Item Already Liked
				if(+resp == -1)
				{
					alert(item_already_liked);
				}
				else 
				// Remove the like
				if(+resp == -2)
				{
					$this.removeClass('liked');
					
					num.text(+num.text() - 1); 
				}
			});
		}
	});
}