/**
 *	Homepage Screen Hover Features Tabs
 *
 *	Plugin by: Arlind Nushi
 *	Project Date: 23 Aug 2012
 *	Version: 1.0.1
**/

(function($)
{
	"use strict";
	
	// Vars
	var vars = {
		win: $(window),
		body: $('body'),
		
		latestHovered: $(null)
	};
	
	// Settings 
	var settings = {
		itemSelector: '',
		contentElement: '',
		moreTextElement: '.more',
		
		hoverElementContainer: $('<div class="hpf_hover_more" />'),
		
		screenOverlay: $('<div class="hpf_screen_overlay" />'),
		overlayDuration: 0.3,
		
		hoverInDuration: .9,
		hoverOutDuration: 0.30,
		
		fadeCurrentDuration: 0.25,
		fadeOthersDuration: 0.25,
		
		fadeOthersOpacity: 0.5,
		
		maxZ: 20,
		minZ: 10
	};
	
	// Methods
	var methods = {
		
		// Init
		init: function(opts)
		{
			var v = vars, s = settings;
			
			// Set container
			v.container = $(this);
			
			$.extend(settings, opts);
			
			// Items
			v.items = $(s.itemSelector);
			
			// Set Content Elements for Items
			v.items.each(function(i)
			{
				var item = $(this);
				var content_element = item.find(s.contentElement);
				var more_text_element = content_element.find(s.moreTextElement)
				
				// Modify CSS Properties
				item.css({
					position: 'relative',
					zIndex: s.minZ
				});
				
				// Has Hover Element
				var has_hover_element = more_text_element.length == 0 ? false : true
				
				// Create Hover Element
				var hover_element = $(null);
				
				if(has_hover_element)
				{				
					hover_element = s.hoverElementContainer.clone()
					hover_element.append(more_text_element);	
				}
				
				hover_element.addClass('hpf_hover_' + (i+1));
				
				var icon = $('<i />');
				more_text_element.append(icon);
				
				v.container.append(hover_element);
				
				
				// Other Items (for hover purposes)
				var other_items = v.items.not(item);
				
				
				// Assign Elements to Item
				item.data({
					contentElement: content_element,
					moreTextElement: more_text_element,
					hoverElement: hover_element,
					otherItems: other_items,
					hasHoverElement: has_hover_element
				});
			});
			
			// Create Overlay
			v.body.append(s.screenOverlay);

			
			// Setup Events
			methods.setEvents();
			
		},
		
		// Set Events
		setEvents: function()
		{
			var v = vars, s = settings, c = v.container;
			
			var overlay = s.screenOverlay;
			
			v.items.each(function(i)
			{
				var item = $(this);
				var other_items = item.data('otherItems');
				var hover_element = item.data('hoverElement');
				var has_hover_element = item.data('hasHoverElement');
				
			
				
				if( ! has_hover_element)
					return;
					
				hover_element.show().css({visibility: 'hidden'});
				
				var hover_in_events = ['mouseenter'];
				
				var animateInHoverElement = function()
				{
					methods.showOverlay();
										
					// Items
					TweenMax.to(item, s.fadeCurrentDuration, {css: {autoAlpha: 1}, ease: Sine.easeInOut});
					
					if(other_items.length > 0)
						TweenMax.to(other_items, s.fadeOthersDuration, {css: {autoAlpha: s.fadeOthersOpacity}, ease: Sine.easeInOut});
					
					//  Hover Item
					TweenMax.to(hover_element, s.hoverInDuration, {css: {autoAlpha: 1}, ease: Back.easeOut});
				},
				animateOutHoverElement = function()
				{					
					TweenMax.killTweensOf([item, other_items, hover_element]);
					
					TweenMax.to(hover_element, s.hoverOutDuration, {css: {autoAlpha: 0}}); // Hover Element
					TweenMax.to(overlay, s.hoverOutDuration, {css: {autoAlpha: 0}, delay: s.overlayDuration}); // Overlay BG
					
					if(other_items.length > 0)
						TweenMax.to(other_items, s.fadeOthersDuration, {css: {autoAlpha: 1}});
					
					v.latestHovered = item;
				};
				
				
				var hover_timeout = 250;
				var ht_interval = null;
				
				item.on({
					mouseenter: function()
					{
						ht_interval = setTimeout(function(){
						
							var past_hover_element = v.latestHovered.data('hoverElement');
												
							if(past_hover_element)
							{
								past_hover_element.css({
									zIndex: s.minZ + 10
								});
							}
							
							hover_element.css({
								zIndex: s.maxZ + 10
							});
							
							animateInHoverElement();
							
						}, hover_timeout);
					},
					
					mouseleave: function()
					{
						window.clearTimeout(ht_interval);
						ht_interval = null;
						
						animateOutHoverElement();
					},
					
					touchstart: function()
					{
						var is_visible = hover_element.css('opacity') > 0;
						
						if(is_visible)
							animateOutHoverElement();
						else
							animateInHoverElement();
					}
				});
				
				hover_element.on({
					mouseenter: function()
					{
						TweenMax.killTweensOf([hover_element, item, other_items]);
						animateInHoverElement();
					},
					mouseleave: function()
					{
						TweenMax.killTweensOf([hover_element, item, other_items]);
						animateOutHoverElement();
					}
				});
			});
		},
		
		// Show Overlay
		showOverlay: function()
		{
			var v = vars, s = settings, c = v.container;
			var overlay = s.screenOverlay;
			
			if( ! overlay.is(':visible'))
			{
				overlay.fadeTo(0,0);
			}
			
			TweenMax.killTweensOf(overlay);
			
			TweenMax.to(overlay, s.overlayDuration, {css: {autoAlpha: 1}});
		}
	};
	
	$.fn.homepageFeatures = function(opts)
	{
		var $this = $(this);
		
		if( ! $this.data('injected'))
		{
			// Init
			methods.init.apply(this, [opts]);
		}
		else
		if(typeof opts == 'string')
		{
			// Lookup for method to execute
			if(methods[opts])
			{
				methods[opts].apply(this, [opts]);
			}
		}
	}
	
})(jQuery);