<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 *
 *	Template Name: Portfolio
 */

global $wp, $wp_query, $wp_rewrite, $query_string, $post_id;
$query_string_arr = wp_parse_args($query_string);

$post_id = $page_id = get_the_ID();

# Vars
$portfolio_options = get_portfolio_options($page_id);


$slider_items = get_posts(array('post_type' => 'attachment', 'post_parent' => $post_id, 'orderby' => 'menu_order', 'order' => 'ASC'));

# Use External Post Images
if($external_slider_post_id = get_post_meta($post_id, 'external_slider_post_id', TRUE))
{
	$slider_items = get_posts(array('post_type' => 'attachment', 'post_parent' => $external_slider_post_id, 'orderby' => 'menu_order', 'order' => 'ASC'));
}

$slider_items_count = count($slider_items);


extract($portfolio_options);

$posts_per_page = $items_per_page;

$paged = isset($query_string_arr['paged']) ? $query_string_arr['paged'] : 1;
$paged = $paged > 1 ? $paged : 1;


# Get Portfolio Items
$query_arr = array(
	'post_type' => 'portfolio',
	'posts_per_page' => $posts_per_page,
	'paged' => $paged
);

# Get From Category
if( ! isset($_GET['show_all']) && isset($_GET['category']) && (($browse_category = $_GET['category']) || ($browse_category = $query_string_arr['portfolio-category'])))
{
	$query_arr['portfolio-category'] = $browse_category;
	
}
else
if($browse_portfolio_category)
{
	$browse_category = $browse_portfolio_category;
	$query_arr['portfolio-category'] = $browse_portfolio_category;
}

$portfolio_items = new WP_Query($query_arr);

# Defined Vars (after wp_query)
$max_num_pages = $portfolio_items->max_num_pages;


# Get Categories
$portfolio_categories = get_terms('portfolio-category', array('get' => 'hide_empty'));


# Import Required Resources
wp_enqueue_script(array('kolor_wideslider', 'kolor_hover'));

if($infinite_scroll)
{
	wp_enqueue_script('infinitescroll');
}

if($disable_isotope != 'true' || $infinite_scroll)
{
	wp_enqueue_script(array('isotope'));
	wp_enqueue_style(array('isotope'));
}


// Header
get_header();

?>
<!-- site header -->
<div class="site_header<?php echo $slider_items_count == 0 ? ' bg_02' : ''; ?>">
<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

	// WideSlider
	get_template_part('tpls/sliders', 'wideslider');
?>	
</div>
<!-- end: site header -->

<!-- stripped border -->
<div class="stripped_border"></div>
<!-- end: stripped border -->


<!-- page head title -->
<div class="container">
	
	<div class="white_block head_title compact">
		
		<h2 class="block_title left">
			<i class="portfolio"></i>
			<?php the_title(); ?>
		</h2>
	
		<?php if(count($portfolio_categories) && ! $browse_portfolio_category): ?>
		<!-- portfolio categories (do not change ID) -->
		<ul class="categories" id="portfolio_filter" data-isotope="<?php echo $disable_isotope == 'true' ? 0 : 1; ?>">
			
			<!-- category item -->
			<li<?php echo ! $disable_isotope || ! isset($query_arr['portfolio-category']) ? ' class="active"' : ''; ?>><a href="<?php echo is_page() ? get_permalink() : add_query_arg(array('show_all' => TRUE)); ?>" data-filter="*"><?php _e('All'); ?></a></li>
			<!-- end: category item -->
			
			<?php 
			foreach($portfolio_categories as $category):
				$slug = $category->slug;
				$name = $category->name;
				$term_id = $category->term_id;
				
			?>
			<!-- category item -->
			<li<?php echo isset($query_arr['portfolio-category']) && $slug == $query_arr['portfolio-category'] ? ' class="active"' : ''; ?>><a href="<?php echo remove_query_arg('show_all', add_query_arg(array('category' => $slug))); ?>" data-filter="<?php echo $slug; ?>"><?php echo $name; ?></a></li>
			<!-- end: category item -->
			<?php
			endforeach;
			?>
			
		</ul>
		<!-- end: portfolio categories -->
		<?php endif; ?>
		
	</div>
	
</div>
<!-- end: page head title -->


<!-- portfolio entries -->
<div class="container portfolio_entries categorizing portfolio_columns_<?php echo $columns; ?><?php echo $infinite_scroll ? (' endless_scrolling' . ($infinite_scroll_manual ? ' endless_scrolling_manual' : '')) : ''; ?>">
<?php
if($portfolio_items->have_posts()):

	while($portfolio_items->have_posts()): $portfolio_items->the_post();
		
		global $post;
		
		$post_id = get_the_ID();
		
		$title = get_the_title();
		
		$post_categories = get_the_terms($post_id, 'portfolio-category');
		
		$thumbnail_size = '';
		
		switch($columns)
		{
			case 2:
				$thumbnail_size = 'portfolio-thumb-4';
				#$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
				$post_thumbnail =  laborator_img($post_id, $thumbnail_size);
				break;
				
			case 3:
				$thumbnail_size = 'portfolio-thumb-3';
				#$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
				$post_thumbnail =  laborator_img($post_id, $thumbnail_size);
				break;
				
			default:
				$thumbnail_size = 'portfolio-thumb-1';
				#$post_thumbnail = get_the_post_thumbnail($post_id, $thumbnail_size, "portfolio-item-{$post_id}");
				$post_thumbnail =  laborator_img($post_id, $thumbnail_size);
		}
		
		
		# [Alternative] If there is no post thumnail attached, check for other attachments inside the post
		if( ! $post_thumbnail)
		{
			$other_attachment = reset(get_children(array('post_parent' => $post_id, 'post_type' => 'attachment', 'posts_per_page' => 1, 'orderby' => 'menu_order', 'order' => 'ASC')));
			
			#$post_thumbnail = wp_get_attachment_image($other_attachment->ID, $thumbnail_size);
			#$post_thumbnail = preg_replace('/width=.[0-9]+.|height=.[0-9]+./', '', $post_thumbnail);
			
			$post_thumbnail =  laborator_img($other_attachment->ID, $thumbnail_size);
		}
		
		# Wrap $post_thumbnail into Image Tag
		if($post_thumbnail)
		{
			$post_thumbnail = '<img src="' . $post_thumbnail . '" alt="' . $thumbnail_size . '">';
		}
		
		# Category Slugs
		$cslugs = array();
		$cnames = array();
		
		if( ! is_array($post_categories))
			$post_categories = array();
		
		foreach($post_categories as $cat_term)
		{
			array_push($cslugs, $cat_term->slug);
			array_push($cnames, $cat_term->name);
		}
		
?>
	<!-- portfolio entry -->
	<div class="portfolio_entry_item <?php echo $columns == 3 ? 'one-third column' : ($columns == 2 ? 'eight columns' : 'four columns'); ?>">
		
		<div class="portfolio_entry<?php echo ! $portfolio_bottom_titles ? ' no_titles' : ''; ?>" data-filter="<?php echo implode(' ', $cslugs); ?>" data-row-1="<?php echo esc_attr($title); ?>" data-row-2="<?php echo esc_attr(implode(', ', $cnames)); ?>">
			
			<a href="<?php the_permalink(); ?>" class="image portfolio_hover">
				<?php echo $post_thumbnail; ?>
			</a>
			
			<?php if($portfolio_bottom_titles): ?>
				<!-- item title -->
				<div class="meta">					
					<a href="<?php the_permalink(); ?>" class="title"><?php the_title(); ?></a>
					
					<div class="right_panel">
						<span class="category"><?php echo implode(', ', $cnames); ?></span>
						
						<?php if($allow_likes): ?>
						<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikePortfolioItem'); ?>" class="like<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>">Like</a>
						<?php endif; ?>
					</div>
				</div>
				<!-- end: item title -->
			<?php else: ?>
				<?php if($allow_likes): ?>
				<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikePortfolioItem'); ?>" class="like<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>"><?php _e('Like'); ?></a>
				<?php endif; ?>
			<?php endif; ?>
						
		</div>
		
	</div>
	<!-- end: portfolio entry -->
	<?php
	endwhile;

endif;
?>
</div>
<!-- end: portfolio entries -->


<?php 
	// Normal Pagination
	if($max_num_pages > 1 && ! $infinite_scroll):
		
		$from = 1;
		$to = $max_num_pages;
		
		$current_page = $paged;
		
		$add_sub_1 = round($numbers_to_show/2);
		$add_sub_2 = round($numbers_to_show - $add_sub_1);
		
		$from = $current_page - $add_sub_1;
		$to = $current_page + $add_sub_2;
		
		$limits_exceeded_l = FALSE;
		$limits_exceeded_r = FALSE;
		
		if($from < 1)
		{
			$from = 1;
			$limits_exceeded_l = TRUE;
		}
		
		if($to > $max_num_pages)
		{
			$to = $max_pages;
			$limits_exceeded_r = TRUE;
		}
		
		
		if($limits_exceeded_l)
		{
			$from = 1;
			$to = $numbers_to_show;
		}
		else
		if($limits_exceeded_r)
		{
			$from = $max_num_pages - $numbers_to_show + 1;
			$to = $max_num_pages;
		}
		else
		{
			$from += 1;
		}
		
		if($from < 1)
			$from = 1;
		
		if($to > $max_num_pages)
		{
			$to = $max_num_pages;
		}
?>
<!-- pagination -->
<div class="container margin_top">
	<div class="sixteen columns">
	
		<ul class="pagination<?php echo $pagination_position == 'center' ? ' center' : ($pagination_position == 'right' ? ' right' : ($pagination_position == 'full' ? ' full' : '')); ?>"><!-- add class 'center' or 'right' to position the text (default: left) -->		
		
		<?php if($paged > 1): ?>
			<li class="first_page"><a href="<?php echo get_pagenum_link(1); ?>"><?php _e('First Page', TD); ?></a></li>
		<?php endif; ?>
	
		<?php
		
		if($from > floor($numbers_to_show / 2))
		{
			?>
			<li><a href="<?php echo get_pagenum_link(1); ?>"><?php echo 1; ?></a></li>
			<li>...</li>
			<?php
		}
		
		for($i=$from; $i<=$to; $i++):
			
			$link_to_page = get_pagenum_link($i);
			$is_active = $paged == $i;
		?>
			<li<?php echo $is_active ? ' class="active"' : ''; ?>><a href="<?php echo $link_to_page; ?>"><?php echo $i; ?></a></li>
		<?php
		endfor;
			
		
		if($max_num_pages > $to)
		{
			if($max_num_pages != $i):
			?>
				<li>...</li>
			<?php
			endif;
			
			?>
			<li><a href="<?php echo get_pagenum_link($max_num_pages); ?>"><?php echo $max_num_pages; ?></a></li>
			<?php
		}
		?>
		
		<?php if($paged < $max_num_pages): ?>
			<li class="last_page"><a href="<?php echo get_pagenum_link($max_num_pages); ?>"><?php _e('Last Page', TD); ?></a></li>
		<?php endif; ?>
		</ul>
		
	</div>
</div>
<!-- end: pagination -->
<?php
	
	elseif($max_num_pages > 1 && $infinite_scroll):
	
		if($disable_isotope == 'true' && isset($_GET['category']))
		{
			$category_browse_url = "portfolio_category={$_GET['category']}&";
		}
	?>
<div class="container margin_top">
	<div class="sixteen columns">
	
		<ul class="pagination center">
			<li class="endless_scroll_pagination">
				<a href="<?php echo admin_url("admin-ajax.php?action=endless_get_results&post_type=portfolio&page_id={$page_id}&{$category_browse_url}page=2"); ?>"><?php _e('Load More Items', TD); ?></a>
			</li>
		</ul>
	
	</div>
</div>
	<?php
	
	endif;


// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();