<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */

// Get required Globals
global $wp_query, $query_string;

$s = isset($_GET['s']) ? $_GET['s'] : '';
$p = isset($_GET['page']) ? $_GET['page'] : 1;


# Search Results Instance
$results = new WP_Query(array(
	's' => $s, 
	'paged' => $p, 
	'posts_per_page' => $wp_query->query_vars['posts_per_page'],
	'post_type' => 'post'
));

		
$found_posts = $results->found_posts;
$posts_per_page = $results->query_vars['posts_per_page'];
$paged = $results->query_vars['paged'];

$max_pages = 0;

if($found_posts > $posts_per_page)
{
	$max_pages = ceil($found_posts / $posts_per_page);
}

// Header
get_header();


?>
<div class="bg_absolute content_page_bg bg_02">
		<!-- stripped border -->
		<div class="stripped_border"></div>
		<!-- end: stripped border -->		
</div>
	
<!-- site header -->
<div class="site_header bg_02">

<?php

	// Main Menu (optionally with sliders)
	get_template_part('tpls/header', 'menu');

?>
</div>
<!-- end: site header -->

<!-- page head title -->
<div class="container content_block_nobg_2 margin_top_double">
	
	<div class="white_block head_title">
		
		<h2 class="block_title left">
			<i class="list"></i>
			<?php echo sprintf(__('Search Results (%d)', TD), $found_posts); ?>
		</h2>
		
		<!-- search form -->
		<form method="get" action="" class="search_form">
			<input type="text" name="s" id="s" class="input" placeholder="<?php _e('Search...', TD); ?>" value="<?php echo esc_attr($s); ?>" />
		</form>
		<!-- end: search form -->
		
	</div>
	
</div>
<!-- end: page head title -->

<!-- search results -->
<div class="search_results">
	
<?php
if($results->have_posts()):
	
	while($results->have_posts()): $results->the_post();
?>
	
	<!-- search result -->
	<div class="container white_block content_block">
		
		<div class="search_result_entry">
		
			<!-- content block title -->
			<h2 class="ct_title">
				<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			</h2>
			<!-- end: content block title -->
			
			
			<!-- sixteen columns -->
			<div class="row">	
				<div class="sixteen columns">
					<?php the_excerpt(); ?>
				</div>
			</div>		
			<!-- end: sixteen columns -->
		
		</div>
		
	</div>
	<!-- end: content block -->
	
<?php
	endwhile;

else:
// No Search Results
?>
<div class="container white_block content_block">
	<div class="no_search_results">
		<?php echo sprintf(__('Your search about <strong>%s</strong> didn\'t bring any result.', TD), $s); ?>
	</div>
</div>
<?php

endif;
?>
	
	
</div>
<!-- end: search results -->



<?php if($max_pages > 1): ?>
<!-- pagination -->
<div class="container">
	<div class="sixteen columns">
	
		<?php echo paginate_links($args); ?>
		
		<ul class="pagination"><!-- add class 'center' or 'right' to position the text (default: left) -->
		<?php
		
		
		for($pgnum=1; $pgnum<=$max_pages; $pgnum++):
			
			$is_active = $pgnum == $paged || (!$paged && $pgnum == 1) ? ' class="active"' : '';
			
			$page_args['page'] = $pgnum;
			
			$args = add_query_arg($page_args);
		?>
			<li<?php echo $is_active; ?>><a href="<?php echo site_url("?s={$s}&page={$pgnum}"); ?>"><?php echo $pgnum; ?></a></li>
		<?php
		endfor;
		?>
		</ul>
		
	</div>
</div>
<!-- end: pagination -->
<?php endif; ?>

<?php

// Footer Clients Block
get_template_part('tpls/blocks', 'footerclients');


// Footer Blocks
get_template_part('footer', 'block');


// Footer
get_footer();