<?php
	global $post;
	
	$post_id = $post->ID;
	$user_id = $post->post_author;
	
	$author = new WP_User($user_id);
	$usermeta = get_user_meta($user_id);
	
	if( ! $author)
		return;
	
	$_author_name = $author->display_name;
	$_user_url = $author->user_url;
	$_bio = reset($usermeta['description']);
	
	if($nickname = $usermeta['nickname'])
	{
		$_author_name = reset($nickname);
	}
	
	
	
?>
<!-- author info -->
<div class="container author_info">
	<div class="user_info">
		
		<div class="image">
			<?php echo get_avatar($user_id, 75); ?>
		</div>
		
		<div class="info">
			<h2><?php echo $_author_name; ?></h2>
			
			<div class="info_links">
				<a title="<?php _e('Browse posts from this author', TD); ?>" href="<?php echo get_author_posts_url($user_id); ?>" class="posts"><?php echo _x('Posts', 'Users posts count', TD); ?>: <?php echo count_user_posts($user_id); ?></a>
				
				<?php if($_user_url): ?>
				<a href="<?php echo $_user_url; ?>" target="_blank" class="link">Web</a>
				<?php endif; ?>
			</div>
		</div>
		
	</div>
	
	<div class="author_bio">
		<h2><?php _e('About the Author'); ?></h2>
		
		<?php echo $_bio ? wpautop($_bio) : wpautop(__('No other information about this user.', TD)); ?>
	</div>
</div>
<!-- end: author info -->