<?php

	global $portfolio_rows;
	
	$post_id = get_the_ID();
	
	# Vars
	$portfolio_options = get_portfolio_options();
	
	extract($portfolio_options);
		
	$portfolio_mult = 4;
	$portfolio_rows = $portfolio_rows ? $portfolio_rows : 2;	
	
	$posts_per_page = $portfolio_mult * $portfolio_rows;
		
	# Get Portfolio Items
	$query_arr = array(
		'post_type' => 'portfolio',
		'posts_per_page' => $posts_per_page,
		'post__not_in' => array($post_id),
		'order' => 'DESC',
		'orderby' => 'date'
	);
	
	$portfolio_items = new WP_Query($query_arr);
	
?>

<?php if($portfolio_items->have_posts()): ?>

<!-- portfolio (index block) -->
<div class="container white_block index_portfolio_env double_bottom_margin">
	
	<!-- block title -->
	<div class="ten columns potfolio_title_block">
		
		<h2 class="block_title">
			<i class="portfolio"></i> <?php echo _x('Portfolio', 'latest portfolio items (homepage)', TD); ?>
		</h2>
		
	</div>
	<!-- end: block title -->
	
	
	<!-- portfolio items env -->
	<div class="columns homepage_portfolio_entries">
		
		<ul class="portfolio_items" data-magnify="15">
			
			<?php
	
			while($portfolio_items->have_posts()): $portfolio_items->the_post();
				
				$post_id = get_the_ID();
				
				$title = get_the_title();
				
				$post_categories = get_the_terms($post_id, 'portfolio-category');
				$post_thumbnail = get_the_post_thumbnail($post_id, 'portfolio-thumb-3', array('title' => esc_attr($title)));
				
				# Category Slugs
				$cslugs = array();
				$cnames = array();
				
				foreach($post_categories as $cat_term)
				{
					array_push($cslugs, $cat_term->slug);
					array_push($cnames, $cat_term->name);
				}
				
			?>
			
			
			<!-- portfolio item -->
			<li>
				<a href="<?php the_permalink(); ?>">
					<?php echo $post_thumbnail; ?>
				</a>
				
				<!-- buttons per each item -->
				<div class="buttons">
					<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikePortfolioItem'); ?>" class="favorite<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>"><?php _e('Like', TD); ?></a>
					<a href="<?php the_permalink(); ?>" class="view"><?php _e('View Item', TD); ?></a>
				</div>
				<!-- end: buttons per each item -->
				
				<!-- launch project link -->
				<a href="<?php the_permalink(); ?>" class="launch"><?php _e('Launch', TD); ?></a>
			</li>
			<!-- end: portfolio item -->
			
			<?php
			endwhile;
			?>

		</ul>
		
	</div>
	<!-- end: portfolio items env -->
	
</div>
<!-- end: portfolio (index block) -->

	
<?php endif; ?>