<?php

	$post_id = get_the_ID();
	
	# Vars
	$portfolio_options = get_portfolio_options();
	
	extract($portfolio_options);
		
		
	# Get Portfolio Items
	$query_arr = array(
		'post_type' => 'portfolio',
		'posts_per_page' => 4,
		'post__not_in' => array($post_id),
		'order' => 'DESC',
		'orderby' => 'date'
	);
	
	$portfolio_items = new WP_Query($query_arr);
	
?>

<?php if($portfolio_items->have_posts()): ?>
<!-- other portfolio entries -->
<div class="container portfolio_entries portfolio_columns_4 other_potfolio_items">

	<h2 class="title"><?php _e('Other Projects', TD); ?></h2>
	
<?php
	
	while($portfolio_items->have_posts()): $portfolio_items->the_post();
		
		$post_id = get_the_ID();
		
		$title = get_the_title();
		
		$post_categories = get_the_terms($post_id, 'portfolio-category');
		$post_thumbnail = get_the_post_thumbnail($post_id, 'portfolio-thumb-1', "portfolio-item-{$post_id}");
		
		# Category Slugs
		$cslugs = array();
		$cnames = array();
		
		if( ! is_array($post_categories))
			$post_categories = array();
			
		foreach($post_categories as $cat_term)
		{
			array_push($cslugs, $cat_term->slug);
			array_push($cnames, $cat_term->name);
		}
		
?>
	<!-- portfolio entry -->
	<div class="four columns">
		
		<div class="portfolio_entry no_titles" data-filter="<?php echo implode(' ', $cslugs); ?>" data-row-1="<?php echo esc_attr($title); ?>" data-row-2="<?php echo esc_attr(implode(', ', $cnames)); ?>">
			
			<a href="<?php the_permalink(); ?>" class="image portfolio_hover">
				<?php echo $post_thumbnail; ?>
			</a>
			
			<?php if($allow_likes): ?>
			<a href="#" data-id="<?php echo $post_id; ?>" data-nonce="<?php echo wp_create_nonce('LaboratorLikePortfolioItem'); ?>" class="like<?php echo is_portfolio_item_liked($post_id) == 1 ? ' liked' : ''; ?>"><?php _e('Like'); ?></a>
			<?php endif; ?>
						
		</div>
		
	</div>
	<!-- end: portfolio entry -->
	<?php
	endwhile;
?>
</div>
<!-- end: other portfolio entries -->
<?php endif; ?>