<?php
/**
 *	Kolor
 *
 *	Theme by: Art Ramadani
 *	Developed by: Arlind Nushi
 *
 *	www.mobanbus.cn
 */

	$logo_url = get_option('kolor_logo_url');
	$retina_logo_url = get_option('kolor_retina_logo_url');
	
	if( ! $logo_url)
	{
		$logo_url = THEMEURL . 'images/kolor.png';
	}

?>

	<!-- site header container -->
	<div class="container header_menu_container">
		
		<!-- site logo and menu container -->
		<div class="site_logo_menu">
			
			<!-- site logo -->
			<div class="four columns logo">
				
				<a href="<?php echo is_wpml() ? icl_get_home_url() : site_url('/'); ?>">
					<img src="<?php echo $logo_url; ?>" />
					<?php if($retina_logo_url): 
						
						$upload_dir = wp_upload_dir();
						
						$image_path = ABSPATH . str_replace(site_url('/'), '', $retina_logo_url);
						$retina_logo_width = '';
						
						if(file_exists($image_path))
						{
							$retina_logo_width = getimagesize($image_path);
							$retina_logo_width = intval($retina_logo_width[0] / 2);
						}
					?>
					<img src="<?php echo $retina_logo_url; ?>" width="<?php echo $retina_logo_width; ?>" class="retina_logo" />
					<?php endif; ?>
				</a>
				
			</div>
			<!-- end: site logo -->
			
			
			<!-- site main menu -->
			<div class="twelve columns">
				
				<?php
				
				/* Show Main Menu */
				wp_nav_menu(array(
					'container' 	=> '',
					'menu_class' 	=> 'main_menu',
					'items_wrap' 	=> '<ul id="%1$s" class="%2$s" data-title="Main Menu">%3$s</ul>',
					'walker' 		=> new Kolor_Walker_Nav()
				));	
					
				?>
				
				<div id="mobile_menu"></div><!-- do not delete this item -->
				
			</div>
			<!-- end: site main menu -->
			
		</div>
		<!-- end: site logo and menu container -->
		
		
		
	</div>
	<!-- end: site header container -->