<?php

	# Get Slides from global[slider_items]
	global $post_id, $slider_items;

	
	# Filter Slider Items (remove mime types != image)
	foreach($slider_items as $i => $slider_item)
	{
		if( ! strstr($slider_item->post_mime_type, "image"))
		{
			unset($slider_items[$i]);
		}
	}

	if(count($slider_items)):
		
		# Auto Switcher
		$slider_timeout = 5; # Seconds
		
		# Get Slider Timeout from Post Meta
		$post_slider_timeout = get_post_meta($post_id, 'slider_timeout', TRUE);
		
		if($post_slider_timeout === 0 || $post_slider_timeout > 0)
		{
			$slider_timeout = $post_slider_timeout;
		}
	
?>
<!-- slider env / slider[asyncslider]-->
<div class="asyncslider" data-autoswitch="<?php echo $slider_timeout * 1000; ?>">
	
	<!-- grid container -->
	<div class="container">
	
		<div class="sixteen columns relative">
			
			
			<?php 
			foreach($slider_items as $i => $slider_item):
				
				$title = $slider_item->post_title;
				$caption = $slider_item->post_excerpt;
				$content = $slider_item->post_content;
				
				$guid = $slider_item->guid;
				
				$link_to_post_url = get_post_meta($id, '_wp_attachment_image_alt', TRUE);;
				
				if($link_to_post_id = get_post_meta($slider_item->ID, 'link_to_post_id', TRUE))
				{
					$link_to_post_url = get_permalink($link_to_post_id);
				}
					
			?>
			<!-- slide item -->
			<div class="slide_item">
				
				<div class="left_part">
					<?php if($link_to_post_url): ?>
					<a href="<?php echo $link_to_post_url; ?>">
						<img src="<?php echo $guid; ?>" alt="asyncslider_image_0<?php echo $i; ?>">
					</a>
					<?php else: ?>
					<img src="<?php echo $guid; ?>" alt="asyncslider_image_0<?php echo $i; ?>">
					<?php endif; ?>
				</div>
				
				<div class="right_part">
					
					<h2 class="head_title">
						<?php echo $title; ?>
					</h2>
					
					<div class="description">
						<?php echo do_shortcode(wpautop($content)); ?>
					</div>
					
				</div>
				
			</div>
			<!-- end: slide item -->			
			<?php
			endforeach;
			?>
			
		</div>
		
	</div>
	<!-- end: grid container -->
	
</div>
<!-- end: slider env [asyncslider] -->
<?php endif; ?>