<?php

	# Get Slides from global[slider_items]
	global $post_id, $slider_items;
	
	# Slider Height
	$wide_slider_height = get_option('kolor_wide_slider_height');
	
	if( ! is_numeric($wide_slider_height) || $wide_slider_height < 190)
		$wide_slider_height = 570;
	
	# Filter Slider Items (remove mime types != image)
	foreach($slider_items as $i => $slider_item)
	{
		if( ! strstr($slider_item->post_mime_type, "image"))
		{
			unset($slider_items[$i]);
		}
	}

	if(count($slider_items)):
		
		# Auto Switcher
		$slider_timeout = 5; # Seconds
		
		# Get Slider Timeout from Post Meta
		$post_slider_timeout = get_post_meta($post_id, 'slider_timeout', TRUE);
		
		
		if($post_slider_timeout === 0 || $post_slider_timeout > 0)
		{
			$slider_timeout = $post_slider_timeout;
		}
	
		# Slider Height
		$height_1 = $wide_slider_height - 120;
		$height_2 = $wide_slider_height;
?>
<style>
	.wideslider { height: <?php echo $height_1; ?>px !important; }
	.ws_images_container { height: <?php echo $height_2; ?>px !important; }
	
	@media only screen and (min-width: 768px) and (max-width: 959px) {
			
		.wideslider { height: <?php echo $height_1 - 120; ?>px !important; }
		.ws_images_container { height: <?php echo $height_2 - 120; ?>px !important; }		
	}
	
	@media only screen and (max-width: 767px) {
			
		.wideslider { height: <?php echo $height_1 - 190; ?>px !important; }
		.ws_images_container { height: <?php echo $height_2 - 180; ?>px !important; min-height: <?php echo $height_2 - 180; ?>px !important; }
	}
	
	@media only screen and (max-width: 479px) {
	}
</style>
<div class="container">
	<!-- slider env -->
	<div class="sixteen columns wideslider">
		
		<!-- wide slider -->
		<ul data-autoswitch="<?php echo $slider_timeout * 1000; ?>">
			
			<?php 
			foreach($slider_items as $slider_item):
				
				$title = $slider_item->post_title;
				$caption = $slider_item->post_excerpt;
				$content = $slider_item->post_content;
				
				if($content)
					$caption .= "\n" . $content;
				
				$guid = $slider_item->guid;
				
				$description = explode("\n", $caption);
				
				$link_to_post_url = get_post_meta($id, '_wp_attachment_image_alt', TRUE);;
				
				if($link_to_post_id = get_post_meta($slider_item->ID, 'link_to_post_id', TRUE))
				{
					$link_to_post_url = get_permalink($link_to_post_id);
				}
					
			?>
			<!-- slider item -->
			<li>
				<img src="<?php echo $guid; ?>" alt="wideslider_image_0<?php echo $i; ?>" data-href="<?php echo $link_to_post_url; ?>">
				
				<span class="strong"><?php echo $title; ?></span>
				
				<?php foreach($description as $description_line): ?>
				<span><?php echo $description_line; ?></span>
				<?php endforeach; ?>
				
				<!--<div class="separator"></div>-->
			</li>
			<!-- end: slider item -->
			<?php 
			endforeach; 
			?>
			
		</ul>
		
		<!-- here will be next/prev buttons (not remove) (uncomment to allow) -->
		<!--<div class="wideslider_nextprev"></div>-->
		
		<!-- here will be slider index navigation (not remove) -->
		<div class="wideslider_nav"></div>
		
		<!-- end: wide slider -->
		
	</div>
	<!-- end: slider env -->
</div>
<?php
	endif;
?>