<?php
/*
 * 
 * Require the framework class before doing anything else, so we can use the defined urls and dirs
 * Also if running on windows you may have url problems, which can be fixed by defining the framework url first
 *
 */
//define('NHP_OPTIONS_URL', site_url('path the options folder'));
if(!class_exists('NHP_Options')){
	require_once( dirname( __FILE__ ) . '/options/options.php' );
}

/*
 * 
 * Custom function for filtering the sections array given by theme, good for child themes to override or add to the sections.
 * Simply include this function in the child themes functions.php file.
 *
 * NOTE: the defined constansts for urls, and dir will NOT be available at this point in a child theme, so you must use
 * get_template_directory_uri() if you want to use any of the built in icons
 *
 */
function add_another_section($sections){
	
	//$sections = array();
	$sections[] = array(
				'title' => __('A Section added by hook', 'nhp-opts'),
				'desc' => __('<p class="description">This is a section created by adding a filter to the sections array, great to allow child themes, to add/remove sections from the options.</p>', 'nhp-opts'),
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it blank for default.
				'icon' => trailingslashit(get_template_directory_uri()).'options/img/glyphicons/glyphicons_062_attach.png',
				//Lets leave this as a blank section, no options just some intro text set above.
				'fields' => array()
				);
	
	return $sections;
	
}//function
//add_filter('nhp-opts-sections-twenty_eleven', 'add_another_section');


/*
 * 
 * Custom function for filtering the args array given by theme, good for child themes to override or add to the args array.
 *
 */
function change_framework_args($args){
	
	//$args['dev_mode'] = false;
	
	return $args;
	
}//function
//add_filter('nhp-opts-args-twenty_eleven', 'change_framework_args');









/*
 * This is the meat of creating the optons page
 *
 * Override some of the default values, uncomment the args and change the values
 * - no $args are required, but there there to be over ridden if needed.
 *
 *
 */

function setup_framework_options(){
$args = array();

//Set it to dev mode to view the class settings/info in the form - default is false
$args['dev_mode'] = false;

//google api key MUST BE DEFINED IF YOU WANT TO USE GOOGLE WEBFONTS
//$args['google_api_key'] = '***';

//Remove the default stylesheet? make sure you enqueue another one all the page will look whack!
//$args['stylesheet_override'] = true;

//Add HTML before the form
$args['intro_text'] = __('', 'nhp-opts');

//Setup custom links in the footer for share icons
$args['share_icons']['twitter'] = array(
										'link' => 'http://twitter.com/webbudesign',
										'title' => 'Folow me on Twitter', 
										'img' => NHP_OPTIONS_URL.'img/glyphicons/glyphicons_322_twitter.png'
										);
$args['share_icons']['facebook'] = array(
										'link' => 'https://www.facebook.com/WebbuDesign',
										'title' => 'Folow me on Facebook', 
										'img' => NHP_OPTIONS_URL.'img/glyphicons/glyphicons_320_facebook.png'
										);

//Choose to disable the import/export feature
//$args['show_import_export'] = false;

//Choose a custom option name for your theme options, the default is the theme name in lowercase with spaces replaced by underscores
$args['opt_name'] = 'metromobile_options';

//Custom menu icon
//$args['menu_icon'] = '';

//Custom menu title for options page - default is "Options"
$args['menu_title'] = __('Metro Mobile', 'nhp-opts');

//Custom Page Title for options page - default is "Options"
$args['page_title'] = __('Metro Mobile Options Panel', 'nhp-opts');

//Custom page slug for options page (wp-admin/themes.php?page=***) - default is "nhp_theme_options"
$args['page_slug'] = 'nhp_theme_options';

//Custom page capability - default is set to "manage_options"
//$args['page_cap'] = 'manage_options';

//page type - "menu" (adds a top menu section) or "submenu" (adds a submenu) - default is set to "menu"
//$args['page_type'] = 'submenu';

//parent menu - default is set to "themes.php" (Appearance)
//the list of available parent menus is available here: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
//$args['page_parent'] = 'themes.php';

//custom page location - default 100 - must be unique or will override other items
$args['page_position'] = 27;

//Custom page icon class (used to override the page icon next to heading)
//$args['page_icon'] = 'icon-themes';

//Want to disable the sections showing as a submenu in the admin? uncomment this line
//$args['allow_sub_menu'] = false;
		
//Set ANY custom page help tabs - displayed using the new help tab API, show in order of definition		
$args['help_tabs'][] = array(
							'id' => 'nhp-opts-1',
							'title' => __('Theme Information 1', 'nhp-opts'),
							'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'nhp-opts')
							);
$args['help_tabs'][] = array(
							'id' => 'nhp-opts-2',
							'title' => __('Theme Information 2', 'nhp-opts'),
							'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'nhp-opts')
							);

//Set the Help Sidebar for the options page - no sidebar by default										
$args['help_sidebar'] = __('<p>This is the sidebar content, HTML is allowed.</p>', 'nhp-opts');



$sections = array();

$sections[] = array(
				'title' => __('General Options', 'nhp-opts'),
				'desc' => __('<p class="description">You can manage general paramaters.</p>', 'nhp-opts'),
				'icon' => NHP_OPTIONS_URL.'img/glyphicons/glyphicons_019_cogwheel.png',
				'fields' => array(
						array(
							'id' => 'theme_outside',
							'type' => 'select',
							'title' => __('Select Theme', 'nhp-opts'), 
							'sub_desc' => __('Dark or Light?', 'nhp-opts'),
							'options' => array('dark' => 'Dark Theme','light' => 'Light Theme'),//Must provide key => value pairs for select options
							'std' => 'dark'
						    ),
						array(
							'id' => 'theme_rtl_select',
							'type' => 'select',
							'title' => __('Enable RTL', 'nhp-opts'), 
							'sub_desc' => __('This option will enable right to left text support. Default is: No', 'nhp-opts'),
							'options' => array('1' => 'Yes','0' => 'No'),//Must provide key => value pairs for select options
							'std' => '0'
						    ),
						array(
							'id' => 'theme_loadingani',
							'type' => 'select',
							'title' => __('Loading Animation', 'nhp-opts'), 
							'sub_desc' => __('Do you want to disable?', 'nhp-opts'),
							'options' => array('yes' => 'Use Loading Animation','no' => 'Disable Loading Animation'),//Must provide key => value pairs for select options
							'std' => 'yes'
						    ),
						array(
							'id' => 'custom_bgphoto',
							'type' => 'upload',
							'title' => __('Custom BG Image', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own tileable bg image photo.', 'nhp-opts')
						   ),
						array(
							'id' => 'general_bubble',
							'type' => 'checkbox',
							'title' => __('Disable Add Home Bubble', 'nhp-opts'), 
							'sub_desc' => __('You can enable and disable it.', 'nhp-opts'),
							'desc' => __('Click here if you want to disable.', 'nhp-opts'),
							'std' => '0'// 1 = on | 0 = off
							),

						array(
							'id' => 'portfolio_column',
							'type' => 'select',
							'title' => __('Portfolio Columns', 'nhp-opts'), 
							'sub_desc' => __('How many column want to see in portfolio page?', 'nhp-opts'),
							'options' => array('portfolio-one' => '1','portfolio-two' => '2','portfolio-three' => '3'),//Must provide key => value pairs for select options
							'std' => '3'
						    ),
						
						array(
							'id' => 'custom_post_number_portfolio',
							'type' => 'text',
							'title' => __('Portfolio Items Per Page', 'nhp-opts'),
							'sub_desc' => __('Portfolio items per page. Default is: 9', 'nhp-opts'),
							'validate' => 'numeric',
							'std' => '9',
							'class' => 'small-text'
							),
							
						array(
							'id' => 'custom_favico',
							'type' => 'upload',
							'title' => __('Custom Favico', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own favicon file.', 'nhp-opts')
						   ),
					   array(
							'id' => 'custom_home_icon',
							'type' => 'upload',
							'title' => __('Mobile Home Icon', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own add to home icon file. Size 114x114 px. Check sources folder for sample.', 'nhp-opts')
						   )
					)
				);

$sections[] = array(
				'title' => __('Page Settings', 'nhp-opts'),
				'desc' => __('<p class="description">You can manage page paramaters.</p>', 'nhp-opts'),
				'icon' => NHP_OPTIONS_URL.'img/glyphicons/glyphicons_114_list.png',
				'fields' => array(
						array(
							'id' => 'homepage_page_select',
							'type' => 'pages_select',
							'title' => __('Select Home Page', 'nhp-opts'), 
							'sub_desc' => __('Please select a page for home. If you want to disable select "Disable Page" option.', 'nhp-opts'),
							//'desc' => __('You have to to select one page for slider show.', 'nhp-opts'),
							'args' => array()
							),
						array(
							'id' => 'blog_page_select',
							'type' => 'pages_select',
							'title' => __('Select Blog Page', 'nhp-opts'), 
							'sub_desc' => __('Please select a page for blog. If you want to disable select "Disable Page" option.', 'nhp-opts'),
							//'desc' => __('You have to to select one page for slider show.', 'nhp-opts'),
							'args' => array()
							),
						
						array(
							'id' => 'portfolio_page_select',
							'type' => 'pages_select',
							'title' => __('Select Portfolio Page', 'nhp-opts'), 
							'sub_desc' => __('Please select a page for portfolio. If you want to disable select "Disable Page" option.', 'nhp-opts'),
							//'desc' => __('You have to to select one page for slider show.', 'nhp-opts'),
							'args' => array()
							)
						
				
					)
				);
								
$sections[] = array(
				'title' => __('Splash Screen', 'nhp-opts'),
				'desc' => __('<p class="description">You can manage splash screen variables.</p>', 'nhp-opts'),
				'icon' => NHP_OPTIONS_URL.'img/glyphicons/glyphicons_139_phone.png',
				'fields' => array(
						
					   array(
							'id' => 'custom_splash_screen',
							'type' => 'upload',
							'title' => __('Splash screen iPhone 3 etc', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own splash screen image. Check sources folder for sample.(apple-touch-startup-image-320x460.png)', 'nhp-opts')
						   ),
					   array(
							'id' => 'custom_splash_screen2',
							'type' => 'upload',
							'title' => __('Splash screen iPhone4 etc', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own splash screen image. Check sources folder for sample.(apple-touch-startup-image-640x920.png)', 'nhp-opts')
						   ),
					   array(
							'id' => 'custom_splash_screen3',
							'type' => 'upload',
							'title' => __('Splash screen iPhone 5 etc', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own splash screen image. Check sources folder for sample.(apple-touch-startup-image-640x1096.png)', 'nhp-opts')
						   ),
					  array(
							'id' => 'custom_splash_screen4',
							'type' => 'upload',
							'title' => __('Splash screen Portrait Tablets', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own splash screen image. Check sources folder for sample.(apple-touch-startup-image-768x1004.png)', 'nhp-opts')
						   ),
					  array(
							'id' => 'custom_splash_screen5',
							'type' => 'upload',
							'title' => __('Splash screen Landscape Tablets', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own splash screen image. Check sources folder for sample.(apple-touch-startup-image-748x1024.png)', 'nhp-opts')
						   ),
				      array(
							'id' => 'custom_splash_screen6',
							'type' => 'upload',
							'title' => __('Splash screen Portrait Retina Tablets', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own splash screen image. Check sources folder for sample.(apple-touch-startup-image-1536x2008.png)', 'nhp-opts')
						   ),
				      array(
							'id' => 'custom_splash_screen7',
							'type' => 'upload',
							'title' => __('Splash screen Landscape Retina Tablets', 'nhp-opts'), 
							'sub_desc' => __('You can upload your own splash screen image. Check sources folder for sample.(apple-touch-startup-image-1496x2048.png)', 'nhp-opts')
						   )
					)
				);							
				
$sections[] = array(
				'title' => __('Blog Settings', 'nhp-opts'),
				'desc' => __('<p class="description">You can manage blog page paramaters.</p>', 'nhp-opts'),
				'icon' => NHP_OPTIONS_URL.'img/glyphicons/glyphicons_309_comments.png',
				'fields' => array(
						
						array(
							'id' => 'blog_category_check',
							'type' => 'checkbox',
							'title' => __('Disable Category', 'nhp-opts'), 
							'sub_desc' => __('If you not want to show category name check here.', 'nhp-opts'),
							'std' => '0'// 1 = on | 0 = off
							),
						
						array(
							'id' => 'blog_author_check',
							'type' => 'checkbox',
							'title' => __('Disable Author', 'nhp-opts'), 
							'sub_desc' => __('If you not want to show author name check here.', 'nhp-opts'),
							'std' => '0'// 1 = on | 0 = off
							),
							
						
						array(
							'id' => 'blog_comment_check',
							'type' => 'checkbox',
							'title' => __('Disable Comments', 'nhp-opts'), 
							'sub_desc' => __('If you not want to show comments and comment form check here.', 'nhp-opts'),
							'std' => '0'// 1 = on | 0 = off
							),
						
						array(
							'id' => 'blog_date_check',
							'type' => 'checkbox',
							'title' => __('Disable Date', 'nhp-opts'), 
							'sub_desc' => __('If you not want to show date field check here.', 'nhp-opts'),
							'std' => '0'// 1 = on | 0 = off
							),
							
						array(
							'id' => 'blog_category_show',
							'type' => 'checkbox',
							'title' => __('Show All Categories', 'nhp-opts'), 
							'sub_desc' => __('If you want to show all category posts check here.', 'nhp-opts'),
							'std' => '0'// 1 = on | 0 = off
							),
							
						array(
							'id' => 'blog_category_id',
							'type' => 'cats_select',
							'title' => __('Select blog page category', 'nhp-opts'), 
							'args' => array('number' => '0')//uses get_categories
							),
										
							
						array(
							'id' => 'custom_post_number',
							'type' => 'text',
							'title' => __('Blog Post Number', 'nhp-opts'),
							'sub_desc' => __('How many post you want to show on Home Page Blog Post? Default is : 5', 'nhp-opts'),
							'validate' => 'numeric',
							'std' => '5',
							'class' => 'small-text'
							),
				
					)
				);
								
				
$sections[] = array(
				'title' => __('Seo Settings', 'nhp-opts'),
				'desc' => __('<p class="description">You can manage seo page paramaters.</p>', 'nhp-opts'),
				'icon' => NHP_OPTIONS_URL.'img/glyphicons/glyphicons_138_computer_proces.png',
				'fields' => array(
				
						array(
							'id' => 'disable_analytic',
							'type' => 'checkbox',
							'title' => __('Disable Google Analytics', 'nhp-opts'), 
							'sub_desc' => __('Are you want to disable google analytic script?', 'nhp-opts'),
							'std' => '0'// 1 = on | 0 = off
							),
					
						array(
							'id' => 'custom_analytic',
							'type' => 'text',
							'title' => __('Google Analytic', 'nhp-opts'),
							'sub_desc' => __('Lat number', 'nhp-opts'),
							'std' => '0',
							'class' => 'medium-text'
							),
							
						array(
							'id' => 'custom_desc',
							'type' => 'textarea',
							'title' => __('Meta Desc.', 'nhp-opts'), 
							'sub_desc' => __('All HTML will be stripped', 'nhp-opts'),
							'validate' => 'no_html',
							'std' => 'Your meta description'
							),
							
						array(
							'id' => 'custom_keyw',
							'type' => 'textarea',
							'title' => __('Meta Keywords', 'nhp-opts'), 
							'sub_desc' => __('Your Meta keywords', 'nhp-opts'),
							'validate' => 'no_html',
							'std' => 'No HTML is allowed in here.'
							),					
					)
				);
				
$sections[] = array(
				'title' => __('Auto Update', 'nhp-opts'),
				'desc' => __('<p class="description">PLEASE BACKUP YOUR SETTINGS BEFORE UPDATE. You can manage auto template update paramaters. If you write Envato Themeforest Username and API Key here. Template updates will be auto detected.</p>', 'nhp-opts'),
				'icon' => NHP_OPTIONS_URL.'img/glyphicons/glyphicons_009_magic.png',
				'fields' => array(
						array(
							'id' => 'envatousername',
							'type' => 'text',
							'title' => __('Envato Username', 'nhp-opts'),
							'sub_desc' => __('Please enter Themeforest Username', 'nhp-opts'),
							'desc' => __('Required.', 'nhp-opts'),
							'std' => '',
							'class' => 'large-text'
							),
						array(
							'id' => 'envatoapikey',
							'type' => 'text',
							'title' => __('Envato API Key', 'nhp-opts'),
							'sub_desc' => __('Please enter Themeforest API Key. <a href="http://www.webbudesign.com/envato/apikey.png" target="_blank">Click here for how to find.</a>', 'nhp-opts'),
							'desc' => __('Required.', 'nhp-opts'),
							'std' => '',
							'class' => 'large-text'
							),
					)
				);
												
				
				
	$tabs = array();
			
	if (function_exists('wp_get_theme')){
		$theme_data = wp_get_theme();
		$theme_uri = $theme_data->get('ThemeURI');
		$description = $theme_data->get('Description');
		$author = $theme_data->get('Author');
		$version = $theme_data->get('Version');
		$tags = $theme_data->get('Tags');
	}else{
		$theme_data = wp_get_theme(trailingslashit(get_stylesheet_directory()).'style.css');
		$theme_uri = $theme_data['URI'];
		$description = $theme_data['Description'];
		$author = $theme_data['Author'];
		$version = $theme_data['Version'];
		$tags = $theme_data['Tags'];
	}	

	$theme_info = '<div class="nhp-opts-section-desc">';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-uri">'.__('<strong>Theme URL:</strong> ', 'nhp-opts').'<a href="'.$theme_uri.'" target="_blank">'.$theme_uri.'</a></p>';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-author">'.__('<strong>Author:</strong> ', 'nhp-opts').$author.'</p>';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-version">'.__('<strong>Version:</strong> ', 'nhp-opts').$version.'</p>';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-description">'.$description.'</p>';
	$theme_info .= '<p class="nhp-opts-theme-data description theme-tags">'.__('<strong>Tags:</strong> ', 'nhp-opts').implode(', ', $tags).'</p>';
	$theme_info .= '</div>';
	
	
	global $NHP_Options;
	$NHP_Options = new NHP_Options($sections, $args, $tabs);

}//function
add_action('init', 'setup_framework_options', 0);

/*
 * 
 * Custom function for the callback referenced above
 *
 */
function my_custom_field($field, $value){
	print_r($field);
	print_r($value);

}//function

/*
 * 
 * Custom function for the callback validation referenced above
 *
 */
function validate_callback_function($field, $value, $existing_value){
	
	$error = false;
	$value =  'just testing';
	/*
	do your validation
	
	if(something){
		$value = $value;
	}elseif(somthing else){
		$error = true;
		$value = $existing_value;
		$field['msg'] = 'your custom error message';
	}
	*/
	
	$return['value'] = $value;
	if($error == true){
		$return['error'] = $field;
	}
	return $return;
	
}//function
?>