<?php

/*-----------------------------------------------------------------------------------*/
/*	Button Config
/*-----------------------------------------------------------------------------------*/
$webbu_shortcodes['button'] = array(
	'no_preview' => true,
	'params' => array(
		'url' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Button URL', 'textdomain'),
			'desc' => __('Add the button\'s url eg http://example.com', 'textdomain')
		),
		
		'size' => array(
			'type' => 'select',
			'label' => __('Button Size', 'textdomain'),
			'desc' => __('Select the button\'s size.', 'textdomain'),
			'options' => array(
				'btn-mini' => 'Mini Button',
				'btn-small' => 'Small Button',
				'normal' => 'Normal Button',
				'btn-large' => 'Large Button'
			),
			
		),
		
		'color' => array(
			'type' => 'select',
			'label' => __('Button Color', 'textdomain'),
			'desc' => __('Select the button\'s color.', 'textdomain'),
			'options' => array(
				'normal' => 'Grey',
				'btn-info' => 'Light Blue',
				'btn-success' => 'Green',
				'btn-primary' => 'Blue',
				'btn-warning' => 'Yellow',
				'btn-danger' => 'Red',
				'btn-inverse' => 'Black'
			),
			
		),
		
		'target' => array(
			'type' => 'select',
			'label' => __('Button Target', 'textdomain'),
			'desc' => __('Select the button\'s target.', 'textdomain'),
			'options' => array(
				'_self' => '_self',
				'_blank' => '_blank',
				'_parent' => '_parent'
			),
			
		),
		
		'content' => array(
			'std' => 'Button Text',
			'type' => 'text',
			'label' => __('Button\'s Text', 'textdomain'),
			'desc' => __('Add the button\'s text', 'textdomain'),
		)
	),
	'shortcode' => '[webbu_button url="{{url}}" size="{{size}}" color="{{color}}" target="{{target}}"] {{content}} [/webbu_button]',
	'popup_title' => __('Insert Button Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Badges Config
/*-----------------------------------------------------------------------------------*/
$webbu_shortcodes['badges'] = array(
	'no_preview' => true,
	'params' => array(
		'color' => array(
			'type' => 'select',
			'label' => __('Badge Style', 'textdomain'),
			'desc' => __('Select the badge\'s style, ie the badge colour', 'textdomain'),
			'options' => array(
				'badge-important' => 'Red',
				'badge-success' => 'Green',
				'badge-info' => 'Blue',
				'badge-warning' => 'Yellow',
				'' => 'Grey',
				'badge-inverse' => 'Black'
			)
		),
		'content' => array(
			'std' => 'Badge!',
			'type' => 'textarea',
			'label' => __('Badge Text', 'textdomain'),
			'desc' => __('Add the badge\'s text', 'textdomain'),
		)
		
	),
	'shortcode' => '[webbu_badge color="{{color}}"] {{content}} [/webbu_badge]',
	'popup_title' => __('Insert Badge Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Label Config
/*-----------------------------------------------------------------------------------*/
$webbu_shortcodes['labels'] = array(
	'no_preview' => true,
	'params' => array(
		'color' => array(
			'type' => 'select',
			'label' => __('Label Style', 'textdomain'),
			'desc' => __('Select the label\'s style, ie the badge colour', 'textdomain'),
			'options' => array(
				'label-important' => 'Red',
				'label-success' => 'Green',
				'label-info' => 'Blue',
				'label-warning' => 'Yellow',
				'' => 'Grey',
				'label-inverse' => 'Black'
			)
		),
		'content' => array(
			'std' => 'Label!',
			'type' => 'textarea',
			'label' => __('Label Text', 'textdomain'),
			'desc' => __('Add the label\'s text', 'textdomain'),
		)
		
	),
	'shortcode' => '[webbu_label color="{{color}}"] {{content}} [/webbu_label]',
	'popup_title' => __('Insert Label Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Blockquote Config
/*-----------------------------------------------------------------------------------*/
$webbu_shortcodes['blockquote'] = array(
	'no_preview' => true,
	'params' => array(
		'direction' => array(
			'type' => 'select',
			'label' => __('Blockquote Style', 'textdomain'),
			'desc' => __('Select the blockquote\'s style, ie the badge colour', 'textdomain'),
			'options' => array(
				'pull-right' => 'Pull Right',
				'' => 'Pull Left'
			)
		),
		'content' => array(
			'std' => 'Blockquote!',
			'type' => 'textarea',
			'label' => __('Blockquote Text', 'textdomain'),
			'desc' => __('Add the blockquote\'s text', 'textdomain'),
		)
		
	),
	'shortcode' => '[webbu_blockquote direction="{{direction}}"] {{content}} [/webbu_blockquote]',
	'popup_title' => __('Insert Blockquote Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Columns Config
/*-----------------------------------------------------------------------------------*/
$webbu_shortcodes['columns'] = array(
	'no_preview' => true,
	'params' => array(
		
		'direction' => array(
			'type' => 'select',
			'label' => __('Columns Style', 'textdomain'),
			'desc' => __('Select the columns\'s style, ie the badge colour', 'textdomain'),
			'options' => array(
				'one-half' => 'One Half',
				'one-third' => 'One Third'
			)
		),
		'lastbox' => array(
			'std' => 'off',
			'type' => 'select',
			'label' => __('Last Column', 'textdomain'),
			'desc' => __('Check this box if the column is last', 'textdomain'),
			'options' => array(
				'on' => 'Yes',
				'off' => 'No',
				)
		),
		'content' => array(
			'std' => 'Columns!',
			'type' => 'textarea',
			'label' => __('Columns Text', 'textdomain'),
			'desc' => __('Add the columns\'s text', 'textdomain'),
		)
		
	),
	'shortcode' => '[webbu_columns direction="{{direction}}" lastbox="{{lastbox}}"] {{content}} [/webbu_columns]',
	'popup_title' => __('Insert Columns Shortcode', 'textdomain')
);



/*-----------------------------------------------------------------------------------*/
/*	Alert Config
/*-----------------------------------------------------------------------------------*/
$webbu_shortcodes['alert'] = array(
	'no_preview' => true,
	'params' => array(
		'style' => array(
			'type' => 'select',
			'label' => __('Alert Style', 'textdomain'),
			'desc' => __('Select the alert\'s style, ie the alert colour', 'textdomain'),
			'options' => array(
				'alert-error' => 'Red',
				'alert-success' => 'Green',
				'alert-info' => 'Blue',
				'alert-warning' => 'Yellow'
			)
		),
		'content' => array(
			'std' => 'Your Alert!',
			'type' => 'textarea',
			'label' => __('Alert Text', 'textdomain'),
			'desc' => __('Add the alert\'s text', 'textdomain'),
		)
		
	),
	'shortcode' => '[webbu_alert style="{{style}}"] {{content}} [/webbu_alert]',
	'popup_title' => __('Insert Alert Shortcode', 'textdomain')
);



/*-----------------------------------------------------------------------------------*/
/*	Tabs Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['tabs'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[webbu_tabs] {{child_shortcode}}  [/webbu_tabs]',
    'popup_title' => __('Insert Tab Shortcode', 'textdomain'),
    
    'child_shortcode' => array(
        'params' => array(
            'title' => array(
                'std' => 'Title',
                'type' => 'text',
                'label' => __('Tab Title', 'textdomain'),
                'desc' => __('Title of the tab', 'textdomain'),
            ),
            'content' => array(
                'std' => 'Tab Content',
                'type' => 'textarea',
                'label' => __('Tab Content', 'textdomain'),
                'desc' => __('Add the tabs content', 'textdomain')
            )
        ),
        'shortcode' => '[webbu_tab title="{{title}}"] {{content}} [/webbu_tab]', 
        'clone_button' => __('Add Tab', 'textdomain')
    )
);

/*-----------------------------------------------------------------------------------*/
/*	Toggle Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['toggle'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[webbu_toggles] {{child_shortcode}}  [/webbu_toggles]',
    'popup_title' => __('Insert Toggle Shortcode', 'textdomain'),
    
    'child_shortcode' => array(
        'params' => array(
            'title' => array(
                'std' => 'Title',
                'type' => 'text',
                'label' => __('Toggle Title', 'textdomain'),
                'desc' => __('Title of the Toggle', 'textdomain'),
            ),
            'content' => array(
                'std' => 'Toggle Content',
                'type' => 'textarea',
                'label' => __('Tab Content', 'textdomain'),
                'desc' => __('Add the Toggle content', 'textdomain')
            )
        ),
        'shortcode' => '[webbu_toggle title="{{title}}"] {{content}} [/webbu_toggle]', 
        'clone_button' => __('Add Toggle', 'textdomain')
    )
);


/*-----------------------------------------------------------------------------------*/
/*	Icon Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['icon'] = array(
    'no_preview' => true,
	'params' => array(
		'title' => array(
                'std' => 'icon-magic',
                'type' => 'text',
                'label' => __('Icon Name', 'textdomain'),
                'desc' => __('Please write icon name ex: <a href="http://fortawesome.github.com/Font-Awesome/" target="_blank">Click here for list</a>', 'textdomain'),
            ),
		'color' => array(
                'std' => '#000000',
                'type' => 'text',
                'label' => __('Icon Color', 'textdomain'),
                'desc' => __('Please write hex code color. Ex: #000000', 'textdomain'),
            ),
		'size' => array(
                'std' => '12',
                'type' => 'text',
                'label' => __('Icon Size', 'textdomain'),
                'desc' => __('Please write size (px). Ex:12', 'textdomain'),
            )

	),
	'shortcode' => '[webbu_icon title="{{title}}" size="{{size}}" color="{{color}}"][/webbu_icon]',
	'popup_title' => __('Insert Icon Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Well Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['wells'] = array(
    'no_preview' => true,
	'params' => array(
		'size' => array(
			'type' => 'select',
			'label' => __('Well Size', 'textdomain'),
			'desc' => __('Select the well\'s size.', 'textdomain'),
			'options' => array(
				'small' => 'Well Small',
				'large' => 'Well Large'
			)
		),
		'content' => array(
			'std' => 'Your Text!',
			'type' => 'textarea',
			'label' => __('Well Text', 'textdomain'),
			'desc' => __('Add the well box text', 'textdomain'),
		)

	),
	'shortcode' => '[webbu_well] {{content}} [/webbu_well]',
	'popup_title' => __('Insert Well Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Google Map
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['googlemap'] = array(
    'no_preview' => true,
	'params' => array(
		'address' => array(
			'std' => 'New York, USA',
			'type' => 'text',
			'label' => __('Address', 'textdomain'),
			'desc' => __('Please write address.Ex: New York, USA', 'textdomain'),
		),
		
		'height' => array(
			'std' => '255',
			'type' => 'text',
			'label' => __('Height', 'textdomain'),
			'desc' => __('Please write height(px). Just write number. Ex: 255', 'textdomain'),
		)

	),
	'shortcode' => '[webbu_googlemap address="{{address}}" height="{{height}}"][/webbu_googlemap]',
	'popup_title' => __('Insert Google Map Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Twitter Page
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['twitter'] = array(
    'no_preview' => true,
	'params' => array(
		'username' => array(
			'std' => 'webbudesign',
			'type' => 'text',
			'label' => __('Twitter Username', 'textdomain'),
			'desc' => __('Please your username', 'textdomain'),
		),
		
		'tweetnumber' => array(
			'std' => '5',
			'type' => 'text',
			'label' => __('Tweet Number', 'textdomain'),
			'desc' => __('Please write tweet number per page.', 'textdomain'),
		)

	),
	'shortcode' => '[webbu_twitter username="{{username}}" tweetnumber="{{tweetnumber}}"][/webbu_twitter]',
	'popup_title' => __('Insert Twitter Page Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Divider Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['dividers'] = array(
    'no_preview' => false,
	'params' => array(
		'style' => array(
			'type' => 'select',
			'label' => __('Divider Type', 'textdomain'),
			'desc' => __('Select a divider.', 'textdomain'),
			'options' => array(
				'1' => 'Divider 1',
				'2' => 'Divider 2',
				'3' => 'Divider 3',
				'4' => 'Divider 4',
				'5' => 'Divider 5',
				'6' => 'Divider 6',
				'7' => 'Divider 7',
				'8' => 'Divider 8',
				'9' => 'Divider 9',
				'10' => 'Divider 10',
				'11' => 'Divider 11',
				'12' => 'Divider 12',
				'13' => 'Divider 13',
				'14' => 'Divider 14',
				'15' => 'Divider 15',
				'16' => 'Divider 16',
				'17' => 'Divider 17',
				'18' => 'Divider 18',
				'19' => 'Divider 19',
				'20' => 'Divider 20',
			)
		)
	),
	'shortcode' => '[webbu_divider style="{{style}}"]',
	'popup_title' => __('Insert Divider Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Clearfix Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['clear'] = array(
    'no_preview' => true,
	'no_preview' => true,
	'params' => array(),
	'shortcode' => '[webbu_clearfix]',
	'popup_title' => __('Insert Clearfix Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Image Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['image'] = array(
    'no_preview' => true,
	'params' => array(
		'type' => array(
			'type' => 'select',
			'label' => __('Photo Frame Type', 'textdomain'),
			'desc' => __('Select a frame type.', 'textdomain'),
			'options' => array(
				'circle' => 'Circle',
				'polaroid' => 'Polaroid',
				'rounded' => 'Rounded',
				'none' => 'None'
			)
		),
		'align' => array(
			'type' => 'select',
			'label' => __('Photo Align', 'textdomain'),
			'desc' => __('Select an align type.', 'textdomain'),
			'options' => array(
				'left' => 'Left',
				'right' => 'Right',
				'center' => 'Center',
			)
		),
		'tag' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Alt Tag', 'textdomain'),
			'desc' => __('Image alt tag.', 'textdomain'),
		),
		'url' => array(
			'std' => 'Photo URL',
			'type' => 'text',
			'label' => __('Photo URL', 'textdomain'),
			'desc' => __('Please write url of photo. Like http://www...', 'textdomain'),
		)

	),
	'shortcode' => '[webbu_image alt="{{tag}}" align="{{align}}" type="{{type}}" url="{{url}}"][/webbu_image]',
	'popup_title' => __('Insert Image Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Table Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['table'] = array(
    'no_preview' => true,
	'params' => array(
		'type' => array(
			'type' => 'select',
			'label' => __('Table Type', 'textdomain'),
			'desc' => __('Please select a table type.', 'textdomain'),
			'options' => array(
				'striped' => 'Striped',
				'bordered' => 'Bordered',
				'hover' => 'Striped with Hover Effect',
				'condensed' => 'Condensed'
			)
		),
		'cols' => array(
			'std' => '#,First Name, Last Name, Username',
			'type' => 'textarea',
			'label' => __('Table Cols', 'textdomain'),
			'desc' => __('Please write cols code sample.', 'textdomain'),
		),
		'data' => array(
			'std' => '1, Filip, Stefansson, filipstefansson, 2, Victor, Meyer, Pudge, 3, Mans, Ketola-Backe, mossboll',
			'type' => 'textarea',
			'label' => __('Table Data', 'textdomain'),
			'desc' => 'Please write data like code sample.',
		)

	),
	'shortcode' => '[webbu_table type="{{type}}" cols="{{cols}}" data="{{data}}"][/webbu_table]',
	'popup_title' => __('Insert Table Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Button Group Config
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['buttong'] = array(
    'no_preview' => true,
	'params' => array(
		'align' => array(
				'type' => 'select',
				'label' => __('Button Group Align', 'textdomain'),
				'desc' => __('Select an align type.', 'textdomain'),
				'options' => array(
					'left' => 'Left',
					'right' => 'Right',
					'center' => 'Center',
				)
			),
		),
	'shortcode' => '[webbu_buttong align="{{align}}"] Please delete this text and insert your buttons here. [/webbu_buttong]',
	'popup_title' => __('Insert Button Group Shortcode', 'textdomain'),
);

/*-----------------------------------------------------------------------------------*/
/*	Video Config
/*-----------------------------------------------------------------------------------*/
$webbu_shortcodes['video'] = array(
	'no_preview' => true,
	'params' => array(
		'type' => array(
			'type' => 'select',
			'label' => __('Video Type', 'textdomain'),
			'desc' => __('Please select type of video', 'textdomain'),
			'options' => array(
				'youtube' => 'You Tube',
				'vimeo' => 'Vimeo'
			)
		),
		'src' => array(
			'std' => '23237102',
			'type' => 'text',
			'label' => __('Video ID', 'textdomain'),
			'desc' => 'Vimeo ID like: 23237102 / Youtube ID like: MT_r7Nw14EA ',
		)
		
	),
	'shortcode' => '[webbu_video type="{{type}}" src="{{src}}"][/webbu_video]',
	'popup_title' => __('Insert Video Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Webbu Image Tile 
/*-----------------------------------------------------------------------------------*/	
$webbu_shortcodes['tileimage'] = array(
    'no_preview' => true,
	'params' => array(
		'size' => array(
			'type' => 'select',
			'label' => __('Tile Size', 'textdomain'),
			'desc' => __('Select a tile type', 'textdomain'),
			'options' => array(
				'' => 'Box (Standart Square)',
				't2x' => 'Double Box Horizontal',
				't2x-v' => 'Double Box Vertical',
				't3x' => 'Triple Box Horizontal',
				't3x-v' => 'Triple Box Vertical',
				't4x' => 'Quadro Box Horizontal',
				't4x-v' => 'Quadro Box Vertical',
				't2x-b' => 'Double Horizontal / Double Vertical Box',
				't3x-b' => 'Triple Horizontal / Triple Vertical Box',
				't4x-b' => 'Quadro Horizontal / Quadro Vertical Box',
				't3x-t2x-b' => 'Triple Horizontal / Double Vertical Box',
				't4x-t2x-b' => 'Quadro Vertical / Double Horizontal Box',
				't4x-t2x22-b' => 'Quadro Horizontal / Double Vertical Box',
				't4x-t1x-b' => 'Quadro Horizontal / Single Vertical Box'
			)
		),
		'url' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Tile Link URL', 'textdomain'),
			'desc' => __('Please write tile click link url. Like http://www...(Optional)', 'textdomain'),
		),
		'pageid' => array(
			'type' => 'select2',
			'label' => __('Tile Link Page', 'textdomain'),
			'desc' => __('Select page link please. ( If write URL Link Empty )', 'textdomain')
			
		),
		
		'iurl' => array(
			'std' => 'Tile Image URL',
			'type' => 'text',
			'label' => __('Tile Image URL', 'textdomain'),
			'desc' => __('Please paste your image url. Like http://www...', 'textdomain'),
		),

		
		'alt' => array(
			'std' => '-',
			'type' => 'text',
			'label' => __('Tile Image Alt Tag', 'textdomain'),
			'desc' => __('Please write alt tag for image (Optional)', 'textdomain'),
		),
		
		'sname' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Sub Name', 'textdomain'),
			'desc' => __('(Optional)Please write tile name. ( If you write sub tile name please do not write icon name it will not shown.) ', 'textdomain'),
		),
		
		'simage' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Sub Icon', 'textdomain'),
			'desc' => __('(Optional)Please paste your icon name. You can find all names in <a href="http://fortawesome.github.com/Font-Awesome/" target="_blank">FontAwesome Site</a>(If you leave blank tile sub text will be written)', 'textdomain'),
		),
		'ccolor' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Custom color', 'textdomain'),
			'desc' => __('#ffffff ( Optional)', 'textdomain'),
		),
		'scolor' => array(
			'type' => 'select',
			'label' => __('Sub Name / Icon BG', 'textdomain'),
			'desc' => __('Select a color please.', 'textdomain'),
			'options' => array(
				'' => 'Transparent',
				'TLightRed' => 'LightRed',
				'TRed' => 'Red',
				'TBrown' => 'Brown',
				'TLightOrange' => 'Light Orange',
				'TOrange' => 'Orange',
				'TLightPurple' => 'Light Purple',
				'TDarkPurple' => 'Dark Purple',
				'TLightBlue' => 'Light Blue',
				'TBlue' => 'Blue',
				'TDarkBlue' => 'Dark Blue',
				'TFacebookBlue' => 'Facebook Blue',
				'TTwitterBlue' => 'Twitter Blue',
				'TThumblrBlue' => 'Thumblr Blue',
				'TLinkedinBlue' => 'Linkedin Blue',
				'TDribbblePink' => 'Dribbble Pink',
				'TTurquise' => 'Turquise',
				'TLightGrey' => 'Light Grey',
				'TGrey' => 'Grey',
				'TDarkGrey' => 'Dark Grey',
				'TLightGreen' => 'Light Green',
				'TGreen' => 'Green',
				'TDarkGreen' => 'Dark Green',
				'TBlack' => 'Black',
				'TWhite' => 'White'
			)
		),

	),
	'shortcode' => '[webbu_imgtile size="{{size}}" url="{{url}}" ccolor="{{ccolor}}" pi="{{pageid}}" alt="{{alt}}" sname="{{sname}}" sicon="{{simage}}" scolor="{{scolor}}"]{{iurl}}[/webbu_imgtile]',
	'popup_title' => __('Insert Tile Image Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Webbu video Tile 
/*-----------------------------------------------------------------------------------*/	
$webbu_shortcodes['tilevideo'] = array(
    'no_preview' => true,
	'params' => array(
		'size' => array(
			'type' => 'select',
			'label' => __('Tile Size', 'textdomain'),
			'desc' => __('Select a tile type', 'textdomain'),
			'options' => array(
				'' => 'Box (Standart Square)',
				't2x' => 'Double Box Horizontal',
				't2x-v' => 'Double Box Vertical',
				't3x' => 'Triple Box Horizontal',
				't3x-v' => 'Triple Box Vertical',
				't4x' => 'Quadro Box Horizontal',
				't4x-v' => 'Quadro Box Vertical',
				't2x-b' => 'Double Horizontal / Double Vertical Box',
				't3x-b' => 'Triple Horizontal / Triple Vertical Box',
				't4x-b' => 'Quadro Horizontal / Quadro Vertical Box',
				't3x-t2x-b' => 'Triple Horizontal / Double Vertical Box',
				't4x-t2x-b' => 'Quadro Vertical / Double Horizontal Box',
				't4x-t2x22-b' => 'Quadro Horizontal / Double Vertical Box',
				't4x-t1x-b' => 'Quadro Horizontal / Single Vertical Box'
			)
		),
		
		'type' => array(
			'type' => 'select',
			'label' => __('Video Type', 'textdomain'),
			'desc' => __('Please select type of video', 'textdomain'),
			'options' => array(
				'youtube' => 'You Tube',
				'vimeo' => 'Vimeo'
			)
		),
		'src' => array(
			'std' => '23237102',
			'type' => 'text',
			'label' => __('Video ID', 'textdomain'),
			'desc' => 'Vimeo ID like: 23237102 / Youtube ID like: MT_r7Nw14EA ',
		)

	),
	'shortcode' => '[webbu_videotile size="{{size}}" type="{{type}}" src="{{src}}"][/webbu_videotile]',
	'popup_title' => __('Insert Tile Video Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Webbu Map Tile 
/*-----------------------------------------------------------------------------------*/	
$webbu_shortcodes['tilemap'] = array(
    'no_preview' => true,
	'params' => array(
		'size' => array(
			'type' => 'select',
			'label' => __('Tile Size', 'textdomain'),
			'desc' => __('Select a tile type', 'textdomain'),
			'options' => array(
				'' => 'Box (Standart Square)',
				't2x' => 'Double Box Horizontal',
				't2x-v' => 'Double Box Vertical',
				't3x' => 'Triple Box Horizontal',
				't3x-v' => 'Triple Box Vertical',
				't4x' => 'Quadro Box Horizontal',
				't4x-v' => 'Quadro Box Vertical',
				't2x-b' => 'Double Horizontal / Double Vertical Box',
				't3x-b' => 'Triple Horizontal / Triple Vertical Box',
				't4x-b' => 'Quadro Horizontal / Quadro Vertical Box',
				't3x-t2x-b' => 'Triple Horizontal / Double Vertical Box',
				't4x-t2x-b' => 'Quadro Vertical / Double Horizontal Box',
				't4x-t2x22-b' => 'Quadro Horizontal / Double Vertical Box',
				't4x-t1x-b' => 'Quadro Horizontal / Single Vertical Box'
			)
		),
		
		'address' => array(
			'std' => 'New York, USA',
			'type' => 'text',
			'label' => __('Address', 'textdomain'),
			'desc' => __('Please write address.Ex: New York, USA', 'textdomain'),
		)		

	),
	'shortcode' => '[webbu_maptile size="{{size}}" address="{{address}}"][/webbu_maptile]',
	'popup_title' => __('Insert Tile Map Shortcode', 'textdomain')
);

/*-----------------------------------------------------------------------------------*/
/*	Webbu Icon Tile 
/*-----------------------------------------------------------------------------------*/	
$webbu_shortcodes['tileicon'] = array(
    'no_preview' => true,
	'params' => array(
		'size' => array(
			'type' => 'select',
			'label' => __('Tile Size', 'textdomain'),
			'desc' => __('Select a tile type', 'textdomain'),
			'options' => array(
				'' => 'Box (Standart Square)',
				't2x' => 'Double Box Horizontal',
				't2x-v' => 'Double Box Vertical',
				't3x' => 'Triple Box Horizontal',
				't3x-v' => 'Triple Box Vertical',
				't4x' => 'Quadro Box Horizontal',
				't4x-v' => 'Quadro Box Vertical',
				't2x-b' => 'Double Horizontal / Double Vertical Box',
				't3x-b' => 'Triple Horizontal / Triple Vertical Box',
				't4x-b' => 'Quadro Horizontal / Quadro Vertical Box',
				't3x-t2x-b' => 'Triple Horizontal / Double Vertical Box',
				't4x-t2x-b' => 'Quadro Vertical / Double Horizontal Box',
				't4x-t2x22-b' => 'Quadro Horizontal / Double Vertical Box',
				't4x-t1x-b' => 'Quadro Horizontal / Single Vertical Box'
			)
		),
		'ccolor' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Custom color', 'textdomain'),
			'desc' => __('#ffffff ( Optional)', 'textdomain'),
		),
		'color' => array(
			'type' => 'select',
			'label' => __('Background Color', 'textdomain'),
			'desc' => __('Select a color please.', 'textdomain'),
			'options' => array(
				'TLightRed' => 'LightRed',
				'TRed' => 'Red',
				'TBrown' => 'Brown',
				'TLightOrange' => 'Light Orange',
				'TOrange' => 'Orange',
				'TLightPurple' => 'Light Purple',
				'TDarkPurple' => 'Dark Purple',
				'TLightBlue' => 'Light Blue',
				'TBlue' => 'Blue',
				'TDarkBlue' => 'Dark Blue',
				'TFacebookBlue' => 'Facebook Blue',
				'TTwitterBlue' => 'Twitter Blue',
				'TThumblrBlue' => 'Thumblr Blue',
				'TLinkedinBlue' => 'Linkedin Blue',
				'TDribbblePink' => 'Dribbble Pink',
				'TTurquise' => 'Turquise',
				'TLightGrey' => 'Light Grey',
				'TGrey' => 'Grey',
				'TDarkGrey' => 'Dark Grey',
				'TLightGreen' => 'Light Green',
				'TGreen' => 'Green',
				'TDarkGreen' => 'Dark Green',
				'TBlack' => 'Black',
				'TWhite' => 'White'
			)
		),
		'url' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Tile Link URL', 'textdomain'),
			'desc' => __('Please write tile click link url. Like http://www...(Optional)', 'textdomain'),
		),
		'pageid' => array(
			'type' => 'select2',
			'label' => __('Tile Link Page', 'textdomain'),
			'desc' => __('Select page link please. ( If write URL Link Empty )', 'textdomain')
			
		),
		
		'iurl' => array(
			'std' => 'icon-magic',
			'type' => 'text',
			'label' => __('Tile Icon Name', 'textdomain'),
			'desc' => __('Please paste your icon name. You can find all names in <a href="http://fortawesome.github.com/Font-Awesome/" target="_blank">FontAwesome Site</a>', 'textdomain'),
		),
		
		'iurl2' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Tile Image Icon URL', 'textdomain'),
			'desc' => __('Please paste your icon image url. Recommended size: 128x128px Sample icons are in sources folder', 'textdomain'),
		),
		
		'sname' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Sub Name', 'textdomain'),
			'desc' => __('(Optional)Please write tile name. ( If you write sub tile name please do not write icon name it will not shown.) ', 'textdomain'),
		),
		
		'simage' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Sub Icon', 'textdomain'),
			'desc' => __('(Optional)Please paste your icon name. You can find all names in <a href="http://fortawesome.github.com/Font-Awesome/" target="_blank">FontAwesome Site</a>(If you leave blank tile sub text will be written)', 'textdomain'),
		),
		
		'scolor' => array(
			'type' => 'select',
			'label' => __('Sub Name / Icon BG', 'textdomain'),
			'desc' => __('Select a color please.', 'textdomain'),
			'options' => array(
				'' => 'Transparent',
				'TLightRed' => 'LightRed',
				'TRed' => 'Red',
				'TBrown' => 'Brown',
				'TLightOrange' => 'Light Orange',
				'TOrange' => 'Orange',
				'TLightPurple' => 'Light Purple',
				'TDarkPurple' => 'Dark Purple',
				'TLightBlue' => 'Light Blue',
				'TBlue' => 'Blue',
				'TDarkBlue' => 'Dark Blue',
				'TFacebookBlue' => 'Facebook Blue',
				'TTwitterBlue' => 'Twitter Blue',
				'TThumblrBlue' => 'Thumblr Blue',
				'TLinkedinBlue' => 'Linkedin Blue',
				'TDribbblePink' => 'Dribbble Pink',
				'TTurquise' => 'Turquise',
				'TLightGrey' => 'Light Grey',
				'TGrey' => 'Grey',
				'TDarkGrey' => 'Dark Grey',
				'TLightGreen' => 'Light Green',
				'TGreen' => 'Green',
				'TDarkGreen' => 'Dark Green',
				'TBlack' => 'Black',
				'TWhite' => 'White'
			)
		),
		'hdesk' => array(
			'type' => 'select',
			'label' => __('Hidden Desktop', 'textdomain'),
			'desc' => __('If you not want to show on desktop select yes.', 'textdomain'),
			'options' => array(
				'0' => 'No',
				'1' => 'Yes'
			)
		),

	),
	'shortcode' => '[webbu_icontile size="{{size}}" ccolor="{{ccolor}}" hdesk="{{hdesk}}" url="{{url}}" pi="{{pageid}}" color="{{color}}" sname="{{sname}}" sicon="{{simage}}" scolor="{{scolor}}" imgicon="{{iurl2}}"]{{iurl}}[/webbu_icontile]',
	'popup_title' => __('Insert Tile Icon Shortcode', 'textdomain')
);


/*-----------------------------------------------------------------------------------*/
/*	Webbu Slider Tile
/*-----------------------------------------------------------------------------------*/

$webbu_shortcodes['tileslider'] = array(
    'params' => array(
		'size' => array(
			'type' => 'select',
			'label' => __('Tile Size', 'textdomain'),
			'desc' => __('Select a tile type', 'textdomain'),
			'options' => array(
				'' => 'Box (Standart Square)',
				't2x' => 'Double Box Horizontal',
				't2x-v' => 'Double Box Vertical',
				't3x' => 'Triple Box Horizontal',
				't3x-v' => 'Triple Box Vertical',
				't4x' => 'Quadro Box Horizontal',
				't4x-v' => 'Quadro Box Vertical',
				't2x-b' => 'Double Horizontal / Double Vertical Box',
				't3x-b' => 'Triple Horizontal / Triple Vertical Box',
				't4x-b' => 'Quadro Horizontal / Quadro Vertical Box',
				't3x-t2x-b' => 'Triple Horizontal / Double Vertical Box',
				't4x-t2x-b' => 'Quadro Vertical / Double Horizontal Box',
				't4x-t2x22-b' => 'Quadro Horizontal / Double Vertical Box',
				't4x-t1x-b' => 'Quadro Horizontal / Single Vertical Box'
			)
		),
		'url' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Tile Link URL', 'textdomain'),
			'desc' => __('Please write tile click link url. Like http://www...(Optional)', 'textdomain'),
		),
		'pageid' => array(
			'type' => 'select2',
			'label' => __('Tile Link Page', 'textdomain'),
			'desc' => __('Select page link please. ( If write URL Link Empty )', 'textdomain')
			
		),
		
		'tp' => array(
			'std' => '1500',
			'type' => 'text',
			'label' => __('Trans Period', 'textdomain'),
			'desc' => __('Please write lenght of the sliding effect in milliseconds', 'textdomain'),
		),
		
		'st' => array(
			'std' => '6000',
			'type' => 'text',
			'label' => __('Status Time', 'textdomain'),
			'desc' => __('Please write milliseconds between the end of the sliding effect and the start of the nex one', 'textdomain'),
		),

		
		),
    'no_preview' => true,
    'shortcode' => '[webbu_slidertile size="{{size}}" url="{{url}}" pi="{{pageid}}" st="{{st}}" tp="{{tp}}"]{{child_shortcode}}[/webbu_slidertile]',
    'popup_title' => __('Insert Slider Tile Shortcode', 'textdomain'),
    
    'child_shortcode' => array(
        'params' => array(
            'content' => array(
                'std' => 'Paste Image Url',
                'type' => 'text',
                'label' => __('Image URL', 'textdomain'),
                'desc' => __('Like: http://www...', 'textdomain'),
            )
			
        ),
        'shortcode' => '[webbu_simgtile]{{content}}[/webbu_simgtile]', 
        'clone_button' => __('Add Slider Image', 'textdomain')
    )
);


?>