<?php

function add_p_tags($text) {
  return "<p>" . str_replace("\n", "</p><p>", $text) . "</p>";
}

function remove_html_slashes($content) {
	return filter_var(stripslashes($content), FILTER_SANITIZE_SPECIAL_CHARS);
}

function new_excerpt_length($length) {
	return 30;
}

function new_excerpt_more($more) {
	return '';
}

function remove_objects($content)
{
	$content = preg_replace('/\<div(.*?)\>(.*?)\<\/div\>/s', '', $content);
	$content = preg_replace('/\<object(.*?)\>(.*?)\<\/object\>/s', '', $content);
	$content = preg_replace('/\<iframe(.*?)\>(.*?)\<\/iframe\>/s', '', $content);
	return $content;
}

function remove_images($content)
{
	$content = preg_replace('#(<[/]?a.*><[/]?img.*></a>)#U', '', $content);
	$content = preg_replace('#(<[/]?img.*>)#U', '', $content);
	$content = preg_replace("/\[caption(.*)\](.*)\[\/caption\]/Usi", "", $content);
    return $content;
}

function filter_where( $where = '' ) {
	// posts in the last 30 days
	$where .= " AND post_date > '" . date('Y-m-d', strtotime('-30 days')) . "'";
	return $where;
}

function page_read_more($content) {
	$result = preg_split('/<span id="more-\d+"><\/span>/', $content);
	return $result[0];
}

function blog_read_more($content)
{
     $content = preg_replace('#(<a.* class="more-link">.*</a>)#U', '</p><p class="last"><span>$1</span>', $content);
    return $content;
}

function BigFirstChar ($content = '') {
     return '<p class="caps">' . $content;
}


function remove_shortcode_from_index($content) {
  if ( is_home() ) {
    $content = strip_shortcodes( $content );
  }
  return $content;
}

function big_first_char ($content = '') {
     return '<p class="caps">' . $content;
}

function WordLimiter($text,$limit=15){
    $explode = explode(' ',$text);
    $string  = '';

    $dots = '...';
    if(count($explode) <= $limit){
        $dots = '';
    }
    for($i=0;$i<$limit;$i++){
        $string .= $explode[$i]." ";
    }
    if ($dots) {
        $string = substr($string, 0, strlen($string));
    }

    return $string.$dots;
}

/* -------------------------------------------------------------------------*
 * 				ADDING A CSS CLASS TO EACH LINK OF the_category()			*
 * -------------------------------------------------------------------------*/


function the_category_css_class($output) {
  $list = explode('" title',$output); $output = '';
  $len = count($list)-1; $i=0;
    foreach( $list as $list_item ) { 
    $output .= $list_item;
		if($i < $len) { 
			if($i==0) {
				$output .= '" class="section" title'; 
			} else {
				$output .= '" class="section_2" title'; 
			}
		}
	$i++;
    }
  return $output;
}

/* -------------------------------------------------------------------------*
 * 		ADDING A CSS CLASS TO EACH LINK OF the_author_posts_link()			*
 * -------------------------------------------------------------------------*/

function the_author_posts_link_css_class($output) {

	$output= preg_replace('#(<a(.*)>(.*)</a>)#U', '<a $2 class="author">'.(__('by', THEME_NAME)).' $3</a>', $output);
    return $output;
}


function convert_to_class($name){
	return strtolower( str_replace( array(' ',',','.','"',"'",'/',"\\",'+','=',')','(','*','&','^','%','$','#','@','!','~','`','<','>','?','[',']','{','}','|',':',),'',$name ) );
}




load_theme_textdomain('kernel', TEMPLATEPATH . '/languages');
	$locale = get_locale();
	$locale_file = TEMPLATEPATH . "/languages/$locale.php";
	if ( is_readable( $locale_file ) )
		require_once( $locale_file );

add_filter('excerpt_length', 'new_excerpt_length');
add_filter('excerpt_more', 'new_excerpt_more');
add_filter('the_content', 'remove_shortcode_from_index');
add_filter('the_category','the_category_css_class');
add_filter('the_author_posts_link','the_author_posts_link_css_class');
remove_filter('the_excerpt', 'wpautop');


?>