<?php

$prefix = 'kernel_';
$image = '<img src="'.get_bloginfo('template_url').'/images/control-panel-images/logo-orangethemes-1.png" width="11" height="15" />';


	global $slider_image,$sidebar_select,$sidebar_select_post;

$slider_image = array( 'id' => 'slider-image-box', 'title' => ''.$image.' Slider Image', 'page' => 'post', 'context' => 'side', 'priority' => 'high', 'fields' => array(array('name' => 'Image url', 'id' => $prefix. 'slider_image', 'type'=> 'slider_image_box' ) ) );
$sidebar_select = array( 'id' => 'sidebar-select-box', 'title' => ''.$image.' Sidebar', 'page' => 'page', 'context' => 'normal', 'priority' => 'high', 'fields' => array(array('name' => 'Sidebar name:', 'id' => $prefix. 'sidebar_select', 'type'=> 'sidebar_select_box' ) ) );
$sidebar_select_post = array( 'id' => 'sidebar-select-post', 'title' => ''.$image.' Sidebar', 'page' => 'post', 'context' => 'normal', 'priority' => 'high', 'fields' => array(array('name' => 'Sidebar name:', 'id' => $prefix. 'sidebar_select', 'type'=> 'sidebar_select_box' ) ) );


// Add meta box
function add_sticky_box() {
	
	global $slider_image,$sidebar_select,$sidebar_select_post;
	
	add_meta_box($slider_image['id'], $slider_image['title'], 'slider_image_box', $slider_image['page'], $slider_image['context'], $slider_image['priority']);
	add_meta_box($sidebar_select['id'], $sidebar_select['title'], 'sidebar_select_box', $sidebar_select['page'], $sidebar_select['context'], $sidebar_select['priority']);
	add_meta_box($sidebar_select_post['id'], $sidebar_select_post['title'], 'sidebar_select_post', $sidebar_select_post['page'], $sidebar_select_post['context'], $sidebar_select_post['priority']);

}

function slider_image_box() {
	global $slider_image;
	show_box_funtion($slider_image, 'yes');
}

function sidebar_select_box() {
	global $sidebar_select;
	show_box_funtion($sidebar_select, 'yes', 10);
}

function sidebar_select_post() {
	global $sidebar_select_post;
	show_box_funtion($sidebar_select_post, 'no', 10);
}

// Callback function to show fields in meta box
function show_box_funtion($fields, $first='no', $width='60') {
	global $post;

	if($first=="yes") {
		echo '<input type="hidden" name="sticky_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
	}
	echo '<table class="form-table">';

	foreach ($fields['fields'] as $field) {
		// get current post meta data
		$meta = get_post_meta($post->ID, $field['id'], true);
		$post_num = htmlentities($_GET['post']);
		echo '<tr>','<th style="width:',$width,'%"><label for="', $field['id'], '">', $field['name'], '</label></th>','<td>';
		switch ($field['type']) {
			case 'text_currency':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" ', $meta ? ' ' : '', ' value="', $meta ? remove_html_slashes($meta) : remove_html_slashes($field['std']), '"/> ' .get_option(THEME_NAME.'_currency_category');
				break;
			case 'text_length_unit':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" ', $meta ? ' ' : '', ' value="', $meta ? remove_html_slashes($meta) : remove_html_slashes($field['std']), '"/> ' .get_option(THEME_NAME.'_length_unit');
				break;
			case 'text_displacement_unit':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" ', $meta ? ' ' : '', ' value="', $meta ? remove_html_slashes($meta) : remove_html_slashes($field['std']), '"/> ' .get_option(THEME_NAME.'_displacement_unit');
				break;
			case 'text':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" ', $meta ? ' ' : '', ' value="', $meta ? remove_html_slashes($meta) : remove_html_slashes($field['std']), '"/> ';
				break;
			case 'slider_image_box':
				echo '<input class="upload input-text-1" type="text" name="', $field['id'], '" id="', $field['id'], '" value="',  $meta ? remove_html_slashes($meta) :  remove_html_slashes($field['std']), '" style="width: 140px;"/>
						<div id="', $field['id'], '_button" class="upload-button upload-logo" style="padding: 10px 0 0 15px;"><a class="pex-button"><img src="'.THEME_IMAGE_CPANEL_URL.'btn-browse-1.png"/></a></div>
						<script type="text/javascript">
							jQuery(document).ready(function($){ bordeaux.loadUploader(jQuery("div#', $field['id'], '_button"), "'.THEME_FUNCTIONS_URL.'upload-handler.php", "'.THEME_UPLOADS_URL.'");});
						</script>';
				break;
			case 'checkbox':
				echo '<input type="checkbox" value="1" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />';
				break;
			case 'sidebar_select_box':
				$sidebar_names = get_settings( THEME_NAME."_sidebar_names" );
				$sidebar_names = explode( "|*|", $sidebar_names );

				echo '	<select name="', $field['id'], '" id="', $field['id'], '" style="min-width:200px;">';
				echo "<option value=\"\">Default</option>";
					foreach ($sidebar_names as $sidebar_name) {
	
						if ( $meta == $sidebar_name ) {
							$selected="selected=\"selected\"";
						} else { 
							$selected="";
						}
						
						if ( $sidebar_name != "" ) {
							echo "<option value=\"".$sidebar_name."\" ".$selected.">".$sidebar_name."</option>";
						}
					}
				echo '	</select>';
				break;
			case 'textarea':
				echo '<textarea name="', $field['id'], '" id="', $field['id'], '" ', $meta ? ' ' : '', ' style="width:400px; height:100px;">', $meta ? remove_html_slashes($meta) : remove_html_slashes($field['std']), '</textarea>';
				break;
		}
		echo '<td>', '</tr>';
	}
	echo '</table>';
}

function save_data($fields) {
	global $post_id;
	foreach ($fields['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}//else if closer
	}//foreach closer

}

function save_numbers($fields) { 
	global $post_id;
	foreach ($fields['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		if(!is_numeric($new)) { 
			$new = preg_replace("/[^0-9]/","",$new);
		}
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}//else if closer
	}//foreach closer

}

// Save data from meta box
function save_sticky_data($post_id) {
	global $slider_image,$sidebar_select,$sidebar_select_post;
	
	// verify nonce
	if (!wp_verify_nonce($_POST['sticky_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	}

	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ('page' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}
	
	save_data($slider_image);
	save_data($sidebar_select);
	save_data($sidebar_select_post);

} //function closer

	add_action('admin_menu', 'add_sticky_box');	
	add_action('save_post', 'save_sticky_data');
?>