<?php
/**
 * Author Otange-Themes
 * http://wwww.orange-themes.com
 */

 
 	
/* -------------------------------------------------------------------------*
 * 						SET DEFAULT VALUES BY THEME INSTALL					*
 * -------------------------------------------------------------------------*/
 
 function wp_register_theme_activation_hook($code, $function) {
    $optionKey="theme_is_activated_" . $code;
    if(!get_option($optionKey)) {
        call_user_func($function);
        update_option($optionKey , 1);
    }
}

function wp_register_theme_deactivation_hook($code, $function) {
    $GLOBALS["wp_register_theme_deactivation_hook_function" . $code]=$function;
 
    $fn=create_function('$theme', ' call_user_func($GLOBALS["wp_register_theme_deactivation_hook_function' . $code . '"]); delete_option("theme_is_activated_' . $code. '");');

    add_action("switch_theme", $fn);
}
 function my_theme_activate() {
 
 		global $wpdb;
		$theme_name='kernel';
		
		//settings
		$theme_logo = get_template_directory_uri()."/images/logo-kernel-1.png";
		add_option($theme_name."_logo",$theme_logo);
		add_option($theme_name."_cufon","on");
		add_option($theme_name."_homepage_slider","off");
		add_option($theme_name.'_gallery_style', "style_1");
		add_option($theme_name.'_news_style', "style_1");
		add_option($theme_name."_show_about_author","on");
		add_option($theme_name."_show_about_author","on");
		add_option($theme_name."_rss_url",get_bloginfo("rss_url"));
		add_option($theme_name."_search","on");
  }
  
  wp_register_theme_activation_hook('kernel', 'my_theme_activate');
 
 	
/* -------------------------------------------------------------------------*
 * 								THEME MANAGEMENT							*
 * -------------------------------------------------------------------------*/
 
class OrangeThemesManagment {

	var $options=array();
	var $before_item_title='<td class="label"><span>';
	var $after_item_title='</span>';
	var $before_item='<tr class="item">';
	var $after_item='</tr>';

 
	function OrangeThemesManagment($themename, $themeslug) {
		$this->themename=$themename;
		$this->themeslug=$themeslug;
	}
	
	
	function get_options() {
		return $this->options;
	}

	function add_options($option_arr) {
		foreach($option_arr as $option){
			$this->options[]=$option;
		}
	}

	function print_heading($heading_text) {
		echo '<!-- BEGIN .control-panel-wrapper -->
			<div class="control-panel-wrapper"><form method="post" id="orange-themes-options">';
		if ( function_exists('wp_nonce_field') ){
			wp_nonce_field('orange-theme-update-options','orange-theme-options');
		}
		echo '<!-- BEGIN .header -->
				<div class="header">
					<a href="http://www.orange-themes.com" class="logo" target="blank">&nbsp;</a>
					<p><a href="http://www.themeforest.net/user/orange-themes/portfolio?ref=orange-themes" target="blank"><b>'.$heading_text.'</b></a></p>
				<!-- END .header -->
				</div>
				
				<!-- BEGIN .content -->
				<div class="content">

				<div id="tabs">
					<!-- BEGIN .menu -->
					<div class="menu">
					<ul>';
						$i=0;
						foreach ($this->options as $value) {
							if($value['type']=='navigation'){
								echo '<li style="margin:0;"><a href="#tabs-'.$i.'" class="'.$value['slug'].' config_tab"><span>'.$value['name'].'</span></a></li>';
								$i++;
							}
						}
		echo '</ul>		
			<!-- END .menu -->
			</div>';
					
				
	}
	
	function print_footer() {
		echo '<!-- END .content -->
			
			<!-- END .control-panel-wrapper -->
			</div>
			</div>';
	}
	
	function print_options(){
		$i=0;
		foreach ($this->options as $value) {
			switch ( $value['type'] ) {
				case 'navigation':
					$i++;
				break;
				case 'tab':
					$this->print_tab($value, $i);
				break;
				case 'closetab':
					$this->print_closetab($value, $i);
				break;
				case 'sub_navigation':
					$this->print_subnavigation($value, $i);
				break;
				case 'sub_tab':
					$this->print_subtab($value, $i);
				break;
				case 'closesubtab':
					$this->print_closesubtab($value, $i);
				break;
				case 'homepage_set_test':
					$this->print_homepagesettest($value);
				break;
				case 'upload':
					$this->print_upload($value);
				break;
				case 'title':
					$this->print_title($value);
				break;
				case 'input':
					$this->print_input($value);
				break;
				case 'checkbox':
					$this->print_checkbox($value);
				break;
				case 'checkboxes':
					$this->print_checkboxes($value);
				break;
				case 'select':
					$this->print_select($value);
				break;
				case 'save':
					$this->print_save($value);
				break;
				case 'close':
					$this->print_close();
				break;
				case 'textarea':
					$this->print_textarea($value);
				break;
				case 'pages':
					$this->print_pages($value);
				break;
				case 'categories':
					$this->print_categories($value);
				break;
				case 'radio':
					$this->print_radio($value);
				break;
				case 'slide_order':
					$this->print_slide_order($value);
				break;
				case 'sidebar_order':
					$this->print_sidebar_order($value);
				break;
				case 'text':
					$this->print_text($value);
				break;
				case 'add_text':
					$this->print_add_text($value);
				break;
				case 'sidebar':
					$this->print_sidebar($value);
				break;
			}
		}
	}
	
	function print_tab($value, $i){
		echo '<div id="tabs-'.($i-1).'" >
			<!-- BEGIN .settings -->
			<div class="settings">';
	}	

	
	/**
	*	Prints a text.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "text",
	*		"text" => "Your text comes here",
	*	)
	*/
	function print_text($value){
		echo '<div id="theme_documentation" style="min-height:300px;">
		<div style="margin-left:33px; margin-right:25px;">
		'.$value['text'].'	
		</div>								
		</div>';
	}
	
	/**
	*	Prints a sub navigation.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "sub_navigation",
	*		"subname"=>array(
	*			array("slug"=>"documentation", "name"=>"Documentation")
	*		)
	*	)
	*/
	function print_subnavigation($value, $i){
		if($value['subname']){
			echo '<div class="sub_tabs">';
			echo '<div class="tabs"><ul>';
			foreach($value['subname'] as $subname){
				echo '<li><a href="#sub_tabs-'.($i-1).'-'.$subname['slug'].'" class="config_stab" ><span>'.$subname['name'].'</span></a></li>';
			}
			echo '</ul></div>';
	 	}
	}
	
	function print_subtab($value, $i){
		echo '<div id="sub_tabs-'.($i-1).'-'.$value['slug'].'">
				<table>';
	}
	
	/**
	*	Check if homepage is set.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "homepage_set_test",
	*		"title" => "Set up Your Homepage and post page!",
	*		"desc" => "	<p><b>You have not selected the correct template page for homepage.</b></p>
	*		<p>Please make sure, you choose template \"Homepage\".</p>
	*		<br/>
	*		<ul>
	*			<li>Current front page: <a href='".get_permalink(get_option('page_on_front'))."'>".get_the_title(get_option('page_on_front'))."</a></li>
	*			<li>Current blog page: <a href'".get_permalink(get_option('page_for_posts'))."'>".get_the_title(get_option('page_for_posts'))."</a></li>
	*		</ul>",
	*		"desc_2" => "<p><b>You have NOT enabled homepage.</b></p>
	*		<p>To use custom homepage, you must first create two <a href='".home_url()."/wp-admin/post-new.php?post_type=page'>new pages</a>, and one of them assign to \"<b>Homepage</b>\" template.Give each page a title, but avoid adding any text.</p>
	*		<p>Then enable homepage  in <a href='".home_url()."/wp-admin/options-reading.php'>wordpress reading settings</a> (See \"Front page displays\" option). Select your previously created pages from both dropdowns and save changes.</p>"
	*	)
	*/
	function print_homepagesettest($value){
		echo $this->before_item.
			'<td colspan="2">
					<div>
						<p class="label-wide"><b>'.$value['title'].'</b></p>
					</div>
					<div>';
						$homepage = get_option('show_on_front');
						$meta = get_post_custom_values("_wp_page_template",get_option( 'page_on_front'));
						
						if($homepage == "page" && $meta[0] == "template-homepage.php") { global $has_homepage; $has_homepage=true; } else { $has_homepage=false; }
						
						if($has_homepage) {
							echo '<ul style="margin:0 0 0 33px;">
										<li>Front page: <a href="'.get_permalink(get_option("page_on_front")).'">'.get_the_title(get_option("page_on_front")).'</a></li>
										<li>Blog page: <a href="'.get_permalink(get_option("page_for_posts")).'">'.get_the_title(get_option("page_for_posts")).'</a></li>
								</ul>';						
						} elseif ($homepage == "page") {
							echo '<div class="element">
									<div class="content">
										<div class="text">
											'.$value['desc'].'
										</div>
									</div>
								</div>';
						} else {
							echo '<div class="element">
									<div class="content">
										<div class="text">
											'.$value['desc_2'].'								
										</div>
									</div>
								</div>';
						}
						echo '</div>
							</td>
						'
						.$this->after_item;
	}
	
	/**
	*	Prints a upload field.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "upload",
	*		"title" => "Add logo image",
	*		"info" => "Suggested image size is 166x28px",
	*		"id" => $orange_themes_managment->themeslug."_logo"
	*	)
	*/
	function print_upload($value) {
		if ( isset ( $value['protected'][0]["id"] ) || isset ( $value['std'] ) ) {
			$protected_value = $this->get_field_value( $value['protected'][0]["id"], $value['std'] );
		}
		
		if ( isset ( $value['protected'][1]["id"] ) || isset ( $value['std'] ) ) {
			$protected_value_1 = $this->get_field_value( $value['protected'][1]["id"], $value['std'] );
		}
		
		if ( isset ( $value['id'] ) || isset ( $value['std'] ) ) {
			$input_value = $this->get_field_value( $value['id'], $value['std'] );
		}
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {

			echo $this->before_item.$this->before_item_title.$value['title'].$this->after_item_title;
			if ($value['info']) {
				echo orange_themes_info_message($value['info']);
			}	
			echo'</td>
				<td class="setting">
				<input class="upload input-text-2" type="text" name="'.$value['id'].'" id="'.$value['id'].'" value="'.$input_value.'" />
					<div id="'.$value['id'].'_button" class="upload-button upload-logo" style="padding: 10px 0 0 15px;"><a><img src="'.THEME_IMAGE_CPANEL_URL.'browse-1.png"/></a></div>
					<script type="text/javascript">
						jQuery(document).ready(function($){ bordeaux.loadUploader(jQuery("div#'.$value['id'].'_button"), "'.THEME_FUNCTIONS_URL.'upload-handler.php", "'.THEME_UPLOADS_URL.'");});
					</script>
				</td>'
				.$this->after_item;
		}
	}		
	
	/**
	*	Prints a input field.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "input",
	*		"title" => "Twitter Account Url:",
	*		"id" => $orange_themes_managment->themeslug."_twitter",
	*		//if needed you can set a protection	
	*		"protected" => array(
	*			array("id" => $orange_themes_managment->themeslug."_social_footer", "value" => "on")
	*		)
	*	)
	*/
	function print_input($value) {
		$protected_value = $this->get_field_value($value['protected'][0]["id"], "");
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], "");
		$input_value = $this->get_field_value($value['id'], $value['std']);
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			echo $this->before_item.$this->before_item_title.$value['title'].'</span>
					<td class="setting">
						<span class="input-text-1"><input type="text" name="'.$value['id'].'" value="'.$input_value.'" style="width: 261px;" /></span>
					</td>'
			.$this->after_item;
		}
	}	
	
	/**
	*	Prints a input field.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "add_text",
	*		"title" => "Twitter Account Url:",
	*		"id" => $orange_themes_managment->themeslug."_twitter",
	*		//if needed you can set a protection	
	*		"protected" => array(
	*			array("id" => $orange_themes_managment->themeslug."_social_footer", "value" => "on")
	*		)
	*	)
	*/
	function print_add_text($value) {
		$protected_value = $this->get_field_value($value['protected'][0]["id"], "");
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], "");
		$input_value = $this->get_field_value($value['id'], $value['std']);
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			echo $this->before_item.$this->before_item_title.$value['title'].'</span>
					<td class="setting">
						<span class="input-text-1"><input type="text" name="'.$value['id'].'" style="width: 261px;" /></span>
					</td>'
			.$this->after_item;
		}
		$saved_value = get_option( $value['id'].'s' );
		$saved_value = stripslashes($saved_value);

		echo '<input type="hidden" name="'.$value['id'].'s" id="'.$value['id'].'s" value="'.$saved_value.'" /></div>';
		
	}
	
	/**
	*	Prints a input field.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "sidebar",
	*		"title" => "Twitter Account Url:",
	*		"id" => $orange_themes_managment->themeslug."_twitter",
	*		//if needed you can set a protection	
	*		"protected" => array(
	*			array("id" => $orange_themes_managment->themeslug."_social_footer", "value" => "on")
	*		)
	*	)
	*/
	function print_sidebar($value) {
		$protected_value = $this->get_field_value($value['protected'][0]["id"], "");
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], "");
		$input_value = $this->get_field_value($value['id'], $value['std']);
	
		$saved_value=get_option( $value['id'].'s' );
		$saved_value=stripslashes($saved_value);
		$saved_value=explode('|*|', $saved_value);
		
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			echo $this->before_item.$this->before_item_title.$value['title'].'</span>
					<td class="setting">';
					foreach ( $saved_value as $sidebar_name) {
						echo $sidebar_name."<br/>";
					}
					echo '</td>'
			.$this->after_item;
		}

	}
	/**
	*	Prints a checkbox.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "checkbox",
	*		"title" => "Show Social Networks Icons In Header",
	*		"id" => $orange_themes_managment->themeslug."_social_header",
	*		//if needed you can set a protection	
	*		"protected" => array(
	*			array("id" => $orange_themes_managment->themeslug."_social_footer", "value" => "on")
	*		),
	*		
	*	)
	*/
	function print_checkbox($value) {
		$protected_value = $this->get_field_value($value['protected'][0]["id"], $value['std']);
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], $value['std']);
		$input_value = $this->get_field_value($value['id'], $value['std']);
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			if($input_value == "on") {
				$checked='checked="yes"'; 
			} else { 
				$checked=''; 
			}
			echo $this->before_item.$this->before_item_title.$value['title'].$this->after_item_title;
			if ($value['info']) {
				echo orange_themes_info_message($value['info']);
			}	
			echo'</td>
					<td class="setting">
						<input type="checkbox" name="'.$value['id'].'" id="'.$value['id'].'" class="styled" value="on" '.$checked.'/>
					</td>'
			.$this->after_item;
		}		
	}		
	
	/**
	*	Prints checkboxes.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "checkboxes",
	*		"title" => "Unit Settings",
	*		"checkboxes" => array(
	*			array("title"=>"Show thumbnails in blog post list:", "id"=>$orange_themes_managment->themeslug."_show_first_thumb"),
	*			array("title"=>"Show thumbnail in open post", "id"=>$orange_themes_managment->themeslug."_show_single_thumb"),
	*			array("title"=>"Show \"no image\" thumbnail, when no thumbnail is available:", "id"=>$orange_themes_managment->themeslug."_show_no_image_thumb")
	*		)
	*	)
	*/
	function print_checkboxes($value) {
		$protected_value = $this->get_field_value($value['protected'][0]["id"], $value['std']);
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], $value['std']);
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			
			echo $this->before_item.
				'<td colspan="2">
					<div>
						<p class="label"><b>'.$value['title'].'</b></p>
					</div>';
			
			foreach($value["checkboxes"] as $checkbox) {
			
				$input_value = $this->get_field_value($checkbox['id'], $value['std']);

				if($input_value == "on") {
					$checked='checked="yes"'; 
				} else { 
					$checked=''; 
				}
					echo '<div>
						<p class="label"><span>'.$checkbox["title"].'</span></p>
						<div class="setting">
							<input type="checkbox" name="'.$checkbox["id"].'" class="styled" value="on" '.$checked.' />
						</div>
					</div>';
			
			}

			echo'</td>'
			.$this->after_item;
		}		
	}		
	
	/**
	*	Prints a select box.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "select",
	*		"title" => "Blog List Style",
	*		"id" => $orange_themes_managment->$orange_themes_managment->themeslug."_news_style",
	*		"options"=>array(
	*			array("slug"=>"style_1", "name"=>"Style 1 (News and posts with big images)"), 
	*			array("slug"=>"style_2", "name"=>"Style 2 (News and posts with small images)"),
	*			),
	*		"std" => "style_1"
	*	)
	*/
	function print_select($value) {
		$input_value = $this->get_field_value($value['id'], $value['std']);
		
		echo $this->before_item.$this->before_item_title.$value['title'].$this->after_item_title;
		
		if ($value['info']) {
			echo orange_themes_info_message($value['info']);
		}	
		
		echo'<td class="setting">
				<select name="'.$value['id'].'" class="styled">';
				foreach($value['options'] as $options) {
					if($input_value == $options['slug']) { $selected='selected="selected"'; } else { $selected=''; }
					echo '<option value="'.$options['slug'].'" '.$selected.'>'.$options['name'].'</option>';
				}
		echo '</select>
			</td>'
			.$this->after_item;
	}
	
	/**
	*	Prints a textarea.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "textarea",
	*		"title" => "Homepage text block",
	*		"sub_title" => "Text:",
	*		"id" => $orange_themes_managment->themeslug."_homepage_text_bock_txt",
	*		//if needed you can set a protection
	*		"protected" => array(
	*			array("id" => $orange_themes_managment->themeslug."_homepage_text_blocks_enabled", "value" => "on")
	*		)
	*	),
	*/
	function print_textarea($value) {
		$input_value = $this->get_field_value($value['id'], $value['std']);
		$protected_value = $this->get_field_value($value['protected'][0]["id"], $value['std']);
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], $value['std']);

		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			echo $this->before_item.
				'<td colspan="2">
						<div>
							<p class="label"><b>'.$value['title'].'</b></p>
						</div>
						<div>
							<div class="label"><span>'.$value['sub_title'].'</span>';
							if ($value['info']) {
								echo orange_themes_info_message($value['info']);
							}	
					echo '</div>
							<div class="setting">
								<textarea name="'.$value['id'].'" class="text-area-1">'.$input_value.'</textarea>
							</div>
						</div>												
					</td>'
			.$this->after_item;
		}
	}
	
	/**
	*	Prints pages in a select box.
	*/
	function print_pages($value) {
	
		$protected_value = $this->get_field_value($value['protected'][0]["id"], $value['std']);
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], $value['std']);
		$input_value = $this->get_field_value($value['id'], $value['std']);
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
		
		echo $this->before_item.
			'<td colspan="2">
						<div style="margin-left:33px;">
							<p>'.$value["title"].'<br/><br/></p>
								<select name="'.$value["id"].'" class="styled">
								<option value="">Please select a page</option>';
									$pages = get_pages(); 
									foreach ($pages as $pagg) {
										$option = '<option value="'.$pagg->ID.'"';
										if($pagg->ID == $input_value) { $option .= ' selected="selected" >'; } else { $option .= '>';} 
										$option .= $pagg->post_title;
										$option .= '</option>';
										echo $option;
									}

				echo '</select>
					</div>
				</td>'
			.$this->after_item;
		}
		
	}	
	
	/**
	*	Prints categories in a select box.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "categories",
	*		"title" => "Set \"Latest News Block - 7 Posts\" Category",
	*		"id" => $orange_themes_managment->themeslug."_homepage_news_big_cat",
	*		"protected" => array(
	*			array("id" => $orange_themes_managment->themeslug."_homepage_news_big", "value" => "on")
	*		)
	*	)
	*/	
	function print_categories($value) {
	
		$protected_value = $this->get_field_value($value['protected'][0]["id"], $value['std']);
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], $value['std']);
		$input_value = $this->get_field_value($value['id'], $value['std']);
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
		
		echo $this->before_item.
			'<td colspan="2">
					<p class="label"><span>'.$value["title"].'</span></p>
					<div class="setting">';
				
					global $wpdb;

					$table = $wpdb->prefix."term_taxonomy";
					$table2 = $wpdb->prefix."terms";
					$data = $wpdb->get_results("SELECT tt.term_id, t.name FROM $table as tt, $table2 as t WHERE tt.taxonomy = 'category' AND tt.term_id = t.term_id");
															
					if(count($data) > 0) {
					
						echo '<select name="'.$value["id"].'" class="styled">';
						echo "<option value=\"\">Select a category name</option>";
						foreach($data as $d) {
							if($input_value==$d->term_id) { $selected=' selected'; } else { $selected=''; }
							echo "<option value=\"".$d->term_id."\" ".$selected.">".$d->name."</option>";
						}
			
						echo '</select>';
															
					}
													
		echo '</div>
			</td>'
			.$this->after_item;

		}
		
	}
	
	/**
	*	Prints radio buttons.
	*
	*	EXAMPLE:
	*	-----------------------------------------------------------------
	*	array(
	*		"type" => "radio",
	*		"title" => "Custom Homepage slider",
	*		"id" => $orange_themes_managment->themeslug."_homepage_slider",
	*		"radio" => array(
	*			array("title" => "Enable slider:", "value" => "on"),
	*			array("title" => "Use single image:", "value" => "single"),
	*			array("title" => "Disable slider:", "value" => "off")
	*		),
	*		"std" => "off"
	*	)
	*/
	function print_radio($value) {
		$protected_value = $this->get_field_value($value['protected']["id"], $value['std']);
		
		if(((isset($value['protected']["id"]) && $value['protected']["id"]!="") && $protected_value==$value['protected']["value"]) || (!isset($value['protected']["id"]))) {

			echo $this->before_item.
				'<td colspan="2">
					<div>
						<p class="label"><b>'.$value['title'].'</b></p>
					</div>';
			$n=0;
			foreach($value["radio"] as $radio) {
				$n++;
				$input_value = $this->get_field_value($value['id'], $value['std']);

				if($input_value == $radio["value"]) {
					$checked='checked="yes"'; 
				} else { 
					$checked=''; 
				}
					echo '<div>
						<p class="label"><span>'.$radio["title"].'</span></p>
						<div class="setting">
							<input type="radio" name="'.$value["id"].'" id="'.$value["id"].'_'.$n.'" class="styled" value="'.$radio["value"].'" '.$checked.' />
						</div>
					</div>';
			
			}

			echo'</td>'
			.$this->after_item;
		}		
	}
	
	function print_save($value) {
		echo '<tr class="item last">
				<td class="label"></td>
				<td class="setting"><input type="hidden" name="action" value="save" /><p><a href="javascript:{}" onclick="document.getElementById(\'orange-themes-options\').submit(); return false;" class="btn-2"><span>'.$value['title'].'</span></a></p></td>
			</tr>';
	}
	
	function print_title ( $value ) {
		$protected_value = $this->get_field_value($value['protected'][0]["id"], $value['std']);
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], $value['std']);

		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			
			echo '<tr class="item-1">
				<td class="label"><span><b>'.$value["title"].'</b></span>';
				
			if ($value['info']) {
				echo orange_themes_info_message($value['info']);
			}		
			echo '</td>
			</tr>';
	
		}
	}
	
	function print_slide_order ( $value ) {
		$protected_value = $this->get_field_value($value['protected'][0]["id"], $value['std']);
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], $value['std']);
		$input_value = $this->get_field_value($value['id'], $value['std']);
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			
			if ( get_option(THEME_NAME."-slide-order-set") != "1" ) {
				$order = "";
			} else {
				$order = "&orderby=menu_order&order=ASC";
			}
		
					$cat = get_option($value['cat']);
					$count = $value['count'];
					$my_query = new WP_Query("cat=".$cat."&showposts=".$count.$order);
	echo '
			<script type="text/javascript">
				jQuery(document).ready(function(){ 
					jQuery(function() {
						jQuery(".settings ul.slider").sortable({ opacity: 0.6, cursor: \'move\', update: function() {
							var order = jQuery(this).sortable("serialize") + \'&action=update_slider\';
							jQuery.post("'.admin_url("admin-ajax.php").'", order, function(theResponse){
								jQuery("#contentRight").html(theResponse);
							});
						}
						});
					});
				});
			</script> ';
	echo '<tr class="item">
				<td colspan="2">
					<div class="settings">
						<ul class="slider">';
							if ( $my_query->have_posts() ) : while ( $my_query->have_posts() ) : $my_query->the_post();
								global $post; 
								$thePostID = $post->ID;
								$image = get_post_thumb($thePostID,45,45,THEME_NAME."_slider_image"); 
					echo '<li id="recordsArray_'.$post->ID.'">
								<div class="element last">
									<div class="content">
										<div class="image">
											<a href="'.get_permalink().'"><img src="'.$image['src'].'" alt="'.get_the_title().'" width="45" height="45" /></a>
										</div>
										<div class="text">
											<p><b>Title:</b>'.get_the_title().'</p>
											<p><b>Excerpt:</b>'.get_the_excerpt().'</p>
										</div>
									</div>
								</div>
							</li>';
							endwhile; else: 
							endif;			
						echo '</ul>
					</div>
				</td>
			</tr>';
		}
	}
	
	function print_sidebar_order( $value ) {
		$protected_value = $this->get_field_value($value['protected'][0]["id"], $value['std']);
		$protected_value_1 = $this->get_field_value($value['protected'][1]["id"], $value['std']);
		$input_value = $this->get_field_value($value['id'], $value['std']);
		
		if(((isset($value['protected'][0]["id"]) && $value['protected'][0]["id"]!="") && $protected_value==$value['protected'][0]["value"]) && $protected_value_1==$value['protected'][1]["value"] || (!isset($value['protected'][0]["id"]))) {
			
		$saved_value = get_option( $value['id'].'s' );
		$saved_value = explode( "|*|", $saved_value );
		
	echo '
			<script type="text/javascript">
					
				function save_sidebar(id,$title,$old_name) {

					jQuery("#edit-"+id).attr("style","display:inline;");
					jQuery("#save-"+id).attr("style","display:none;");

					jQuery.ajax({
						url:"'.admin_url("admin-ajax.php").'",
						type:"POST",
						data:"action=edit_sidebar&sidebar_name="+$title+"&old_name="+$old_name,
						success:function(results) {
							//alert(results);
							var text = results.slice(0,-1);
							jQuery("#name-"+id).remove(":contains(\'Sidebar Name:\')");
							jQuery("#input-"+id).remove();
							jQuery("#text-"+id).append("<p id=\"name-"+id+"\"><b>Sidebar Name: </b>"+$title+"</p>");
							jQuery("#text-"+id).attr("alt",$title);
							jQuery(".text-"+id).attr("id", "recordsArray_"+$title);
							var text = results.slice(0,-1);
							jQuery("#'.THEME_NAME.'_sidebar_names").val(text);
						}
					});
				}
					
				jQuery(document).ready(function($){
					jQuery(function() {
						jQuery(".settings ul.sidebar").sortable({ opacity: 0.6, cursor: \'move\', update: function() {
							var order = jQuery(this).sortable("serialize") + \'&action=update_sidebar\';
							jQuery.post("'.admin_url("admin-ajax.php").'", order, function(theResponse){
								//jQuery("#contentRight").html(theResponse);
								var text = theResponse.slice(0,-1);
								jQuery("#'.THEME_NAME.'_sidebar_names").val(text);
							});
						}
						});
					});
				});
				
				jQuery(document).ready(function($){
					jQuery(".delete-sidebar").click(function() {
					
						var id = jQuery(this).attr("id").substring(7);
						id = "text-"+id;
						var $title = jQuery("#"+id).attr("alt");
						
						jQuery.ajax({
							url:"'.admin_url("admin-ajax.php").'",
							type:"POST",
							data:"action=delete_sidebar&sidebar_name=" + $title,
							success:function(results) {
								//alert(results);
								//jQuery("#contentRight").html(results);
								var text = results.slice(0,-1);
								jQuery("#'.THEME_NAME.'_sidebar_names").val(text);
								jQuery("."+id).remove();
							}
						});
					});
				});
				
				jQuery(document).ready(function($){
					jQuery(".edit-sidebar").click(function() {
						var id = jQuery(this).attr("id").substring(5);
						var $title = jQuery("#text-"+id).attr("alt");
					
						jQuery("#name-"+id).remove(":contains(\'Sidebar Name:\')");
						jQuery("#edit-"+id).attr("style","display:none;");
						jQuery("#save-"+id).attr("style","display:inline;");

						jQuery("#text-"+id).append("<p id=\"name-"+id+"\"><b>Sidebar Name:</b></p><span class=\"input-text-1\"><input id=\"input-"+id+"\" name=\"sidebar-name\" value=\""+$title+"\" /></span>");

						
						jQuery("#input-"+id).keydown(function (e){
							if(e.keyCode == 13){
							
								var $title = jQuery("#input-"+id).val();
								var $old_name = jQuery("#text-"+id).attr("alt");
								
								save_sidebar(id,$title,$old_name);
								
							}
						})
						
					});
				});			
				
				jQuery(document).ready(function($){
					jQuery(".save-sidebar").click(function() {
						var id = jQuery(this).attr("id").substring(5);
						var $title = jQuery("#input-"+id).val();
						var $old_name = jQuery("#text-"+id).attr("alt");
						
						save_sidebar(id,$title,$old_name);
					});
				});

			</script> ';
	echo '<tr class="item">
				<td colspan="2">
					<div class="settings">
						<ul class="sidebar">';
							$i=0;
							foreach ( $saved_value as $sidebar ) {
								if ( $sidebar != "" ) {
							$i++;
					echo '<li id="recordsArray_'.($sidebar).'" class="text-'.$i.'">
								<div class="element last">
									<div class="content">
										<div id="text-'.$i.'" class="text" alt="'.$sidebar.'">
											<p id="name-'.$i.'"><b>Sidebar Name:</b>'.$sidebar.'</p>
										</div>
										<a href="javascript:{}" class="delete-sidebar" id="delete-'.$i.'"><img src="'.THEME_IMAGE_CPANEL_URL.'btn-cross-1.png" alt="Delete" title="Delete"/></a>
										<a href="javascript:{}" class="edit-sidebar" id="edit-'.$i.'"><img src="'.THEME_IMAGE_CPANEL_URL.'btn-edit-1.png" alt="Edit" title="Edit" id="img-'.$i.'"/></a>
										<a href="javascript:{}" class="save-sidebar" id="save-'.$i.'" style="display:none;"><img src="'.THEME_IMAGE_CPANEL_URL.'btn-check-1.png" alt="Save" title="Save" id="img-'.$i.'"/></a>
									</div>
								</div>
							</li>';
								}	
							}
							if($i==0) echo "<div style=\"padding-left:30px;\">No sidebars added.</div>";
						echo '</ul>
					</div>
					<div id="contentRight"> </div>
				</td>
			</tr>';
		}
	}
	
	function print_closesubtab ( $value, $i ) {
		echo '</table>
			</div>';
	}
	
	function print_closetab ( $value, $i ) {
		echo orange_themes_follow();
		echo '</div>';
		echo '</div>';
		echo '</div>';
	}	
	
	function print_close(){
		echo '</div>';
	}
	
	function get_field_value($id, $std){
		if ( get_option( $id ) != "") { 
			return stripslashes(get_option( $id )); 
		} else { 
			return stripslashes($std); 
		}
	}
	
	
	function print_saved_message(){
		//echo '<div class="note_box" id="saved_box">'.$this->themename.' settings saved.</div>';	
	}
		
}

/* -------------------------------------------------------------------------*
 * 							THEME STYLE AND JS FILES						*
 * -------------------------------------------------------------------------*/

function orange_themes_css() {
	wp_enqueue_script('jquery');
	wp_enqueue_script('jquery-ui');
	wp_enqueue_script("jquery-ui-sortable");
	
	add_editor_style('includes/admin/buttons-formatting/custom-editor-style.css');
	add_editor_style('css/shortcodes.css');
		

	echo '<script src="'.THEME_JS_URL.'admin/options.js" type="text/javascript"></script>';
	echo '<script src="'.THEME_JS_URL.'admin/ajaxupload.js" type="text/javascript"></script>';
	echo '<script src="'.THEME_ADMIN_URL.'jscolor/jscolor.js"  type="text/javascript" /></script>';
		
	if ( $_GET["page"]!="theme-configuration" && $_GET["page"]!="other-themes" ) {
		echo '<link rel="stylesheet" href="'.THEME_ADMIN_URL.'buttons-formatting/custom-editor-style.css" type="text/css" />';
		echo '<link rel="stylesheet" href="'.THEME_CSS_URL.'shortcodes.css" type="text/css" />';
	}
		
	if(isset($_GET["page"]) && $_GET["page"]=="other-themes") {
		echo '<link rel="stylesheet" href="'.THEME_CSS_URL.'more-themes.css" type="text/css" />';
	}
	
	if(isset($_GET["page"]) && $_GET["page"]=="theme-configuration") {
		wp_enqueue_script("jquery-ui-core");
		echo '<script src="'.THEME_JS_URL.'admin/custom-form-elements.js" type="text/javascript"></script>'; 
		echo '<script src="'.THEME_JS_URL.'admin/jquery.cookie.js"></script>';
	
		echo '<script src="'.THEME_JS_URL.'admin/jquery.ui.widget.js"></script>';
		echo '<script src="'.THEME_JS_URL.'admin/jquery.ui.tabs.js"></script>';
		echo '<link rel="stylesheet" href="'.THEME_CSS_URL.'orange-themes-control-panel.css" type="text/css" />';

		echo '
		<script type="text/javascript">
			jQuery(function() {
				jQuery( "#tabs" ).tabs({
					cookie: {
						// store cookie for a day, without, it would be a session cookie
						expires: 1
					}
				});
			});
		</script>
	'; 		
		echo '
		<script type="text/javascript">
			jQuery(function() {
				jQuery( ".sub_tabs" ).tabs({
					cookie: {
						// store cookie for a day, without, it would be a session cookie
						expires: 1
					}
				});
			});
		</script>
	';  		
		echo '
		<script type="text/javascript">
			jQuery(document).ready(function() {
				jQuery(".info").toggle(
				  function () {
				    jQuery(this).siblings(\'.popup-help\').removeClass(\'popup-help-hidden\');
				  },
				  function () {
				    jQuery(this).siblings(\'.popup-help\').addClass(\'popup-help-hidden\');
				  }
				);

			});
			jQuery(document).ready(function() {
				var height = jQuery(\'.popup-help\').height();
				jQuery(\'.popup-help\').css(\'margin-top\',-height/2+9);

			});
			jQuery(document).ready(function() {
				
				jQuery(\'.close\').click(function() {
				jQuery(".popup-help").addClass(\'popup-help-hidden\');
				});
			});
		</script>
	'; 
	echo '<script type="text/javascript">
			addLoadEvent(jscolor.init);
		</script>';

	}


}

add_action('admin_head', 'orange_themes_css');




global $orange_themes_managment;
$orange_themes_managment = new OrangeThemesManagment(THEME_FULL_NAME, THEME_NAME);



//load the files that contain the options
$options_files=array('general', 'sliders', 'sidebar', 'documentation');
foreach($options_files as $file){
	require_once("admin/".$file.'.php');
}


global $options;
$options = $orange_themes_managment->get_options();

function theme_configuration() {
	
	global $themename, $themeslug, $options, $orange_themes_managment;

	if ( isset ( $_REQUEST['saved'] ) && $_REQUEST['saved'] ) {
		$orange_themes_managment->print_saved_message();		
	}
	if ( isset ( $_REQUEST['reset'] ) && $_REQUEST['reset'] ) {
		$orange_themes_managment->print_reset_message();		
	}

	$orange_themes_managment->print_heading("get more from Orange Themes!");
	$orange_themes_managment->print_options();
	$orange_themes_managment->print_footer();
}

add_action('admin_menu', 'theme_menu');

function theme_menu() {

	global $themename, $themeslug, $options;
	
	$nonsavable_types=array('navigation', 'tab','sub_navigation','sub_tab','homepage_set_test','save','closesubtab','closetab');

	//insert the default values if the fields are empty
	foreach ($options as $value) {
		if( isset( $value['id'] ) && get_option($value['id'])=='' && isset($value['std']) && !in_array($value['type'], $nonsavable_types)){
			update_option( $value['id'], $value['std']);
		}
	}

	//save the field's values if the Save action is present
	if ( isset( $_GET['page'] ) && $_GET['page'] == 'theme-configuration' ) {
		if ( isset( $_REQUEST['action'] ) && 'save' == $_REQUEST['action'] ) {
			//verify the nonce
			if ( empty($_POST) || !wp_verify_nonce($_POST['orange-theme-options'],'orange-theme-update-options') )
			{
			   print 'Sorry, your nonce did not verify.';
			   exit;
			}else{
				if(get_option('orange_themes_first_save')==''){
					update_option('orange_themes_first_save', 'saved');
				}
				foreach ($options as $value) {
					if(isset($_REQUEST[$value['id']]) && !in_array($value['type'],$nonsavable_types)) {
						
						if($value['type']=="checkbox" && $_REQUEST[$value['id']]=="on"){
							update_option($value['id'],$_REQUEST[$value['id']]); 
						}
						if($value['type']!="checkbox") {
							update_option($value['id'],$_REQUEST[$value['id']]); 
						}
					} elseif($value['type']=="checkboxes") {
						foreach($value['checkboxes'] as $checkbox) {
							if($_REQUEST[$checkbox['id']]=="on"){
								update_option($checkbox['id'],$_REQUEST[$checkbox['id']]); 
							} else {
								update_option($checkbox['id'], "off"); 
							}
						}
					} elseif($value['type']=="info_block") {
						foreach($value['fields'] as $field) {
								update_option($field['id'], $_REQUEST[$field['id']]); 
						}
					} elseif(!in_array($value['type'], $nonsavable_types)) {
						delete_option( $value['id'] ); 
					}
					
					if($value['type']=='add_text') {
						$old_val = $_REQUEST[ $value['id'].'s' ];
						$old_val = explode( "|*|", $old_val );
						
						if (!in_array($_REQUEST[ $value['id'] ], $old_val)) {
							update_option( $value['id'].'s', $_REQUEST[ $value['id'].'s' ].$_REQUEST[ $value['id'] ]."|*|" ); 
						}
						
					}
				}
				header("Location: admin.php?page=theme-configuration&saved=true");
				die;
			}		
		} 
	}

	add_menu_page(THEME_FULL_NAME.' Management', THEME_FULL_NAME.' Management', 'administrator', 'theme-configuration', 'theme_configuration',get_template_directory_uri().'/images/control-panel-images/logo-orangethemes-1.png');

}

?>