<?php
/*
Template Name: Contact Page
*/	
?>
<?php get_header(); ?>
<?php get_template_part(THEME_INCLUDES.'top'); ?>
	
		<?php
		
			$mail_to = get_option(THEME_NAME."_contact_mail"); 
			if(isset($_POST["phone"])){
				$phone=remove_html_slashes($_POST["phone"]);
			}
			if(isset($_POST["email"])){
				$email=remove_html_slashes($_POST["email"]);
			}
			if(isset($_POST["u_name"])){
				$u_name=remove_html_slashes($_POST["u_name"]);
			}
			if(isset($_POST["message"])){
				$message=remove_html_slashes($_POST["message"]);
			}
			
			$ip = $_SERVER['REMOTE_ADDR'];


			$error="";
			if(isset($_POST["addnew"])){
				$addnew=$_POST["addnew"];
														
				if($addnew)
				{
					$before="<tr><td colspan=\"2\"><div class=\"top-error-message\">";
					$after="</div></td></tr>";
					
					if(!$u_name) $error.=$before.( __( 'Please enter your name!' , THEME_NAME )).$after;
					if(!$email) $error.=$before.( __( 'Please enter your e-mail!' , THEME_NAME )).$after;
					if($email && !preg_match("/@/i", "$email")) $error.=$before.( __( 'Please enter a valid e-mail!' , THEME_NAME )).$after;
					if(!$message) $error.=$before.( __( 'Please enter your message!' , THEME_NAME )).$after;

				}
			}
			
			if((isset($addnew) && !$error))
			{	

				$subject = ( __( 'From' , THEME_NAME ))." ".get_bloginfo('name')." ".( __( 'Contact Page' , THEME_NAME ));
				
				$eol="\n";
				$mime_boundary=md5(time());
				$headers = "From: ".$email." <".$email.">".$eol;
				//$headers .= "Reply-To: ".$email."<".$email.">".$eol;
				$headers .= "Message-ID: <".time()."-".$email.">".$eol;
				$headers .= "X-Mailer: PHP v".phpversion().$eol;
				$headers .= 'MIME-Version: 1.0'.$eol;
				$headers .= "Content-Type: text/html; charset=UTF-8; boundary=\"".$mime_boundary."\"".$eol.$eol;
				


				ob_start(); 
		?>
<?php printf ( __( 'Message:' , THEME_NAME ));?> <?php echo $message;?>
<div style="padding-top:100px;">
<?php printf ( __( 'Name:' , THEME_NAME ));?> <?php echo $u_name;?><br/>
<?php printf ( __( 'Phone:' , THEME_NAME ));?> <?php echo $phone;?><br/>
<?php printf ( __( 'E-mail:' , THEME_NAME ));?> <?php echo $email;?><br/>
<?php printf ( __( 'IP Address:' , THEME_NAME ));?> <?php echo $ip;?><br/>
</div>
		<?php
				$message = ob_get_clean();
				wp_mail($mail_to,$subject,$message,$headers);
			}
			
		?>
		
<script language = "Javascript">
		
	function Validate() 
	{

		var errors = "";
		var reason_name = "";
		var reason_mail = "";
		var reason_message = "";


		reason_name += validateName(document.getElementById('contact-form').u_name);
		reason_mail += validateEmail(document.getElementById('contact-form').email);
		reason_message += validateMessage(document.getElementById('contact-form').message);



		if (reason_name != "") 
		{
			jQuery("#name_error").text(reason_name).fadeIn(1000);
			jQuery("#name_input").addClass("input-error-1");
			document.getElementById('name_error').style.display = 'block';
			errors = "Error";
		}
		else{
			jQuery("#name_input").removeClass("input-text-1-error");
			document.getElementById('name_error').style.display = 'none';
		}


		if (reason_mail != "") 
		{
			jQuery("#mail_error").text(reason_mail).fadeIn(1000);
			jQuery("#mail_input").addClass("input-error-1");
			document.getElementById('mail_error').style.display = 'block';
			errors = "Error";
		}
		else{
			jQuery("#mail_input").removeClass("input-text-1-error");
			document.getElementById('mail_error').style.display = 'none';
		}
		
		if (reason_message != "") 
		{
			jQuery("#message_error").text(reason_message).fadeIn(1000);
			jQuery("#message_input").addClass("input-error-1");
			document.getElementById('message_error').style.display = 'block';
			errors = "Error";
		}
		else{
			jQuery("#message_input").removeClass("input-text-1-error");
			document.getElementById('message_error').style.display = 'none';
		}
		
		if (errors != ""){
			return false;
		}
		
		document.getElementById('contact-form').submit(); return false;
	}
	
		function validateName(fld) 
	{

		var error = "";
		
		if (fld.value == '')
		{
			error = "<?php printf ( __( "You didn't enter Your First Name." , THEME_NAME ));?>\n";
		}
		else if ((fld.value.length < 2) || (fld.value.length > 50))
		{
			error = "<?php printf ( __( "First Name is the wrong length." , THEME_NAME ));?>\n";
		}


		return error;
	}
	
		function validateEmail(fld) 
	{

		var error="";
		var illegalChars = /^[^@]+@[^@.]+\.[^@]*\w\w$/;
		
		if (fld.value == ""){
			error = "<?php printf ( __( "You didn't enter an email address." , THEME_NAME ));?>\n";
		}
		else if ( fld.value.match( illegalChars ) == null){
			error = "<?php printf ( __( "The email address contains illegal characters." , THEME_NAME ));?>\n";
		}


		return error;

	}
	
	function validateMessage(fld) 
	{

		var error = "";
		
		if (fld.value == '')
		{
			error = "<?php printf ( __( "You didn't enter Your message." , THEME_NAME ));?>\n";
		}
		else if (fld.value.length<3)
		{
			error = "<?php printf ( __( "The message is to short." , THEME_NAME ));?>\n";
		}


		return error;
	}

		
	</script>

				<!-- BEGIN .main-column-wrapper -->
				<div class="main-column-wrapper">


					<!-- BEGIN .main-column-left -->
					<div class="main-column-left">


						<!-- BEGIN .post -->
						<div class="post">

							<?php if($mail_to) { ?>
											
								<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
									<div class="post-title">
										<b><?php the_title();?></b>
									</div>

										<?php
											if(!isset($addnew) || $error) {
										?>
										<?php remove_filter('the_content', 'big_first_char', 5); ?>
										<?php the_content(); ?>
										<?php add_filter( 'the_content', 'wpautop' ); ?>

										<form method="post" class="contact-form" id="contact-form" name="contact-form" action="">
											<input type="hidden"  name="addnew" value="yes" />
												<table>	
													<?php echo $error;?>
													<tr>
														<td class="label"><?php printf ( __( 'Name:' , THEME_NAME ));?></td>
														<td>
															<input type="text" name="u_name" value="<?php echo $u_name;?>" class="input-text-1" id="name_input" />
															<div class="input-error-1-label" id="name_error" style="display: none;"></div>

														</td>
													</tr>
													<tr><td class="spacer-1" colspan="2"></td></tr>
													<tr>
														<td class="label"><?php printf ( __( 'E-mail:' , THEME_NAME ));?></td>
														<td>
															<input type="text" name="email" value="<?php echo $email;?>" class="input-text-1" id="mail_input"/>
															<div class="input-error-1-label" id="mail_error" style="display: none;"></div>
														</td>
													</tr>
													<tr><td class="spacer-1" colspan="2"></td></tr>
													<tr>
														<td class="label"><?php printf ( __( 'Phone number:' , THEME_NAME ));?></td>
														<td>
															<input type="text" name="phone" value="<?php echo $phone;?>" class="input-text-1"/>
														</td>
													</tr>
													<tr><td class="spacer-1" colspan="2"></td></tr>
													<tr>
														<td class="label"><?php printf ( __( 'Comment:' , THEME_NAME ));?></td>
														<td>
															<textarea name="message" id="message_input" class="text-area-1"><?php echo $message;?></textarea>
															<div class="input-error-1-label" id="message_error" style="display: none;"></div>
														</td>
													</tr>
													<tr><td class="spacer-1" colspan="2"></td></tr>
													<tr>
														<td></td>
														<td> 
															<p class="show-all"><a href="javascript:{}" onclick="return Validate(); submitform();" class="btn-1 btn-1-color-default"><span><?php printf ( __( 'Send contact form' , THEME_NAME ));?></span></a></p>
														</td>
													</tr>
												</table>
										</form>
									<?php } ?>	
									
									<?php if(isset($addnew) && !$error) { ?>
										<div class="success">
											<p><span><?php printf ( __( 'Thanks!' , THEME_NAME ));?></span></p>
											<p><?php printf ( __( 'Your message has been sent!' , THEME_NAME ));?></p>
										</div>
									<?php } ?>
									
		
								<?php endwhile; else: ?>
									<p><?php printf ( __('Sorry, no posts matched your criteria.' , THEME_NAME )); ?></p>
								<?php endif; ?>
								<?php } else { echo "<span style=\"color:#000; font-size:14pt;\">You need to set up Your contact mail!</span>"; } ?>
											

							<!-- END .post -->
							</div>
						</div>
						<?php get_template_part(THEME_INCLUDES."sidebar"); ?>				

			<?php get_footer(); ?>