/**
  * BLOG:CMS - http://blogcms.com
  * Copyright (C) 2003-2004 Radek HULAN
  *
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
  * (see nucleus/documentation/index.html#license for more info)
  *
  * This file contains functions to allow adding items from inside the weblog.
  * Also contains code to avoid submitting form data twice.
  */

function help(url) {
	popup = window.open(url,'helpwindow','status=no,toolbar=yes,scrollbars=yes,resizable=yes,width=500,height=500,top=0,left=0');
	if (popup.focus) popup.focus();
	if (popup.GetAttention) popup.GetAttention();
	return false;
}				

var oldCellColor = "#000";
function focusRow(row) {
	var cells = row.cells;
	if (!cells) return;
	oldCellColor = cells[0].style.backgroundColor;
	for (var i=0;i<cells.length;i++) {
		cells[i].style.backgroundColor='whitesmoke';
	}
}
function blurRow(row) {
	var cells = row.cells;
	if (!cells) return;
	for (var i=0;i<cells.length;i++) {
		cells[i].style.backgroundColor=oldCellColor;
	}
}
function batchSelectAll(what) {
	var i = 0;
	var el;
	while (el = document.getElementById('batch' + i)) {
		el.checked = what?'checked':'';
		i++;
	}
	return false;					
}

// Submit code for XStandard.com editor
// (c) Radek Hulan - www.hulan.cz
function XstandardSubmitEventHandler(){
	var xs = document.getElementsByTagName("object");
	var name;
	for (var i=0; i<xs.length; i++){
		name = xs[i].name.substr(3); 
		try {
			if ( typeof(xs[i].EscapeUnicode) == 'undefined' ) 
				throw "Error"
			else {
				xs[i].EscapeUnicode = false;
				document.getElementById('id'+name).value = xs[i].value;
			}
		}
		catch(er) {
			document.getElementById('id'+name).value = document.getElementById('idtxt-'+name).value;
		}
	}
}
