/**
  * BLOG:CMS - http://blogcms.com
  * Copyright (C) 2003-2004 Radek HULAN
  *
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
  * (see nucleus/documentation/index.html#license for more info)
  *
  * This file contains functions to allow adding items from inside the weblog.
  * Also contains code to avoid submitting form data twice.
  */

var bmAgt = navigator.userAgent.toLowerCase();
var bmIsOpera  = bmAgt.indexOf("opera") != -1;

function initStyles() {
    flipBlock('blockbody');
	if (ele=document.getElementById('switchbuttons')) ele.style.display = 'inline';
}

/**
 * To be called with id='blockbody','blockmore','blockoptions'
 * Hides all other tabs and makes the chosen one visible
 */
function flipBlock(id) {
	showBlock(id);
	if (id != 'blockbody') hideBlock('blockbody');
	if (id != 'blockmore') hideBlock('blockmore');
	if (id != 'blockoptions') hideBlock('blockoptions');
}

/**
 * Hides one element (tab)
 */
function hideBlock(id) {
    var ele;
	if (ele=document.getElementById(id)) {
	   ele.style.zIndex = 1;
    }
	if (ele=document.getElementById('btn_'+ id)) ele.className = 'button_low';
}

/**
 * Makes an element (tab) visible
 */
function showBlock(id) {
	var ele;
	if (ele=document.getElementById(id)) {
	   ele.style.zIndex = 100;
    }
	if (ele=document.getElementById('btn_'+ id)) ele.className = 'button_activ';
}

function help(url) {
	var popup = window.open(url,'helpwindow','status=no,toolbar=yes,scrollbars=yes,resizable=yes,width=500,height=500,top=0,left=0');
	if (popup.focus) popup.focus();
	if (popup.GetAttention) popup.GetAttention();
	return false;
}
