<?php
/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULÃN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

define('_SETTINGS_COOKIEPREFIX','Préfixe pour les cookies');
define('_ARCHIVETYPE_MONTH','mois');
define('_ARCHIVETYPE_DAY','jour');

// subcategories
define('_GROUP_CAT_TITLE','Groupes de Catégories');
define('_EBLOG_SUBCAT_CREATE','Créer un Groupe');
define('_EBLOG_SUBCAT_DESC','Description');
define('_EBLOG_SUBCAT_NAME','Nom du Groupe');
define('_ERROR_DELETESUBCATEGORY1','Impossible d\'effacer un groupe contenant des catégories. Vous devez détruire ou ré-assigner les catégories au préalable !');
define('_ERROR_DELETESUBCATEGORY2','Impossible de détruire le groupe de catgorie par défaut.');
define('_CONFIRMTXT_SUBCATEGORY','Vous souhaitez effacer la sous-catégorie ');
define('_EBLOG_CAT_UPDATE','Mise à jour du groupe de catégorie');

// comments list per weBlog
define('_COMMENTS_BLOG',			'Tous les commentaires du Blog');
define('_NOCOMMENTS_BLOG',			'aucun commentaire n\'a été fait sur les articles de ce Blog');
define('_BLOGLIST_COMMENTS',		'Commentaires');
define('_BLOGLIST_TT_COMMENTS',		'Lister tous les commentaires faits sur les articles de ce Blog');

// account activation
define('_ERROR_NOLOGON_NOACTIVATE',	'Je ne peux envoyer le lien d\'activation. Vous n\'êtes pas autorisé à vous connecter.');
define('_ERROR_ACTIVATE',			'La clé d\'activation n\'existe pas, est invalide, ou a expiré.');
define('_ACTIONLOG_ACTIVATIONLINK', 'Envoi du lien d\'activation');
define('_MSG_ACTIVATION_SENT',		'Un lien d\'activation de votre compte vient de vous être envoyé par courriel.');

// activation link emails
define('_ACTIVATE_REGISTER_MAIL',	"Bonjour <%memberName%>,\n\nVous devez activer votre compte à <%siteName%> (<%siteUrl%>).\nPour ce, il vous suffit de cliquer sur le lien ci-dessous : \n\n\t<%activationUrl%>\n\nVous avez deux jours pour effectuer cette opération. Au delà, le lien d\'activation deviendra invalide.");
define('_ACTIVATE_REGISTER_MAILTITLE',	"Activez votre compte '<%memberName%>'");
define('_ACTIVATE_REGISTER_TITLE',	'Bienvenue <%memberName%>');
define('_ACTIVATE_REGISTER_TEXT',	'Vous y êtes presque. S\'il vous plait, veuillez saisir un mot de passe ci-dessous.');
define('_ACTIVATE_FORGOT_MAIL',		"Bonjour <%memberName%>,\n\nEn utilisant le lien ci-dessous, vous pouvez choisir un nouveau mot de passe pour votre compte sur <%siteName%> (<%siteUrl%>).\n\n\t<%activationUrl%>\n\nVous avez deux jours pour effectuer cette opération. Ensuite, le lien d\'activation deviendra invalide.");
define('_ACTIVATE_FORGOT_MAILTITLE',"Ré-activer votre compte '<%memberName%>'");
define('_ACTIVATE_FORGOT_TITLE',	'Bienvenue <%memberName%>');
define('_ACTIVATE_FORGOT_TEXT',		'Vous pouvez choisir un nouveau mot de passe pour votre compte ci-dessous :');
define('_ACTIVATE_CHANGE_MAIL',		"Bonjour <%memberName%>,\n\nDepuis que votre adresse e-mail a changé, vous avez besoin de ré-activer votre compte sur <%siteName%> (<%siteUrl%>).\nVous pouvez effectuer ceci en suivant ce lien : \n\n\t<%activationUrl%>\n\nVous avez deux jours pour le faire. Au delà, ce lien d\'activation deviendra invalide.");
define('_ACTIVATE_CHANGE_MAILTITLE',"Ré-activer votre compte '<%memberName%>'");
define('_ACTIVATE_CHANGE_TITLE',	'Bienvenue <%memberName%>');
define('_ACTIVATE_CHANGE_TEXT',		'Votre changement d\'adresse a été validé. Merci !');
define('_ACTIVATE_SUCCESS_TITLE',	'Activation Réussie');
define('_ACTIVATE_SUCCESS_TEXT',	'Votre compte a été activé avec succès.');
define('_MEMBERS_SETPWD',			'Changer de Mot de passe');
define('_MEMBERS_SETPWD_BTN',		'Changer de Mot de passe');
define('_QMENU_ACTIVATE',			'Activation de Compte');
define('_QMENU_ACTIVATE_TEXT',		'<p>Après avoir activé votre compte, vous pouvez commencer par l\'utiliser <a href="index.php?action=showlogin">en vous loguant ici</a>.</p>');

define('_PLUGS_BTN_UPDATE',			'Mettre à jour de la souscription à la liste');

// global settings 
define('_SETTINGS_JSTOOLBAR',		'Style de la barre d\'outils Javascript');
define('_SETTINGS_JSTOOLBAR_FULL',	'Barre d\'outils complète (IE)');
define('_SETTINGS_JSTOOLBAR_SIMPLE','Barre d\'outils simple (Non-IE)');
define('_SETTINGS_JSTOOLBAR_NONE',	'Désactiver la barre d\'outils');
define('_SETTINGS_URLMODE_HELP',	'(Info: <a href="documentation/tips.html#searchengines-fancyurls">Comment activer les fancy URLs</a>)');

// extra plugin settings part when editing categories/members/Blogs/...
define('_PLUGINS_EXTRA',			'Paramêtres des Plugins Supplémentaires');

// itemlist info column keys
define('_LIST_ITEM_BLOG',			'Blog:');
define('_LIST_ITEM_CAT',			'cat:');
define('_LIST_ITEM_AUTHOR',			'auteur:');
define('_LIST_ITEM_DATE',			'date:');
define('_LIST_ITEM_TIME',			'heure:');

// indication of registered members in comments list
define('_LIST_COMMENTS_MEMBER', 	'(membre)');

// batch operations
define('_BATCH_WITH_SEL',			'Pour la sélection:');
define('_BATCH_EXEC',				'Exécute');

// quickmenu
define('_QMENU_HOME',				'Accueil');
define('_QMENU_ADD',				'Ajouter un article');
define('_QMENU_ADD_SELECT',			'-- selectionner --');
define('_QMENU_USER_SETTINGS',		'Paramêtres');
define('_QMENU_USER_ITEMS',			'Articles');
define('_QMENU_USER_COMMENTS',		'Commentaires');
define('_QMENU_MANAGE',				'Administration');
define('_QMENU_MANAGE_LOG',			'Historique des actions');
define('_QMENU_MANAGE_SETTINGS',	'Paramêtres Globaux');
define('_QMENU_MANAGE_MEMBERS',		'Membres');
define('_QMENU_MANAGE_NEWBLOG',		'Nouveau Blog');
define('_QMENU_MANAGE_BACKUPS',		'Sauvegardes');
define('_QMENU_MANAGE_PLUGINS',		'Plugins');
define('_QMENU_LAYOUT',				'Maquettes');
define('_QMENU_LAYOUT_SKINS',		'Skins');
define('_QMENU_LAYOUT_TEMPL',		'Templates');
define('_QMENU_LAYOUT_IEXPORT',		'Importer/Exporter');
define('_QMENU_PLUGINS',			'Plugins');

// quickmenu on logon screen
define('_QMENU_INTRO',				'Introduction');
define('_QMENU_INTRO_TEXT',			'<p>Ceci est la page de connexion pour BLOG:CMS, le système de gestion de contenu utilisé pour maintenir cet site web.</p><p>Si vous avez un compte, vous pouvez vous loguer et commencer à poster de nouveaux articles.</p>');

// helppages for plugins
define('_ERROR_PLUGNOHELPFILE',		'Le fichier d\'aide pour ce plugin ne peut pas être trouvé');
define('_PLUGS_HELP_TITLE',			'Page d\'aide pour ce plugin');
define('_LIST_PLUGS_HELP', 			'aide');

// END changed/started after 3.1

// START changed/added after v2.5beta START

// general settings (security)
define('_SETTINGS_EXTAUTH',			'Activer le système externe d\'autentification');
define('_WARNING_EXTAUTH',			'Attention : à activer seulement si besoin.');

// member profile
define('_MEMBERS_BYPASS',			'Utiliser le système externe d\'autentification');

// 'always include in search' Blog setting (yes/no) [in v2.5beta, the 'always' part wasn't clear]
define('_EBLOG_SEARCH',				'<em>Toujours</em> inclure dans la recherche');

// END changed/added after v2.5beta

// START introduced after v2.0 START

// media library
define('_MEDIA_VIEW',				'voir');
define('_MEDIA_VIEW_TT',			'Voir le fichier (ouvrir dans une nouvelle fenêtre)');
define('_MEDIA_FILTER_APPLY',		'Appliquer le Filtre');
define('_MEDIA_FILTER_LABEL',		'Filtre: ');
define('_MEDIA_UPLOAD_TO',			'Transférer le fichier dans...');
define('_MEDIA_UPLOAD_NEW',			'Transférer un nouveau fichier...');
define('_MEDIA_COLLECTION_SELECT',	'Selectionner');
define('_MEDIA_COLLECTION_TT',		'Changer pour cette catégorie');
define('_MEDIA_COLLECTION_LABEL',	'Collection actuelle : ');

// tooltips on toolbar
define('_ADD_ALIGNLEFT_TT',			'Aligner à Gauche');
define('_ADD_ALIGNRIGHT_TT',		'Aligner à Droite');
define('_ADD_ALIGNCENTER_TT',		'Centrer');


// generic upload failure
define('_ERROR_UPLOADFAILED',		'Echec du transfert');

// END introduced after v2.0 END

// START introduced after v1.5 START

// posting to the past/edit timestamps
define('_EBLOG_ALLOWPASTPOSTING',	'Autoriser de poster dans le passé');
define('_ADD_CHANGEDATE',			'Changer l\'horodatage');
define('_BMLET_CHANGEDATE',			'Changer l\'horodatage');

// Skin import/export
define('_OVERVIEW_SKINIMPORT',		'Importer/exporter des Skins...');

// Skin settings
define('_PARSER_INCMODE_NORMAL',	'Normal');
define('_PARSER_INCMODE_SKINDIR',	'Use Skin dir');
define('_SKIN_INCLUDE_MODE',		'Include mode');
define('_SKIN_INCLUDE_PREFIX',		'Include prefix');

// global settings
define('_SETTINGS_BASESKIN',		'Base Skin');
define('_SETTINGS_SKINSURL',		'URL des Skins');
define('_SETTINGS_ACTIONSURL',		'URL complet de la page \'action.php\'');

// category moves (batch)
define('_ERROR_MOVEDEFCATEGORY',	'Impossible de déplacer la catégorie par défaut');
define('_ERROR_MOVETOSELF',			'Impossible de déplacer la catégorie (le Blog de destination est le même que le Blog source)');
define('_MOVECAT_TITLE',			'Selection du Blog où déplacer la catégorie');
define('_MOVECAT_BTN',				'Déplacer la catégorie');

// URLMode setting
define('_SETTINGS_URLMODE',			'Mode d\'URL');
define('_SETTINGS_URLMODE_NORMAL',	'Normal');
define('_SETTINGS_URLMODE_PATHINFO','Fancy');
define('_SETTINGS_URLMODE_NUMERIC', 'Numérique');

// Batch operations
define('_BATCH_NOSELECTION',		'Aucune sélection pour appliquer cette action');
define('_BATCH_ITEMS',				'Opération à réaliser sur les articles');
define('_BATCH_CATEGORIES',			'Opération à réaliser sur les catégories');
define('_BATCH_MEMBERS',			'Opération à réaliser sur les membres');
define('_BATCH_TEAM',				'Opération à réaliser sur les comités de rédaction');
define('_BATCH_COMMENTS',			'Opération à réaliser sur les commentaires');
define('_BATCH_UNKNOWN',			'Opération à réaliser inconnue : ');
define('_BATCH_EXECUTING',			'Exécution');
define('_BATCH_ONCATEGORY',			'sur la catégorie');
define('_BATCH_ONITEM',				'sur l\'article');
define('_BATCH_ONCOMMENT',			'sur le commentaire');
define('_BATCH_ONMEMBER',			'sur le membre');
define('_BATCH_ONTEAM',				'sur le comité de rédaction');
define('_BATCH_SUCCESS',			'succès !');
define('_BATCH_DONE',				'Réalisé !');
define('_BATCH_DELETE_CONFIRM',		'Confirmez la Suppression');
define('_BATCH_DELETE_CONFIRM_BTN',	'Confirmer la Suppression');
define('_BATCH_SELECTALL',			'Selectionner Tout');
define('_BATCH_DESELECTALL',		'Déselectionner Tout');

// batch operations: options in dropdowns
define('_BATCH_ITEM_DELETE',		'Effacer');
define('_BATCH_ITEM_MOVE',			'Déplacer');
define('_BATCH_MEMBER_DELETE',		'Effacer');
define('_BATCH_MEMBER_SET_ADM',		'Donner les droits Administrateur');
define('_BATCH_MEMBER_UNSET_ADM',	'Retirer les droits Administrateurs');
define('_BATCH_TEAM_DELETE',		'Enlever du comité de rédaction');
define('_BATCH_TEAM_SET_ADM',		'Donner les droits Administrateurs');
define('_BATCH_TEAM_UNSET_ADM',		'Retirer les droits Administrateurs');
define('_BATCH_CAT_DELETE',			'Supprimer');
define('_BATCH_CAT_MOVE',			'Déplacer dans un autre Blog');
define('_BATCH_COMMENT_DELETE',		'Supprimer');

// itemlist: Add new item...
define('_ITEMLIST_ADDNEW',			'Ajouter un nouvel Article...');
define('_ADD_PLUGIN_EXTRAS',		'Options d\'un Extra Plugin');

// errors
define('_ERROR_CATCREATEFAIL',		'Impossible de créer une nouvelle catégorie');
define('_ERROR_NUCLEUSVERSIONREQ',	'Ce plugin nécessite une version de BLOG:CMS plus récente: ');

// backlinks
define('_BACK_TO_BLOGSETTINGS',		'Retour au paramétrage du Blog');

// Skin import export
define('_SKINIE_TITLE_IMPORT',		'Importer');
define('_SKINIE_TITLE_EXPORT',		'Exporter');
define('_SKINIE_BTN_IMPORT',		'Importer');
define('_SKINIE_BTN_EXPORT',		'Exporter les Skins/Templates sélectionnés');
define('_SKINIE_LOCAL',				'Importer depuis un fichier local :');
define('_SKINIE_NOCANDIDATES',		'Pas de candidats à importer détecté dans le répertoire des Skins');
define('_SKINIE_FROMURL',			'Importer depuis une URL:');
define('_SKINIE_EXPORT_INTRO',		'Selectionner ci-dessous les Skins et les Templates que vous souhaitez exporter');
define('_SKINIE_EXPORT_SKINS',		'Skins');
define('_SKINIE_EXPORT_TEMPLATES',	'Templates');
define('_SKINIE_EXPORT_EXTRA',		'Infos Supplémentaires');
define('_SKINIE_CONFIRM_OVERWRITE',	'Ecraser les Skins qui existent déjà (voir les désaccords de noms)');
define('_SKINIE_CONFIRM_IMPORT',	'Oui, je veux faire l\'import');
define('_SKINIE_CONFIRM_TITLE',		'A propos de l\'import des Skins et Templates');
define('_SKINIE_INFO_SKINS',		'Skins dans le fichier :');
define('_SKINIE_INFO_TEMPLATES',	'Templates dans le fichier :');
define('_SKINIE_INFO_GENERAL',		'Info :');
define('_SKINIE_INFO_SKINCLASH',	'désaccord de nom du Skin :');
define('_SKINIE_INFO_TEMPLCLASH',	'désaccord de nom du Template :');
define('_SKINIE_INFO_IMPORTEDSKINS','Skins importés:');
define('_SKINIE_INFO_IMPORTEDTEMPLS','Templates importés:');
define('_SKINIE_DONE',				'Import terminé');

define('_AND',						'et');
define('_OR',						'ou');

// empty fields on Template edit
define('_EDITTEMPLATE_EMPTY',		'champ vide (cliquer pour l\'éditer)');

// Skin overview list
define('_LIST_SKINS_INCMODE',		'IncludeMode:');
define('_LIST_SKINS_INCPREFIX',		'IncludePrefix:');
define('_LIST_SKINS_DEFINED',		'Defined parts:');

// backup
define('_BACKUPS_TITLE',			'Sauvegardes / Restaurations');
define('_BACKUP_TITLE',				'Sauvegarde');
define('_BACKUP_INTRO',				'Cliquez sur le bouton ci-dessous pour créer une sauvegarde de la base BLOG:CMS. Vous aurez la possibilité de savegarder les fichiers dans un endroit sûr.');
define('_BACKUP_ZIP_YES',			'Essayer d\'utiliser un algorithme de compression');
define('_BACKUP_ZIP_NO',			'Ne pas compresser');
define('_BACKUP_BTN',				'Créer une sauvegarde');
define('_BACKUP_NOTE',				'<b>Note :</b> Seul le contenu de la base de données est sauvegardé. Les fichiers multimédia et le fichier de configuration cfg.php ne sont <b>PAS</b> inclus dans la sauvegarde.');
define('_RESTORE_TITLE',			'Restauration');
define('_RESTORE_NOTE',				'<b>ATTENTION:</b> Restaurer une sauvegarde <b>ECRASERA</b> la totalité de l\'actuel base BLOG:CMS ! Faites cette opération seulement si vous êtes sûr !	<br />	<b>Note:</b> Faites attention que l\'actuelle version de BLOG:CMS est la même que celle utilisée pour réaliser la sauvegarde que vous souhaitez restaurer ! Sinon, la restauration ne fonctionnera pas !');
define('_RESTORE_INTRO',			'Selectionnez le fichier de sauvegarde ci-dessous (il sera envoyé sur le serveur) et cliquez sur le bouton \'Restaurer depuis un fichier\' pour démarrer.');
define('_RESTORE_IMSURE',			'Oui, je suis sûr !');
define('_RESTORE_BTN',				'Restaurer depuis un fichier');
define('_RESTORE_WARNING',			'(si vous n\'êtes pas sûr de restaurer la bonne sauvegarde, peut-être vaut-il mieux que vous fassiez une sauvegarde avant)');
define('_ERROR_BACKUP_NOTSURE',		'Vous devez cocher la case \'Oui, je suis sûr\'');
define('_RESTORE_COMPLETE',			'Restauration terminée');

// new item notification
define('_NOTIFY_NI_MSG',			'Un nouvel article a été posté :');
define('_NOTIFY_NI_TITLE',			'Nouvel Article !');
define('_NOTIFY_KV_MSG',			'résultat des votes d\'un article :');
define('_NOTIFY_KV_TITLE',			'BLOG:CMS votes :');
define('_NOTIFY_NC_MSG',			'Commentaire sur l\'article :');
define('_NOTIFY_NC_TITLE',			'Contenu de BLOG:CMS :');
define('_NOTIFY_USERID',			'Id de l\'utilisateur :');
define('_NOTIFY_USER',				'Utilisateur :');
define('_NOTIFY_COMMENT',			'Commentaire :');
define('_NOTIFY_VOTE',				'Vote :');
define('_NOTIFY_HOST',				'Hôte :');
define('_NOTIFY_IP',				'IP :');
define('_NOTIFY_MEMBER',			'Membre :');
define('_NOTIFY_TITLE',				'Titre :');
define('_NOTIFY_CONTENTS',			'Contenu :');

// member mail message
define('_MMAIL_MSG',				'Un message vous a été envoyé par');
define('_MMAIL_FROMANON',			'un visiteur anonyme');
define('_MMAIL_FROMNUC',			'Posté depuis un Blog BLOG:CMS par');
define('_MMAIL_TITLE',				'Un message de');
define('_MMAIL_MAIL',				'Message :');

// END introduced after v1.5 END


// START introduced after v1.1 START

// bookmarklet buttons
define('_BMLET_ADD',				'Ajouter un Article');
define('_BMLET_EDIT',				'Editer un Article');
define('_BMLET_DELETE',				'Effacer un Article');
define('_BMLET_BODY',				'Coprs');
define('_BMLET_MORE',				'Extention');
define('_BMLET_OPTIONS',			'Optionnel');
define('_BMLET_PREVIEW',			'Prévisualisation');

// used in bookmarklet
define('_ITEM_UPDATED',				'Article mis à jour');
define('_ITEM_DELETED',				'Article effacé');

// plugins
define('_CONFIRMTXT_PLUGIN',		'Etes vous sûr de vouloir effacer le Plugin nommé');
define('_ERROR_NOSUCHPLUGIN',		'Plugin innexistant');
define('_ERROR_DUPPLUGIN',			'Désolé, mais ce plugin est déjà installé');
define('_ERROR_PLUGFILEERROR',		'Il n\'existe plus de plugin, ou les droits d\'accès sont mal positionnés');
define('_PLUGS_NOCANDIDATES',		'Pas de plugin candidat trouvé');

define('_PLUGS_TITLE_MANAGE',		'Gestion des plugins');
define('_PLUGS_TITLE_INSTALLED',	'Actuellement installés');
define('_PLUGS_TITLE_UPDATE',		'Mise à jour de la liste de sousciption');
define('_PLUGS_TEXT_UPDATE',		'BLOG:CMS maintient un historique des événement de souscription des plugins. Si vous mettez à jour un plugin en remplaéant son fichier, vous devez exécuter cette mise à jour pour être sûr que les informations stockées dans l\'historique sont correctes');
define('_PLUGS_TITLE_NEW',			'Installer un nouveau Plugin');
define('_PLUGS_ADD_TEXT',			'Ci dessous, une liste de tous les fichiers contenus dans le répertoire des plugins, et qui peuvent être des plugins non-installés. Vérifiez afin d\'être <strong>réellement sûr</strong> qu\'il s\'agit d\'un plugin avant de l\'ajouter.');
define('_PLUGS_BTN_INSTALL',		'Installer le Plugin');
define('_BACKTOOVERVIEW',			'Retour à la vue d\'ensemble');

// editlink
define('_TEMPLATE_EDITLINK',		'Lien pour éditer l\'article');

// add left / add right tooltips
define('_ADD_LEFT_TT',				'Ajouter une case à gauche');
define('_ADD_RIGHT_TT',				'Ajouter une case à droite');

// add/edit item: new category (in dropdown box)
define('_ADD_NEWCAT',				'Nouvelle catégorie...');

// new settings
define('_SETTINGS_PLUGINURL',		'URL des plugins');
define('_SETTINGS_MAXUPLOADSIZE',	'Taille max. en upload (octets)');
define('_SETTINGS_NONMEMBERMSGS',	'Autoriser les personnes non-membres à envoyer un message');
define('_SETTINGS_PROTECTMEMNAMES',	'Protéger les noms des membres');

// overview screen
define('_OVERVIEW_PLUGINS',			'Gérer les Plugins...');

// actionlog
define('_ACTIONLOG_NEWMEMBER',		'Enregistrement d\'un nouveau membre :');

// membermail (when not logged in)
define('_MEMBERMAIL_MAIL',			'Votre adresse électronique :');

// file upload
define('_ERROR_DISALLOWEDUPLOAD2',	'Il n\'y a aucun Blog pour lequel vous avez les privilèges Administrateur et qui contiendrait ce membre en temps que rédacteur. C\'est pourquoi vous n\'êtes pas autorisé à transférer des fichiers multimédia dans le répertoire de ce membre.');

// plugin list
define('_LISTS_INFO',				'Information');
define('_LIST_PLUGS_AUTHOR',		'Par :');
define('_LIST_PLUGS_VER',			'Version :');
define('_LIST_PLUGS_SITE',			'Site officiel');
define('_LIST_PLUGS_DESC',			'Description:');
define('_LIST_PLUGS_SUBS',			'Souscrire aux événements suivants :');
define('_LIST_PLUGS_UP',			'Déplacer vers le Haut');
define('_LIST_PLUGS_DOWN',			'Déplacer vers le Bas');
define('_LIST_PLUGS_UNINSTALL',		'Désinstaller');
define('_LIST_PLUGS_ADMIN',			'Administrer');
define('_LIST_PLUGS_OPTIONS',		'Changer les options');

// plugin option list
define('_LISTS_VALUE',				'Valeur');

// plugin options
define('_ERROR_NOPLUGOPTIONS',		'ce plugin n\'a pas besoin d\être paramétré');
define('_PLUGS_BACK',				'Revenir à la page des plugins');
define('_PLUGS_SAVE',				'Sauver les options');
define('_PLUGS_OPTIONS_UPDATED',	'Plugin options updated');

define('_OVERVIEW_MANAGEMENT',		'Administration');
define('_OVERVIEW_MANAGE',			'Administration de BLOG:CMS...');
define('_MANAGE_GENERAL',			'Administration Générale');
define('_MANAGE_SKINS',				'Skin et Templates');
define('_MANAGE_EXTRA',				'Fonctionnalités supplémentaires');

define('_BACKTOMANAGE',				'Retour à l\'Administration de BLOG:CMS');


// END introduced after v1.1 END


// charset to use 
define('_CHARSET',					'utf-8');

// global stuff
define('_LOGOUT',					'Déconnecter');
define('_LOGIN',					'Connecter');
define('_YES',						'Oui');
define('_NO',						'Non');
define('_SUBMIT',					'Soumettre');
define('_ERROR',					'Erreur');
define('_ERRORMSG',					'Une erreur à eu lieu !');
define('_BACK',						'Retour');
define('_NOTLOGGEDIN',				'Non connecté');
define('_LOGGEDINAS',				'Vous êtes connecté en tant que&nbsp;:');
define('_ADMINHOME',				'Page d\'administration');
define('_NAME',						'Nom');
define('_BACKHOME',					'Retour à la page d\'administration');
define('_BADACTION',				'Action demandée innexistante');
define('_MESSAGE',					'Message');
define('_HELP_TT',					'Aide !');
define('_YOURSITE',					'Votre site');


define('_POPUP_CLOSE',				'Fermer la fenêtre');

define('_LOGIN_PLEASE',				'Vous n\'êtes pas connecté');

// commentform
define('_COMMENTFORM_YOUARE',		'Votre login');
define('_COMMENTFORM_SUBMIT',		'Ajouter un commentaire');
define('_COMMENTFORM_COMMENT',		'Votre commentaire');
define('_COMMENTFORM_NAME',			'Nom');
define('_COMMENTFORM_MAIL',			'E-mail/HTTP');
define('_COMMENTFORM_REMEMBER',		'Se rappeler de moi');

// loginform
define('_LOGINFORM_NAME',			'Nom d\'utilisateur');
define('_LOGINFORM_PWD',			'Mot de passe');
define('_LOGINFORM_YOUARE',			'Vous êtes connecté en tant que&nbsp;:');
define('_LOGINFORM_SHARED',			'Ne pas retenir le login');

// member mailform
define('_MEMBERMAIL_SUBMIT',		'Envoyer le message');

// search form
define('_SEARCHFORM_SUBMIT',		'Recherche');

// add item form
define('_ADD_ADDTO',				'Ajouter un article dans');
define('_ADD_CREATENEW',			'Créer un nouvel Article');
define('_ADD_BODY',					'Corps');
define('_ADD_TITLE',				'Titre');
define('_ADD_MORE',					'Extention (optionnel)');
define('_ADD_CATEGORY',				'Catégorie');
define('_ADD_PREVIEW',				'Prévisualisatoin');
define('_ADD_DISABLE_COMMENTS',		'Désactiver les commentaires ?');
define('_ADD_DRAFTNFUTURE',			'Brouillon &amp; Articles futurs');
define('_ADD_ADDITEM',				'Ajouter un article');
define('_ADD_ADDNOW',				'Ajouter maintenant');
define('_ADD_ADDLATER',				'Ajouter plus tard');
define('_ADD_PLACE_ON',				'Publier le');
define('_ADD_ADDDRAFT',				'Ajouter aux brouillons');
define('_ADD_NOPASTDATES',			'(les dates et heures dans le passé NE SONT PAS valides ; dans ce cas, les heures et dates actuelles seront utilisés)');
define('_ADD_BOLD_TT',				'Gras');
define('_ADD_ITALIC_TT',			'Italique');
define('_ADD_HREF_TT',				'Créer un Lien');
define('_ADD_MEDIA_TT',				'Ajouter un fichier multimédia');
define('_ADD_PREVIEW_TT',			'Afficher/Masquer la Prévisualisation');
define('_ADD_CUT_TT',				'Couper');
define('_ADD_COPY_TT',				'Copier');
define('_ADD_PASTE_TT',				'Coller');


// edit item form
define('_EDIT_ITEM',				'Editer l\'article');
define('_EDIT_SUBMIT',				'Editer l\'article');
define('_EDIT_ORIG_AUTHOR',			'Auteur original');
define('_EDIT_BACKTODRAFTS',		'Enregistrer comme brouillon');
define('_EDIT_COMMENTSNOTE',		'(note : désactiver les commentaires ne cachera _PAS_ les commentaires déjà postés)');

// used on delete screens
define('_DELETE_CONFIRM',			'Confirmez la suppression SVP');
define('_DELETE_CONFIRM_BTN',		'Confirmer la suppression');
define('_CONFIRMTXT_ITEM',			'Vous êtes sur le point d\'effacer l\'article :');
define('_CONFIRMTXT_COMMENT',		'Vous êtes sur le point d\'effacer le commentaire suivant :');
define('_CONFIRMTXT_TEAM1',			'Vous êtes sur le point d\'effacer ');
define('_CONFIRMTXT_TEAM2',			' du comité de rédaction du Blog ');
define('_CONFIRMTXT_BLOG',			'Vous êtes sur le point d\'effacer le Blog: ');
define('_WARNINGTXT_BLOGDEL',		'Attention ! Effacer ce Blog effacera TOUS les articles qui s\'y trouvent, et tous les commentaires. Veuillez confirmer SVP que vous êtes vraiment CERTAIN de ce que vous faites !<br />Dans ce cas, n\'arrétez pas  BLOG:CMS durant la suppression de ce glog.');
define('_CONFIRMTXT_MEMBER',		'Vous êtes sur le point d\'effacer le profile du membre suivant : ');
define('_CONFIRMTXT_TEMPLATE',	'Vous êtes sur le point d\'effacer le Template nommé ');
define('_CONFIRMTXT_SKIN',			'Vous êtes sur le point d\'effacer le Skin nommé ');
define('_CONFIRMTXT_BAN',			'Vous êtes sur le point d\'effacer le filtrage de la plage d\'adresses IP');
define('_CONFIRMTXT_CATEGORY',		'Vous êtes sur le point d\'effacer la catégorie ');

// some status messages
define('_DELETED_ITEM',				'Article effacé');
define('_DELETED_MEMBER',			'Membre supprimé');
define('_DELETED_COMMENT',			'Commentaire effacé');
define('_DELETED_BLOG',				'Blog détruit');
define('_DELETED_CATEGORY',			'Catégorie effacée');
define('_ITEM_MOVED',				'Article déplacé');
define('_ITEM_ADDED',				'Article ajouté');
define('_COMMENT_UPDATED',			'Commentaire mis à jour');
define('_SKIN_UPDATED',				'Les données du Skin sont enregistrées');
define('_TEMPLATE_UPDATED',			'Les données du Template sont enregistrées');

// errors
define('_ERROR_COMMENT_LONGWORD',	'Veuillez ne pas utiliser de mot de plus de 90 caractères dans votre commentaire');
define('_ERROR_COMMENT_NOCOMMENT',	'Entrez votre commentaire SVP');
define('_ERROR_COMMENT_NOUSERNAME',	'Nom d\'utilisateur inconnu');
define('_ERROR_COMMENT_TOOLONG',	'Cotre commentaire est trop long (max. 5000 caractères)');
define('_ERROR_COMMENTS_DISABLED',	'Les commentaires pour ce Blog sont désactivés.');
define('_ERROR_COMMENTS_NONPUBLIC',	'Vous devez être autentifié pour pouvoir poster un commentaire dans ce Blog');
define('_ERROR_COMMENTS_MEMBERNICK','Le nom que vous souhaitez utiliser pour poster votre commentaire est déjà utilisé par un membre (personne enregistrée dans le site). Choisissez autre chose.');
define('_ERROR_SKIN',				'Erreur dans le Skin');
define('_ERROR_ITEMCLOSED',			'Cet article est cloturé. Il n\'est plus possible d\'ajouter un commentaire ou de voter pour lui');
define('_ERROR_NOSUCHITEM',			'Article n\'existant pas ou plus');
define('_ERROR_NOSUCHBLOG',			'Blog n\'existant pas ou plus');
define('_ERROR_NOSUCHSKIN',			'Skin n\'existant pas ou plus');
define('_ERROR_NOSUCHMEMBER',		'Membre n\'existant pas ou plus');
define('_ERROR_NOTONTEAM',			'Vous n\'êtes pas dans le comité de rédaction de ce Blog.');
define('_ERROR_BADDESTBLOG',		'Le Blog de destination n\'existe pas');
define('_ERROR_NOTONDESTTEAM',		'Impossible de déplacer cet article : vous n\'est pas membre du comité de rédaction du Blog de destination');
define('_ERROR_NOEMPTYITEMS',		'Ajout d\'article vite impossible !');
define('_ERROR_BADMAILADDRESS',		'L\'adresse électronique n\'est pas valide');
define('_ERROR_BADNOTIFY',			'Une ou plusieurs adresse(s) de notification ne sont pas des adresses valide(s)');
define('_ERROR_BADNAME',			'Le nom n\'est pas valide (seuls les caractères a-z et 0-9 sont autorisés ; pas d\'espace au début ou à la fin)');
define('_ERROR_NICKNAMEINUSE',		'Un autre membre utilise déjà ce surnom');
define('_ERROR_PASSWORDMISMATCH',	'Les mots de passe doivent être identiques');
define('_ERROR_PASSWORDTOOSHORT',	'Le mot de passe doit contenir au moins 6 caractères');
define('_ERROR_PASSWORDMISSING',	'Le mot de passe ne peut être vide');
define('_ERROR_REALNAMEMISSING',	'Vous devez mettre votre nom réel');
define('_ERROR_ATLEASTONEADMIN',	'Il doit y avoir au moins un super administrateur pouvant se connecter dans la page d\'Administration.');
define('_ERROR_ATLEASTONEBLOGADMIN','Effectuer cette action rendre la Blog impossible à maintenir. Verifiez qu\'il existe toujours un administrateur.');
define('_ERROR_ALREADYONTEAM',		'Vous ne pouvez ajouter un utilisateur qui est déjà dans le comité de rédaction');
define('_ERROR_BADSHORTBLOGNAME',	'Le nom court du Blog doit contenir uniquement les caractères a-z et 0-9, sans espace');
define('_ERROR_DUPSHORTBLOGNAME',	'Un autre Blog possède déjà le même nom court. Ce nom doit être unique.');
define('_ERROR_UPDATEFILE',			'Pas d\'accès en écriture sur le fichier à mettre à jour. Vérifiez les permissions sur le fichier (faire un chmod 666). Notez aussi que le chemin d\'accès est relatif au répertoire de la page d\'Administration, c\'est pourquoi vous devez utiliser un chemin absolu (quelque chose comme /votre/chemin/vers/Blogcms/)');
define('_ERROR_DELDEFBLOG',			'Impossible de détruire le Blog par défaut');
define('_ERROR_DELETEMEMBER',		'Ce membre ne peut être supprimé, probablement parce qu\'il est l\'auteur de l\'article ou du commentaire');
define('_ERROR_BADTEMPLATENAME',	'Nom invalide pour le Template, utilisez seulement les caractères a-z et 0-9, sans espace');
define('_ERROR_DUPTEMPLATENAME',	'Un autre Template du même nom existe déjà');
define('_ERROR_BADSKINNAME',		'Nom inutilisable pour le Skin (utilisez seulement les caractères a-z et 0-9, sans espace)');
define('_ERROR_DUPSKINNAME',		'Il existe déjà un Skin avec le même nom');
define('_ERROR_DEFAULTSKIN',		'Il doit toujours exister un Skin appelé "default"');
define('_ERROR_SKINDEFDELETE',		'Ce Skin ne peut être effacé tant qu\'il est le Skin par défaut du Blog : ');
define('_ERROR_DISALLOWED',			'Désolé, vous n\'êtes pas autorisé à réaliser cette action');
define('_ERROR_DELETEBAN',			'Erreur lors de la suppression de filtrage d\'IP (cette plage d\'adresses n\'existe pas)');
define('_ERROR_ADDBAN',				'Erreur pendant l\'ajout de filtrage IP. Celui-ci doit être ajouté correctement dans tous les Blogs.');
define('_ERROR_BADACTION',			'L\'action demandée n\'existe pas');
define('_ERROR_MEMBERMAILDISABLED',	'La messagerie entre membres est désactivée');
define('_ERROR_MEMBERCREATEDISABLED','La création de compte est désactivée');
define('_ERROR_INCORRECTEMAIL',		'Adresse électronique incorrecte');
define('_ERROR_VOTEDBEFORE',		'Vous avez déjà voté pour cet article');
define('_ERROR_BANNED1',			'Action impossible depuis votre poste, la plage d\'adresses IP ');
define('_ERROR_BANNED2',			'dans laquelle vous êtes est bannie. Le message est : \'');
define('_ERROR_BANNED3',			'\'');
define('_ERROR_LOGINNEEDED',		'Vous devez être connecté pour réaliser cette action');
define('_ERROR_CONNECT',			'Erreur de connexion');
define('_ERROR_FILE_TOO_BIG',		'Fichier trop grand !');
define('_ERROR_BADFILETYPE',		'Désolé, ce type de fichier n\'est pas accepté');
define('_ERROR_BADREQUEST',			'Mauvaise requéte de transfert (upload)');
define('_ERROR_DISALLOWEDUPLOAD',	'Vous n\'êtes dans aucun comité de rédaction d\'un Blog. Aussi, vous n\'êtes pas autorisé à déposer un fichier.');
define('_ERROR_BADPERMISSIONS',		'Vous n\'avez pas les permissions pour parcourir un répertoire');
define('_ERROR_UPLOADMOVEP',		'Erreur lors du déplacement d\'un fichier transféré');
define('_ERROR_UPLOADCOPY',			'Erreur durant la copie du fichier transféré');
define('_ERROR_UPLOADDUPLICATE',	'Un autre fichier avec le même nom existe déjà. Essayez de le renommer avant de le transférer.');
define('_ERROR_LOGINDISALLOWED',	'Désolé, vous n\'êtes pas autorisé à vous connecter dans la page d\'Administration. Peut-être faut-il vous connecter avec un autre login');
define('_ERROR_DBCONNECT',			'Echec lors de la connexion au serveur MySQL');
define('_ERROR_DBSELECT',			'Echec lors de la connexion à la base de données de BLOG:CMS.');
define('_ERROR_NOSUCHLANGUAGE',		'Le fichier pour ce langage n\'existe pas');
define('_ERROR_NOSUCHCATEGORY',		'Cette catégorie n\'existe pas');
define('_ERROR_DELETELASTCATEGORY',	'Il doit exister au moins une catégorie');
define('_ERROR_DELETEDEFCATEGORY',	'Vous ne pouvez détruire la catégorie par défaut');
define('_ERROR_BADCATEGORYNAME',	'Mauvais nom de catégorie');
define('_ERROR_DUPCATEGORYNAME',	'Une catégore ayant le même nom existe déjà');

// some warnings (used for mediadir setting)
define('_WARNING_NOTADIR',			'Attention : la valeur courante ne correspond pas à un répertoire !');
define('_WARNING_NOTREADABLE',		'Attention : la valeur courante correspond à un répertoire sans droit de lecture !');
define('_WARNING_NOTWRITABLE',		'Attention : la valeur courante correspond à un répertoire sans droit d\'écriture !');

// media and upload
define('_MEDIA_UPLOADLINK',			'Transférer un nouveau fichier');
define('_MEDIA_MODIFIED',			'modifié');
define('_MEDIA_FILENAME',			'nom de fichier');
define('_MEDIA_DIMENSIONS',			'taille');
define('_MEDIA_INLINE',				'En ligne');
define('_MEDIA_POPUP',				'Popup');
define('_UPLOAD_TITLE',				'Transfert de fichier');
define('_UPLOAD_MSG',				'Indiquez ci-dessous le fichier que vous souhaitez transférer, et cliquez sur le bouton \'Transferer\'.');
define('_UPLOAD_BUTTON',			'Transferer');

// some status messages
//define('_MSG_ACCOUNTCREATED',		'Account created, password will be sent through email');
//define('_MSG_PASSWORDSENT',			'Password has been sent by e-mail.');
define('_MSG_LOGINAGAIN',			'Les informations vous concernant ont changé, vous devez vous connecter à nouveau');
define('_MSG_SETTINGSCHANGED',		'Paramêtres Modifiés');
define('_MSG_ADMINCHANGED',			'Administrateur Changé');
define('_MSG_NEWBLOG',				'Nouveau Blog Créé');
define('_MSG_ACTIONLOGCLEARED',		'Historique des actions nettoyé');

// actionlog in admin area
define('_ACTIONLOG_DISALLOWED',		'Désactiver l\'action : ');
define('_ACTIONLOG_PWDREMINDERSENT','Nouveau mot de passe envoyé à ');
define('_ACTIONLOG_TITLE',			'Historique des actions');
define('_ACTIONLOG_CLEAR_TITLE',	'Nettoyage de l\'historique des actions');
define('_ACTIONLOG_CLEAR_TEXT',		'Nettoyer l\'historique des actions maintenant');

// team management
define('_TEAM_TITLE',				'Administration du comité de rédaction du Blog ');
define('_TEAM_CURRENT',				'Equipe courante');
define('_TEAM_ADDNEW',				'Ajouter un nouveau membre dans le comité de rédaction');
define('_TEAM_CHOOSEMEMBER',		'Choisissez un membre');
define('_TEAM_ADMIN',				'privilèges administrateur ? ');
define('_TEAM_ADD',					'Ajouter au comité de rédaction');
define('_TEAM_ADD_BTN',				'Ajouter au comité de rédaction');

// Blogsettings
define('_EBLOG_TITLE',				'Edition des Propriétés du Blog');
define('_EBLOG_TEAM_TITLE',			'Edition du comité de rédaction');
define('_EBLOG_TEAM_TEXT',			'Cliquer ici pour éditer votre comité de rédaction...');
define('_EBLOG_SETTINGS_TITLE',		'Propriétés du Blog');
define('_EBLOG_NAME',				'Nom du Blog');
define('_EBLOG_SHORTNAME',			'Nom court du Blog');
define('_EBLOG_SHORTNAME_EXTRA',	'<br />(doit contenir seulement a-z sans espace)');
define('_EBLOG_DESC',				'Description du Blog');
define('_EBLOG_URL',				'URL');
define('_EBLOG_DEFSKIN',			'Skin par défaut');
define('_EBLOG_DEFCAT',				'Category par défaut');
define('_EBLOG_LINEBREAKS',			'Convertir les sauts de ligne');
define('_EBLOG_DISABLECOMMENTS',	'Commentaires activés ?<br /><small>(Désactiver les commentaires signifie qu\'il est impossible de poster un nouveau commentaire).</small>');
define('_EBLOG_ANONYMOUS',			'Autoriser les commentaires par une personne non-inscrite ?');
define('_EBLOG_NOTIFY',				'Adresse(s) de notification (utilisez \';\' comme séparateur)');
define('_EBLOG_NOTIFY_ON',			'Notification active');
define('_EBLOG_NOTIFY_COMMENT',		'Nouveaux commentaires');
define('_EBLOG_NOTIFY_KARMA',		'Vouveau vote');
define('_EBLOG_NOTIFY_ITEM',		'Nouveaux articles dans le Blog');
define('_EBLOG_PING',				'Ping WeBlogs.com lors de la mise à jour ?');
define('_EBLOG_MAXCOMMENTS',		'Nombre max de commentaires');
define('_EBLOG_UPDATE',				'Fichier mis à jour');
define('_EBLOG_OFFSET',				'Décalage horaire');
define('_EBLOG_STIME',				'L\'heure sur le serveur est');
define('_EBLOG_BTIME',				'L\'heure du Blog est');
define('_EBLOG_CHANGE',				'Changer les Paramêtres');
define('_EBLOG_CHANGE_BTN',			'Changer les Paramêtres');
define('_EBLOG_ADMIN',				'Administrateur du Blog');
define('_EBLOG_ADMIN_MSG',			'Vous allez avoir des privilèges Administrateur');
define('_EBLOG_CREATE_TITLE',		'Création d\'un nouveau Blog');
define('_EBLOG_CREATE_TEXT',		'Remplissez le formulaire ci-dessous pour créer un nouveau Blog. <br /><br /> <b>Note :</b> Seulement les options indispensables sont listées. Si vous souhaitez changer d\'autres options, entrez dans l\'Administration du Blog une fois ce Blog créé.');
define('_EBLOG_CREATE',				'Créer !');
define('_EBLOG_CREATE_BTN',			'Créer le Blog');
define('_EBLOG_CAT_TITLE',			'Catégories');
define('_EBLOG_CAT_NAME',			'Nom de la Catégorie');
define('_EBLOG_CAT_DESC',			'Description de la catégorie');
define('_EBLOG_CAT_CREATE',			'Créer une Nouvelle Catégorie');
define('_EBLOG_CAT_UPDATE',			'Mise à jour d\'une catégorie');
define('_EBLOG_CAT_UPDATE_BTN',		'Mettre à jour la catégorie');

// Templates
define('_TEMPLATE_TITLE',			'Edition de Templates');
define('_TEMPLATE_AVAILABLE_TITLE',	'Templates disponibles');
define('_TEMPLATE_NEW_TITLE',		'Nouveau Template');
define('_TEMPLATE_NAME',			'Nom du Template');
define('_TEMPLATE_DESC',			'Description du Template');
define('_TEMPLATE_CREATE',			'Créer un Template');
define('_TEMPLATE_CREATE_BTN',		'Créer le Template');
define('_TEMPLATE_EDIT_TITLE',		'Editer le Template');
define('_TEMPLATE_BACK',			'Retour dans la page des Templates');
define('_TEMPLATE_EDIT_MSG',		'Toutes les parties du Template ne sont pas indispensables, laissez libre celles qui ne sont pas imposées.');
define('_TEMPLATE_SETTINGS',		'Propriétés du Template');
define('_TEMPLATE_ITEMS',			'Articles');
define('_TEMPLATE_ITEMHEADER',		'Entête de l\'article');
define('_TEMPLATE_ITEMBODY',		'Corps de l\'article');
define('_TEMPLATE_ITEMFOOTER',		'Pied de page de l\'article');
define('_TEMPLATE_MORELINK',		'Lien vers l\'extension de l\'article');
define('_TEMPLATE_NEW',				'Indication de nouveaux articles');
define('_TEMPLATE_COMMENTS_ANY',	'Commentaire (si présent)');
define('_TEMPLATE_CHEADER',			'Entête du Commentaire');
define('_TEMPLATE_CBODY',			'Corps du Commentaire');
define('_TEMPLATE_CFOOTER',			'Pied de page du Commentaire');
define('_TEMPLATE_CONE',			'Un commentaire');
define('_TEMPLATE_CMANY',			'Au moins deux commentaires');
define('_TEMPLATE_CMORE',			'Lire plus de commentaires');
define('_TEMPLATE_CMEXTRA',			'Membre Supplémentaire');
define('_TEMPLATE_COMMENTS_NONE',	'Commentaire (si aucun)');
define('_TEMPLATE_CNONE',			'Sans commentaire');
define('_TEMPLATE_COMMENTS_TOOMUCH','Commentaire (s\'il y en a, ils sont trop nombreux pour être affichés)');
define('_TEMPLATE_CTOOMUCH',		'Trop de commentaires');
define('_TEMPLATE_ARCHIVELIST',		'Liste d\'Archives');
define('_TEMPLATE_AHEADER',			'Entête de la liste d\'Archives');
define('_TEMPLATE_AITEM',			'Articles Archivés');
define('_TEMPLATE_AFOOTER',			'Pied de page de la liste d\'Archives');
define('_TEMPLATE_DATETIME',		'Date et Heure');
define('_TEMPLATE_DHEADER',			'Entête de la date');
define('_TEMPLATE_DFOOTER',			'Pied de page de la date');
define('_TEMPLATE_DFORMAT',			'Format de la date');
define('_TEMPLATE_TFORMAT',			'Format de l\'heure');
define('_TEMPLATE_LOCALE',			'Locale');
define('_TEMPLATE_IMAGE',			'Image popups');
define('_TEMPLATE_PCODE',			'Popup Link Code');
define('_TEMPLATE_ICODE',			'Inline Image Code');
define('_TEMPLATE_MCODE',			'Media Object Link Code');
define('_TEMPLATE_SEARCH',			'Recherche');
define('_TEMPLATE_SHIGHLIGHT',		'Surligné');
define('_TEMPLATE_SNOTFOUND',		'Aucun résultat trouvé');
define('_TEMPLATE_UPDATE',			'Mise à jour');
define('_TEMPLATE_UPDATE_BTN',		'Mettre à jour le Template');
define('_TEMPLATE_RESET_BTN',		'Remettre à Zéro');
define('_TEMPLATE_CATEGORYLIST',	'Listes de Catégories');
define('_TEMPLATE_CATHEADER',		'Entête de la liste de catégorie');
define('_TEMPLATE_CATITEM',			'Articles de la liste de catégorie');
define('_TEMPLATE_CATFOOTER',		'Pied de page de la liste de catégries');

// Skins
define('_SKIN_EDIT_TITLE',			'Edition des Skins');
define('_SKIN_AVAILABLE_TITLE',		'Skins Disponibles');
define('_SKIN_NEW_TITLE',			'Nouveau Skin');
define('_SKIN_NAME',				'Nom');
define('_SKIN_DESC',				'Description');
define('_SKIN_TYPE',				'Type de Contenu');
define('_SKIN_CREATE',				'Création');
define('_SKIN_CREATE_BTN',			'Créer le Skin');
define('_SKIN_EDITONE_TITLE',		'Edition d\'un Skin');
define('_SKIN_BACK',				'Retour à la page des Skins');
define('_SKIN_PARTS_TITLE',			'Parties de Skin');
define('_SKIN_PARTS_MSG',			'Tous les types ne sont pas nécessaires pour chaque Skin. Laissez libre les champs dont vous n\'avez pas besoin. Choisissez le type de Skin à éditer ci-dessous :');
define('_SKIN_PART_MAIN',			'Index Principal');
define('_SKIN_PART_ITEM',			'Pages d\'articles');
define('_SKIN_PART_ALIST',			'Liste d\'Archives');
define('_SKIN_PART_ARCHIVE',		'Archives');
define('_SKIN_PART_SEARCH',			'Recherche');
define('_SKIN_PART_ERROR',			'Erreurs');
define('_SKIN_PART_MEMBER',			'Details sur les Membres');
define('_SKIN_PART_POPUP',			'Image Popups');
define('_SKIN_GENSETTINGS_TITLE',	'Paramêtres Généraux');
define('_SKIN_CHANGE',				'Changer');
define('_SKIN_CHANGE_BTN',			'Editer le Skin');
define('_SKIN_UPDATE_BTN',			'Mettre à jour du Skin');
define('_SKIN_RESET_BTN',			'Remettre à zéro');
define('_SKIN_EDITPART_TITLE',		'Edition d\'un Skin');
define('_SKIN_GOBACK',				'Retour');
define('_SKIN_ALLOWEDVARS',			'Variables disponibles (cliquer pour info) :');

// global settings
define('_SETTINGS_TITLE',			'Paramêtres Généraux');
define('_SETTINGS_SUB_GENERAL',		'Paramêtres Généraux');
define('_SETTINGS_DEFBLOG',			'Blog par défaut');
define('_SETTINGS_ADMINMAIL',		'Courriel de l\'Administrateur');
define('_SETTINGS_SITENAME',		'Nom du site');
define('_SETTINGS_SITEURL',			'URL du site (doit se terminer par un \'/\')');
define('_SETTINGS_ADMINURL',		'URL of la page d\'Administration (doit se terminer par un \'/\')');
define('_SETTINGS_DIRS',			'Répertoire de base de BLOG:CMS');
define('_SETTINGS_MEDIADIR',		'Répertoire des fichiers multimédia');
define('_SETTINGS_SEECONFIGPHP',	'(Cf. "cfg.php")');
define('_SETTINGS_MEDIAURL',		'URL des fichiers multimédia (doit se terminer par un \'/\')');
define('_SETTINGS_ALLOWUPLOAD',		'Autoriser le transfert (upload) de fichiers ?');
define('_SETTINGS_ALLOWUPLOADTYPES','Types de fichiers autorisés à être transférés');
define('_SETTINGS_CHANGELOGIN',		'Autoriser les membres à changer leur login/mot de passe');
define('_SETTINGS_COOKIES_TITLE',	'Paramêtres liés aux Cookies');
define('_SETTINGS_COOKIELIFE',		'Durée de vie du Cookie de Connexion');
define('_SETTINGS_COOKIESESSION',	'Cookies de Session');
define('_SETTINGS_COOKIEMONTH',		'Durée de vie à un Mois');
define('_SETTINGS_COOKIEPATH',		'Répertorie des Cookies (avancé)');
define('_SETTINGS_COOKIEDOMAIN',	'Domaine pour les Cookies (avancé)');
define('_SETTINGS_COOKIESECURE',	'Cookie Sécurisé (avancé)');
define('_SETTINGS_LASTVISIT',		'Sauvegarder les Cookies de la dernière visite');
define('_SETTINGS_ALLOWCREATE',		'Autoriser les visiteurs à créer un compte utilisateur (compte de membre)');
define('_SETTINGS_NEWLOGIN',		'Connexion autorisée pour les comptes créés par les visiteurs');
define('_SETTINGS_NEWLOGIN2',		'(intéresse uniquement les comptes nouvellement créés)');
define('_SETTINGS_MEMBERMSGS',		'Activer les services inter-membres');
define('_SETTINGS_LANGUAGE',		'Langue par défaut');
define('_SETTINGS_DISABLESITE',		'Désactiver le site');
define('_SETTINGS_DBLOGIN',			'Login MySQL &amp; base de donnée');
define('_SETTINGS_UPDATE',			'Mise à jour des Paramêtres');
define('_SETTINGS_UPDATE_BTN',		'Mettre à jour les Paramêtres');
define('_SETTINGS_DISABLEJS',		'Désactiver la boîte d\'outils JavaScript');
define('_SETTINGS_MEDIA',			'Paramêtres de transferts (upload) de fichiers multimédia');
define('_SETTINGS_MEDIAPREFIX',		'Préfixer les fichiers transférés par la date');
define('_SETTINGS_MEMBERS',			'Paramêtres des Membres');

// bans
define('_BAN_TITLE',				'Bannir ');
define('_BAN_NONE',					'Pas de liste d\'IP bannies pour ce Blog');
define('_BAN_NEW_TITLE',			'Ajout d\'une nouvelle plage d\'adresses IP bannies');
define('_BAN_NEW_TEXT',				'Ajouter une nouvelle plage d\'adresses IP bannies maintenant');
define('_BAN_REMOVE_TITLE',			'Ajout d\'une plage d\'adresses IP bannies');
define('_BAN_IPRANGE',				'Plage d\'adresses IP');
define('_BAN_BLOGS',				'Quels Blogs ?');
define('_BAN_DELETE_TITLE',			'Suppression d\'un filtre sur les adresses IP');
define('_BAN_ALLBLOGS',				'Tous les Blogs pour lesquels vous avez les privilèges Administrateur.');
define('_BAN_REMOVED_TITLE',		'Filtre détruit');
define('_BAN_REMOVED_TEXT',			'Le filtre a été supprimé pour les Blogs :');
define('_BAN_ADD_TITLE',			'Ajouter une nouvelle plage d\'adresses IP bannies');
define('_BAN_IPRANGE_TEXT',			'Indiquez la plage d\'adresses IP que vous souhaitez bloquer. Moins vous idiquez de nombre, plus il y aura d\'adresses bloquées.');
define('_BAN_BLOGS_TEXT',			'Vous pouvez aussi choisir de filtrer des adresses pour un Blog uniquement, ou sur tous les Blogs pour tous ceux pour lesquels vous avez les privilèges. Faites votre choix ci-dessous.');
define('_BAN_REASON_TITLE',			'Raison');
define('_BAN_REASON_TEXT',			'Vous pouvez expliquer pourquoi cette plage d\'adresses IP est bannie ; ce texte sera affiché si une action (vote, commentaire) est tentée depuis une machine concernée par le filtre.');
define('_BAN_ADD_BTN',				'Ajouter le filtre');

// LOGIN screen
define('_LOGIN_MESSAGE',			'Message');
define('_LOGIN_NAME',				'Nom');
define('_LOGIN_PASSWORD',			'Mot de passe');
define('_LOGIN_SHARED',				_LOGINFORM_SHARED);
define('_LOGIN_FORGOT',				'Mot de passe oublié ?');

// membermanagement
define('_MEMBERS_TITLE',			'Gestion des membres');
define('_MEMBERS_CURRENT',			'Membres actuels');
define('_MEMBERS_NEW',				'Nouveau membre');
define('_MEMBERS_DISPLAY',			'Nom d\'utilisateur (login)');
define('_MEMBERS_DISPLAY_INFO',		'(nom utilisé comme login)');
define('_MEMBERS_REALNAME',			'Nom Réel');
define('_MEMBERS_PWD',				'Mot de passe');
define('_MEMBERS_REPPWD',			'Répétez le mot de passe');
define('_MEMBERS_EMAIL',			'Adresse électronique');
define('_MEMBERS_EMAIL_EDIT',		'(quand vous changez votre adresse électronique, un nouveau mot de passe vous sera automatiquement envoyé à la nouvelle adresse)');
define('_MEMBERS_URL',				'Adresse du site Web personnel (URL)');
define('_MEMBERS_SUPERADMIN',		'privilèges Administrateur');
define('_MEMBERS_CANLOGIN',			'Autorisé à accéder à la page d\'administration');
define('_MEMBERS_NOTES',			'Notes');
define('_MEMBERS_NEW_BTN',			'Ajouter le membre');
define('_MEMBERS_EDIT',				'Editer un membre');
define('_MEMBERS_EDIT_BTN',			'Changer les Paramêtres');
define('_MEMBERS_BACKTOOVERVIEW',	'Retour à la page de gestion des membres');
define('_MEMBERS_DEFLANG',			'Langage');
define('_MEMBERS_USESITELANG',		'- utiliser les paramêtres du site -');

// List of Blogs (TT = tooltip)
define('_BLOGLIST_TT_VISIT',		'Site à visiter');
define('_BLOGLIST_ADD',				'Ajouter un Article');
define('_BLOGLIST_TT_ADD',			'Ajouter un nouvel article à ce Blog');
define('_BLOGLIST_EDIT',			'Ajouter/Supprimer des articles');
define('_BLOGLIST_TT_EDIT',			'');
define('_BLOGLIST_BMLET',			'Bookmarklet');
define('_BLOGLIST_TT_BMLET',		'');
define('_BLOGLIST_SETTINGS',		'Paramêtres');
define('_BLOGLIST_TT_SETTINGS',		'Editer les paramêtres ou gérer les comités de rédaction');
define('_BLOGLIST_BANS',			'Filtrage IP');
define('_BLOGLIST_TT_BANS',			'Voir, ajouter, ou supprimer des plages d\'IP bannies');
define('_BLOGLIST_DELETE',			'Effacer Tout');
define('_BLOGLIST_TT_DELETE',		'Détruire ce Blog');

// OVERVIEW screen
define('_OVERVIEW_YRBLOGS',			'Vos Blogs');
define('_OVERVIEW_YRDRAFTS',		'Vos brouillons');
define('_OVERVIEW_YRSETTINGS',		'Vos paramêtres');
define('_OVERVIEW_GSETTINGS',		'Paramêtres Généraux');
define('_OVERVIEW_NOBLOGS',			'Vous n\'êtes pas dans le comité de rédaction d\'un Blog');
define('_OVERVIEW_NODRAFTS',		'Pas de brouillon');
define('_OVERVIEW_EDITSETTINGS',	'Edier vos Paramêtres...');
define('_OVERVIEW_BROWSEITEMS',		'Accéder à vos Articles...');
define('_OVERVIEW_BROWSECOMM',		'Accéder à vos Commentaires...');
define('_OVERVIEW_VIEWLOG',			'Voir l\'historique des actions...');
define('_OVERVIEW_MEMBERS',			'Gérer les membres...');
define('_OVERVIEW_NEWLOG',			'Créer un nouveau Blog...');
define('_OVERVIEW_SETTINGS',		'Editer les Paramêtres...');
define('_OVERVIEW_TEMPLATES',		'Editer les Templates...');
define('_OVERVIEW_SKINS',			'Editer les Skins...');
define('_OVERVIEW_BACKUP',			'Sauvegarde/Restauration...');

// ITEMLIST
define('_ITEMLIST_BLOG',			'Articles pour le Blog');
define('_ITEMLIST_YOUR',			'Vos Articles');

// Comments
define('_COMMENTS',					'Commentaires');
define('_NOCOMMENTS',				'Pas de commentaire pour cet article');
define('_COMMENTS_YOUR',			'Vos commentaires');
define('_NOCOMMENTS_YOUR',			'Vous n\'avez écrit aucun commentaire');

// LISTS (general)
define('_LISTS_NOMORE',				'Pas plus de résultat, ou pas de résultat du tout');
define('_LISTS_PREV',				'Précédent');
define('_LISTS_NEXT',				'Suivant');
define('_LISTS_SEARCH',				'Rechercher');
define('_LISTS_CHANGE',				'Changer');
define('_LISTS_PERPAGE',			'articles/page');
define('_LISTS_ACTIONS',			'Actions');
define('_LISTS_DELETE',				'Effacer');
define('_LISTS_EDIT',				'Editer');
define('_LISTS_MOVE',				'Déplacer');
define('_LISTS_CLONE',				'Dupliquer');
define('_LISTS_TITLE',				'Titre');
define('_LISTS_BLOG',				'Blog');
define('_LISTS_NAME',				'Nom');
define('_LISTS_DESC',				'Description');
define('_LISTS_TIME',				'Heure');
define('_LISTS_COMMENTS',			'Commentaires');
define('_LISTS_TYPE',				'Type');


// member list 
define('_LIST_MEMBER_NAME',			'Nom Affiché');
define('_LIST_MEMBER_RNAME',		'Nom réel');
define('_LIST_MEMBER_ADMIN',		'Super-admin? ');
define('_LIST_MEMBER_LOGIN',		'Peut se loguer? ');
define('_LIST_MEMBER_URL',			'Siteweb');

// banlist
define('_LIST_BAN_IPRANGE',			'Plage d\'IP');
define('_LIST_BAN_REASON',			'Raison');

// actionlist
define('_LIST_ACTION_MSG',			'Message');

// commentlist
define('_LIST_COMMENT_BANIP',		'IP bannies');
define('_LIST_COMMENT_WHO',			'Auteur');
define('_LIST_COMMENT',				'Commentaires');
define('_LIST_COMMENT_HOST',		'Hôte');

// itemlist
define('_LIST_ITEM_INFO',			'Information');
define('_LIST_ITEM_CONTENT',		'Titre et Texte');


// teamlist
define('_LIST_TEAM_ADMIN',			'Administrateur ');
define('_LIST_TEAM_CHADMIN',		'Changer l\'Administrateur');

// edit comments
define('_EDITC_TITLE',				'Editer les Commentaires');
define('_EDITC_WHO',				'Auteur');
define('_EDITC_HOST',				'Depuis où ?');
define('_EDITC_WHEN',				'Quand ?');
define('_EDITC_TEXT',				'Texte');
define('_EDITC_EDIT',				'Editer le Commentaire');
define('_EDITC_MEMBER',				'membre');
define('_EDITC_NONMEMBER',			'non-membre');

// move item
define('_MOVE_TITLE',				'Déplacer dans quel Blog ?');
define('_MOVE_BTN',					'Déplacer l\'article');

?>