<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class COMMENT {
	
	/**
	  * Returns the requested comment (static)
	  */
	function getComment($commentid) {
		$query =  'SELECT cnumber as commentid, cbody as body, cuser as user, cmail as userid, cmember as memberid, ctime as ctime, chost as host, mname as member, cip as ip, cblog as blogid'
		       . ' FROM '.sql_table('comment').' left outer join '.sql_table('member').' on cmember=mnumber'
		       . ' WHERE cnumber=' . intval($commentid);
		$comments = sql_query($query);

		$aCommentInfo = sql_fetch_array($comments);
		if ($aCommentInfo)
		{
			$aCommentInfo['timestamp'] = strtotime($aCommentInfo['ctime']);
		}
		return $aCommentInfo;
	}	
	
	/**
	  * prepares a comment to be saved
	  * (static)
	  */
	function prepare($comment) {
		$comment['user'] = strip_tags($comment['user']);
		$comment['userid'] = strip_tags($comment['userid']);
		
		// remove quotes and newlines from user and userid
		$comment['user'] = strtr($comment['user'], "\'\"\n",'-- ');
		$comment['userid'] = strtr($comment['userid'], "\'\"\n",'-- ');
		
		$comment['body'] = COMMENT::prepareBody($comment['body']);
		
		return $comment;
	}
	
	// prepares the body of a comment (static)
	function prepareBody($body) {
		// remove newlines when too many in a row
		$body = ereg_replace("\n.\n.\n","\n",$body);
		// trim away whitespace and newlines at beginning and end
		$body = trim($body);
		return $body;
	}
	
}

?>