<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NOTIFICATION {

  var $addresses = array();
  
	/**
	  * takes one string as argument, containing multiple e-mail addresses
	  * separated by semicolons
	  * eg: site@demuynck.org;nucleus@demuynck.org;foo@bar.com
	  */
	function NOTIFICATION($addresses) {
		$this->addresses = explode(';' , $addresses);
	}

	/**
	  * returns true if all addresses are valid
	  */
	function validAddresses() {
		foreach ( $this->addresses as $address ) {
			if (!isValidMailAddress(trim($address))) 
				return 0;
		}
		return 1;
	}
	
	/**
	  * Sends email messages to all the email addresses
	  */
	function notify($title, $message, $from) {
		global $member;
			
		foreach ( $this->addresses as $address ) {
			$address = trim($address);
			
			if (!$address)
				continue;
			
			// don't send messages to yourself
			if ($member->isLoggedIn() && ($member->getEmail() == $address))
				continue;
		
			@mail($address, $title, $message , "From: ". $from . "\nContent-Type: text/plain; charset="._CHARSET);
		}
	}
}

?>