<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

/*
  security check for register_globals=on
*/
global $DIR_LIBS,$HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_ENV_VARS, $HTTP_POST_FILES, $HTTP_SESSION_VARS;
$aVarsToCheck = array('DIR_LIBS');
foreach ($aVarsToCheck as $varName) {
	if (  isset($HTTP_GET_VARS[$varName]) 
		|| isset($HTTP_POST_VARS[$varName]) 
		|| isset($HTTP_COOKIE_VARS[$varName])
		|| isset($HTTP_ENV_VARS[$varName])
		|| isset($HTTP_SESSION_VARS[$varName])
		|| isset($HTTP_POST_FILES[$varName])
	)
    die('System is not configured properly');
}
if (!is_dir($DIR_LIBS)) die('System is not configured properly - PLUGINADMIN.php');

include($DIR_LIBS . 'ADMIN.php');

class PluginAdmin {
	

	function PluginAdmin($pluginName)
	{
		global $manager;
    
    if (!defined(_CHARSET))
      sendContentType('text/html', 'admin-' . $action, 'utf-8');
    else
      sendContentType('text/html', 'admin-' . $action, _CHARSET);
		
		$this->strFullName = 'NP_' . $pluginName;
		
		// check if plugin exists and is installed
		if (!$manager->pluginInstalled($this->strFullName))
			doError('Invalid plugin');
		
		$this->plugin =& $manager->getPlugin($this->strFullName);
		$this->bValid = $this->plugin;
	
		if (!$this->bValid) doError('Invalid plugin');
		
		$this->admin = new ADMIN();
		$this->admin->action = 'plugin_' . $pluginName;
	}
	
	function start($extraHead = '')
	{
		global $CONF;
		$strBaseHref  = '<base href="' . htmlspecialchars($CONF['AdminURL']) . '" />';	
		$extraHead .= $strBaseHref;
		
		$this->admin->pagehead($extraHead);
	}
	
	function end()
	{
		$this->admin->pagefoot();
	}	
}
?>