<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class SEARCH {
	
	var $querystring;
	var $marked;
	var $inclusive;
	var $blogs;


    function SEARCH($text) {
      global $blogid;
      $text = preg_replace ("/[\(\)<>=?!#^[\]:;\\%]/","",$text);
      $this->querystring	= $text;
      $this->blogs		= array();
      $this->marked		= $this->boolean_mark_atoms($text);
      $this->inclusive	= $this->boolean_inclusive_atoms($text);
      $this->blogs[] = $blogid;
    }

    function boolean_inclusive_highlight($text){
    	$result=trim($text);
    	$result=preg_replace("/([[:space:]]{2,})/",' ',$result);

    	/* convert normal boolean operators to shortened syntax */
    	$result=eregi_replace(' not ',' NOT ',$result);
    	$result=eregi_replace(' and ',' AND ',$result);
    	$result=eregi_replace(' or ',' OR ',$result);

    	$result=str_replace('-',' NOT ',$result);
    	$result=str_replace('+',' AND ',$result);
    	$result=str_replace(',',' OR ',$result);

    	/* drop unnecessary spaces */
    	$result=str_replace('  ',' ',$result);
    	
    	/* space = AND */
    	$result=str_replace(' ',' AND ',$result);

    	/* strip exlusive atoms */
    	$result=preg_replace(
    		"(\-\([A-Za-z0-9]{1,}[A-Za-z0-9\-\.\_\,]{0,}\))",
    		'',
    		$result);

    	$result=str_replace('(',' ',$result);
    	$result=str_replace(')',' ',$result);

    	return sql_escape($result);
    }
   
    function boolean_inclusive_atom($string){
    	$result=trim($string);
    	$result=preg_replace("/([[:space:]]{2,})/",' ',$result);

    	/* convert normal boolean operators to shortened syntax */
    	$result=eregi_replace(' not ',' -',$result);
    	$result=eregi_replace(' and ',' ',$result);
    	$result=eregi_replace(' or ',',',$result);

    	/* drop unnecessary spaces */
    	$result=str_replace(' ,',',',$result);
    	$result=str_replace(', ',',',$result);
    	$result=str_replace('- ','-',$result);
    	$result=str_replace('+','',$result);

    	/* strip exlusive atoms */
    	$result=preg_replace(
    		"(\-\([A-Za-z0-9]{1,}[A-Za-z0-9\-\.\_\,]{0,}\))",
    		'',
    		$result);

    	$result=str_replace('(',' ',$result);
    	$result=str_replace(')',' ',$result);
    	$result=str_replace(',',' ',$result);

    	return $result;
    }

    function boolean_inclusive_atoms($string){
    	$result=trim($string);
    	$result=preg_replace("/([[:space:]]{2,})/",' ',$result);

    	/* convert normal boolean operators to shortened syntax */
    	$result=eregi_replace(' not ',' -',$result);
    	$result=eregi_replace(' and ',' ',$result);
    	$result=eregi_replace(' or ',',',$result);

    	/* drop unnecessary spaces */
    	$result=str_replace(' ,',',',$result);
    	$result=str_replace(', ',',',$result);
    	$result=str_replace('- ','-',$result);
    	$result=str_replace('+','',$result);

    	/* strip exlusive atoms */
    	$result=preg_replace(
    		"(\-\([A-Za-z0-9]{1,}[A-Za-z0-9\-\.\_\,]{0,}\))",
    		'',
    		$result);

    	$result=str_replace('(',' ',$result);
    	$result=str_replace(')',' ',$result);
    	$result=str_replace(',',' ',$result);

    	return $result;
    }

    function boolean_mark_atoms($string){
    	$result=trim($string);
    	$result=preg_replace("/([[:space:]]{2,})/",' ',$result);

    	/* convert normal boolean operators to shortened syntax */
    	$result=eregi_replace(' not ',' -',$result);
    	$result=eregi_replace(' and ',' ',$result);
    	$result=eregi_replace(' or ',',',$result);


    	/* strip excessive whitespace */
    	$result=str_replace('( ','(',$result);
    	$result=str_replace(' )',')',$result);
    	$result=str_replace(', ',',',$result);
    	$result=str_replace(' ,',',',$result);
    	$result=str_replace('- ','-',$result);
    	$result=str_replace('+','',$result);
    	/* apply arbitrary function to all 'word' atoms */
      $result_a = explode(" ",$result);
      for($word=0;$word<count($result_a);$word++){
         $result_a[$word] = "foo[('".$result_a[$word]."')]bar";
      }
      $result = implode(" ",$result_a);
        
    	/* dispatch ' ' to ' AND ' */
    	$result=str_replace(' ',' AND ',$result);

    	/* dispatch ',' to ' OR ' */
    	$result=str_replace(',',' OR ',$result);

    	/* dispatch '-' to ' NOT ' */
    	$result=str_replace(' -',' NOT ',$result);
    	return $result;
    }

}
?>