<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

function getVar($name) {
	global $HTTP_GET_VARS;
	return undoMagic($HTTP_GET_VARS[$name]);
}

function postVar($name) {
	global $HTTP_POST_VARS;
	return undoMagic($HTTP_POST_VARS[$name]);
}

function cookieVar($name) {	
	global $HTTP_COOKIE_VARS;
	return undoMagic($HTTP_COOKIE_VARS[$name]);
}

// request: either POST or GET
function requestVar($name) {
	return (postVar($name)) ? postVar($name) : getVar($name);
}

function serverVar($name) {
	global $HTTP_SERVER_VARS;
	return $HTTP_SERVER_VARS[$name];
}

// removes magic quotes if that option is enabled
function undoMagic($data) {
	return get_magic_quotes_gpc() ? stripslashes_array($data) : $data;
}

function stripslashes_array($data) {
	return is_array($data) ? array_map('stripslashes', $data) : stripslashes($data);
}

// integer array from request
function requestIntArray($name) {
	global $HTTP_POST_VARS;
	return $HTTP_POST_VARS[$name];	
}

// array from request. Be sure to call undoMagic on the strings inside
function requestArray($name) {
	global $HTTP_POST_VARS;
	return $HTTP_POST_VARS[$name];	
}


// add all the variables from the request as hidden input field
// @see globalfunctions.php#passVar
function passRequestVars() {
	global $HTTP_POST_VARS, $HTTP_GET_VARS;
	foreach ($HTTP_POST_VARS as $key => $value) {
		if (($key == 'action') && ($value != requestVar('nextaction')))
			$key = 'nextaction';
		if (($key != 'login') && ($key != 'password'))
			passVar($key, $value);
	}
	foreach ($HTTP_GET_VARS as $key => $value) {
		if (($key == 'action') && ($value != requestVar('nextaction')))
			$key = 'nextaction';
		if (($key != 'login') && ($key != 'password'))
			passVar($key, $value);
	}
	
}

function postFileInfo($name) {
	return $_FILES[$name];
}

function setOldAction($value) {
	$_POST['oldaction'] = $value;	
}

?>