<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

function getVar($name) {
	if (array_key_exists($name,$_GET)) 
		return undoMagic($_GET[$name]);
	else
		return;
}

function postVar($name) {
	if (array_key_exists($name,$_POST))
		return undoMagic($_POST[$name]);
	else
		return;
}

function cookieVar($name) {
	if (array_key_exists($name,$_COOKIE)) 
		return undoMagic($_COOKIE[$name]);
	else
		return '';
}

function requestVar($name) {
	if(array_key_exists($name,$_POST))
		return undoMagic($_POST[$name]);
	elseif( array_key_exists($name,$_GET))   
		return undoMagic($_GET[$name]);
	elseif( array_key_exists($name,$_REQUEST))   
		return undoMagic($_REQUEST[$name]);
	else
		return;
}

function serverVar($name) {
	if (array_key_exists($name,$_SERVER)) 
		return $_SERVER[$name];
	else
		return;
}

// removes magic quotes if that option is enabled
function undoMagic($data) {
	return get_magic_quotes_gpc() ? stripslashes($data) : $data;
}

// integer array from request
function requestIntArray($name) {
	return $_REQUEST[$name];	
}

// array from request. Be sure to call undoMagic on the strings inside
function requestArray($name) {
	return $_REQUEST[$name];	
}

// add all the variables from the request as hidden input field
// @see globalfunctions.php#passVar
function passRequestVars() {
	foreach ($_REQUEST as $key => $value) {
		if (($key == 'action') && ($value != requestVar('nextaction')))
			$key = 'nextaction';
		if (($key != 'login') && ($key != 'password'))
			passVar($key, $value);
	}
}

function postFileInfo($name) {
	return $_FILES[$name];
}

function setOldAction($value) {
	$_POST['oldaction'] = $value;	
}

?>