<?php
/**
  * BLOG:CMS: Personal Content Management System 
  * http://blogcms.com/
  *
  * Radek HULAN, 2006
  * http://hulan.cz/
**/

class NP_AllItems extends NucleusPlugin {

	function getName() {   return 'AllItems';    }
	function getAuthor()  { return 'Radek HULAN'; }
	function getURL() { return 'http://hulan.cz/'; }
	function getVersion() {   return '1.0'; }
	function getDescription() { return 'This plugin displays all items.'; }
	function supportsFeature($f) { return ($f == 'SqlTablePrefix') ? 1 : 0; }

	function doSkinVar($skinType) {
		global $blog, $catid;
		$blogid = $blog->getID();
		if (intval($catid))
			$catfilter = " AND c.catid = $catid ";
		else
			$catfilter = '';
		$query = sql_query(
				'SELECT s.name as catgroup, c.cname as catname, i.inumber AS id, i.ititle AS title, UNIX_TIMESTAMP(itime) AS published '.
				'FROM '.sql_table('item').' i, '.sql_table('subcategory').' s, '.sql_table('category').' c '.
				'WHERE s.blogid='.$blogid.' AND s.groupid=c.cgroup AND c.catid = i.icat '.$catfilter.' AND i.idraft=0 '.
				'ORDER by catgroup, catname, title ASC');
		$catgroup = '';
		$catname = '';
		while ($row = sql_fetch_object($query)) {
			// category name
			if ($catname != $row->catname) {
				if ($catname)
					echo '</table>';
				// category group
				if ($catgroup != $row->catgroup) {
					echo '<h4>', htmlspecialchars(sql_unescape($row->catgroup)), '</h4>';
					$catgroup = $row->catgroup;
				}
				echo '<h5>', htmlspecialchars(sql_unescape($row->catname)), '</h5>';
				$catname = $row->catname;
				echo '<table><tr><th style="width:330px">Článek</th><th style="width:80px">Publikováno</th><th style="width:80px">Čteno</th></tr>';
			}
			// article
			$viewed = intval(quickQuery('SELECT views as result FROM '.sql_table('plugin_views').' WHERE id='.$row->id)). 'x';
			echo '<tr><td><a href="'.createItemLink($row->id).'">', sql_unescape($row->title), '</a></td><td>', date("d.m.y",$row->published), "</td><td>$viewed</td></tr>\n";
		}
		if ($catname)
			echo "</table>\n";
	}
}
?>