<?php 

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_BlogWithOffset extends NucleusPlugin {
    function getName() { return 'BlogWithOffset'; }
    function getAuthor() { return 'Radek HULAN'; }
    function getURL() { return 'http://hulan.cz/blog/'; }
    function getVersion() { return '0.1 BLOG:CMS'; }
    function getDescription() { return 'Like the blog or otherblog skinvars, but accepts limit and/or offset in the query string'; }

  	function supportsFeature($feature) { if ($feature=='SqlTablePrefix') return 1; else return 0;}

    function doSkinVar($skinType, $template, $amount = 10, $category = '' , $blogname = '') {
        global $CONF, $blog, $blogid, $startpos, $manager, $catid;

        if (!empty($category)) $catid=intval($category);
        $limit=getVar('limit');
        $offset=getVar('offset');
        $data = explode( "/", serverVar( 'REQUEST_URI'));
        for ( $i = 1;$i < count( $data);$i++) if ( $data[$i] == 'offset') $offset = intval( $data[$i + 1]);

        if ($limit=='') list($limit) = sscanf($amount, '%d');
        if ($offset=='') list($temp, $offset) = sscanf($amount, '%d(%d)');

        if (!empty($blogname)) 
          $blog =& $manager->getBlog(getBlogIDFromName($blogname));
        else
      	  $blog =& $manager->getBlog($blogid);
      	$skinid = $blog->getDefaultSkin();
      	$skin = new SKIN($skinid);
        $handler = new ACTIONS($skinType);
        $parser = new PARSER(SKIN::getAllowedActionsForType($skinType), $handler);
        $parser->setProperty('IncludeMode',$skin->getIncludeMode());
        $parser->setProperty('IncludePrefix',$skin->getIncludePrefix());
        $handler->setSkin($skin);
        $handler->parser =& $parser;
    	$handler->_setBlogCategory($blog,'');
    	$handler->_preBlogContent('blog',$blog);
    	$handler->amountfound = $blog->readLog($template, $limit, $offset, $startpos);
    	$handler->_postBlogContent('blog',$blog);
    } // doSkinVar
} // class
?>