<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_CSS extends NucleusPlugin {

 function getNAME() { return 'CSS';  }
 function getAuthor()  { return 'Radek HULAN';  }
 function getURL() {  return 'http://hulan.cz/blog/'; }
 function getVersion() { return '0.0.1'; }
 function getDescription() { 
  return 'CSS style switcher. Usage: <%CSS(META)%> in *every* page header, supplies complete meta css style info, and <%CSS(SELECT)%> to select a new style.';
 }
 
 function install() {
   $this->createOption('CSSStyles','CSS filenames, comma separated list (without .css!):','textarea','extreme,czechia,golf,france,blue');
   $this->createOption('CSSNames','CSS style names as shown to user:','textarea','eXtreme Styles,Jaromir Jagr,Golf,Donald Trump,Royal Navy');
   $this->createOption('CSSDefaultFile','Default style filename (without .css!):','text','extreme');
   $this->createOption('CSSText1','Text for current style (can be blank):','text','');
   $this->createOption('CSSText2','Text for select style (can be blank):','text','');
   $this->createOption('CSSText3','Text for select style button:','text','Apply Skin!');
   $this->createOption('menu','Text for menu:','text','Skin');
   $this->createOption('version','CSS version:','text','');
   $this->createOption('cookie','Cookie name:','text','BLOGCMS4');
 }
 
 function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
 }

 function browserAgent(){
	$xagent = strtolower(serverVar("HTTP_USER_AGENT"));
  if(!(strpos(strtolower($xagent),"opera")===false)){$xagent=substr($xagent,strpos(strtolower($xagent),"opera"),10);};
  if(!(strpos(strtolower($xagent),"msie")===false)){$xagent=substr($xagent,strpos(strtolower($xagent),"msie"),8);};
  if(!(strpos(strtolower($xagent),"mozilla")===false)){$xagent="Gecko";};
  $xagent=substr($xagent,0,20);
  return $xagent;
 }
 
 function getEventList() { return array('PreSkinParse'); 	}	

 function event_PreSkinParse(&$data) {
  /* ------------------------------------------ */
  /* -------------- set a cookie -------------- */
  if ( !empty($_POST['CSSVOLBA']) ) {
   $cookie=$this->getOption('cookie'); 
   setCookie($cookie,$_POST['CSSVOLBA'], time()+36002430);
   setCookie($cookie,$_POST['CSSVOLBA'], time()+36002430,'/',serverVar('HTTP_HOST'));
   $url = "http://".serverVar('HTTP_HOST').serverVar('REQUEST_URI');
   header('Expires: 0');
   header('Pragma: no-cache');
   header("Location: $url");
   $url = htmlspecialchars($url);
   die("Redirected: <a href=\"$url\">$url</a>");
  }
 }

 function doSkinVar($skinType, $whattodo = 'META', $defaultsheet = '' ) {
  $cookie=$this->getOption('cookie');
  $version=$this->getOption('version');

  /* ---------------------------------------------------- */
  /* query a style formerly saved or supply a default one */
  if ( ($whattodo=='META') || ($whattodo=='SELECT')){
    if (isset($_COOKIE[$cookie])){
      $mycookie=$_COOKIE[$cookie];
      /* style still exists? */
      $found=false;
      $mystyles = explode(",",$this->getOption('CSSStyles'));
      foreach ($mystyles as $mystyle){
        if($mystyle==$mycookie){$found=true;};
      }
      if (!$found) {$mycookie="";}
    } else {
      if($defaultsheet==''){$mycookie=$this->getOption('CSSDefaultFile');} else {$mycookie=$defaultsheet;};
    }
    if ($mycookie==""){
      if($defaultsheet==''){$mycookie=$this->getOption('CSSDefaultFile');} else {$mycookie=$defaultsheet;};
    }
  }

  /* ------------------------------------------- */
  /* whattodo = META -- echo selected stylesheet */
  if ($whattodo=='META'){
    global $CONF;
    $CONF['NUCLEUSSTYLE']=$mycookie;

    /* echo stylesheet into a header */
    $url=$CONF['SkinsURL'].PARSER::getProperty('IncludePrefix').$mycookie.$version.'.css';
    echo "<link rel='stylesheet' type='text/css' href='".$url."' media='screen,projection,tv'/>\n";
    $CONF['NUCLEUSCSS']=$url;
  }

  /* ------------------------------------------------------------------- */
  /* whattodo = SELECT -- display current style and form for changing it */
  if ($whattodo=='SELECT'){
    /* echo current style */
    if ($this->getOption('CSSText1')!=""){
      echo $this->getOption('CSSText1').$mycookie;
    }
    /* echo style select form */
    echo $this->getOption('CSSText2');
    $url=htmlspecialchars("http://".serverVar('HTTP_HOST').serverVar('REQUEST_URI'));
    echo "<form id='CSSSwitch' method='post' action='$url'>\n";
    echo "<fieldset><legend>".$this->getOption('menu')."</legend>";
    echo "<select name='CSSVOLBA'>\n";
     $mystyles = explode(",",$this->getOption('CSSStyles'));
     $mynames = explode(",",$this->getOption('CSSNames'));
     $i=0;
     foreach ($mystyles as $mystyle){
      if($mystyle==$mycookie){$deff=" selected='selected' ";} else {$deff="";};
      echo "<option value='$mystyle' $deff id='opt".strval($i)."'>".$mynames[$i]."</option>\n";
      $i++;
     }
    echo "</select>\n";
    global $CONF;
    echo "<input name='submitcss' type='image' src='".$CONF['SkinsURL']."base/applyskin.png' alt='".$this->getOption('CSSText3')."' title='".$this->getOption('CSSText3')."'/>\n";
    echo "</fieldset>\n";
    echo "</form>\n";
  }

 }
}

?>