<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_CSSAdmin extends NucleusPlugin {

	function getNAME() { return 'CSSAdmin';  }
	function getAuthor()  { return 'Radek HULAN';  }
	function getURL() {  return 'http://hulan.cz/blog/'; }
	function getVersion() { return '0.0.1'; }
	function getDescription() { return 'CSS style switcher for Admin Area.'; }

	function install() {
		$this->createMemberOption('CSSStyles','CSS style for Admin Area:','select','Default','Light Blue|admin_standard|Dark Blue|admin_moose|Red|admin_white|Default|Default');
		$this->createOption('CSSDefaultFile','Default CSS style:','text','Default');
	}
	
	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}
	
	function getEventList() { 
		return array('AdminPrePageHead'); 	
	}	
	
	function event_AdminPrePageHead(&$data) {
		global $member; 
		if (isset($member)) 
			$style=$this->getMemberOption($member->getID(),'CSSStyles');
		if (!isset($style) || $style=="") 
			$style=$this->getOption('CSSDefaultFile');
		if ($style=='') 
			$style='Default';
		global $CONF;
		$url=$CONF['AdminURL']."styles/$style.css";
		$data['extrahead'].="<link rel='stylesheet' type='text/css' href='".$url."' media='screen,projection,tv'/>\n";
	}

}

?>