<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_Calendar extends NucleusPlugin { 

   /**
     * Plugin data to be shown on the plugin list
     */ 
   function getName() {          return 'Calendar Plugin'; } 
   function getAuthor()  {       return 'karma / roel / jhoover'; } 
   function getURL()  {          return 'http://nucleuscms.org/'; } 
   function getVersion() {       return '0.75'; } 
   function getDescription() { 
      return 'This plugin can be called from within skins to insert a calender on your site, by using &lt;%Calendar%&gt.'; 
   } 

	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

   /**
     * On plugin install, three options are created
     */ 
   function install() { 
      // create some options
      $this->createOption('Locale','Language (locale) to use','text','english'); 
      $this->createOption('LinkAll','Create links for all days (even those that do not have posts?)','yesno','no'); 
      $this->createOption('Summary','Summary text for the calendar table','text','Monthly calendar with links to each day\'s posts'); 
   } 

   /**
       * skinvar parameters:
       *      - blogname (optional)
       */ 
   function doSkinVar($skinType, $blogName = '') { 
        global $manager, $blog, $CONF, $archive; 
        
        /*
            find out which blog to use:
                1. try the blog chosen in skinvar parameter
                2. try to use the currently selected blog
                3. use the default blog
        */ 
        if ($blogName) { 
            $b =& $manager->getBlog(getBlogIDFromName($params[2])); 
        } else if ($blog) { 
            $b =& $blog; 
        } else { 
            $b =& $manager->getBlog($CONF['DefaultBlog']); 
        } 
        
        /*
            select which month to show
                - for archives: use that month
                - otherwise: use current month
        */ 
        switch($skinType) { 
            case 'archive': 
                sscanf($archive,'%d-%d-%d',$y,$m,$d); 
                $time = mktime(0,0,0,$m,1,$y); 
                break; 
            default: 
                $time = $b->getCorrectTime(time()); 
        } 
        
        $this->_drawCalendar($time, $b, $this->getOption('LinkAll')); 
    } 
    
   /**
     * This function draws the actual calendar as a table
     */ 
   function _drawCalendar($timestamp, &$blog, $linkall) { 
      $blogid = $blog->getID(); 
        
      // set correct locale
      setlocale(LC_TIME,$this->getOption('Locale')); 
        
      // get year/month etc
      $date = getDate($timestamp); 
        
      $month = $date['mon']; 
      $year = $date['year']; 
        
      // get previous year-month
        $last_month = $month - 1; 
        $last_year = $year; 
      if (!checkdate($last_month, 1, $last_year)) { 
          $last_month += 12; 
          $last_year --; 
        } 
        
      if ($last_month < 10) { 
      $last_month = "0".$last_month; 
      } 
      else { 
      $last_month >= 10; 
      $last_month = $last_month; 
      } 
        
      // get the next year-month
        $next_month = $month + 1; 
        $next_year = $year; 
        if (!checkdate($next_month, 1, $next_year)) { 
          $next_year++; 
          $next_month -= 12; 
        } 

      if ($next_month < 10) { 
      $next_month = "0".$next_month; 
      } 
      else { 
      $next_month >= 10; 
      $next_month = $next_month; 
      } 
        
      // find out for which days we have posts
      if ($linkall == 'no') { 
         $days = array(); 
         $timeNow = $blog->getCorrectTime(); 
         $res = sql_query('SELECT DAYOFMONTH(itime) as day FROM '.sql_table('item').' WHERE MONTH(itime)='.$month.' and YEAR(itime)='.$year .' and iblog=' . $blogid . ' and idraft=0 and UNIX_TIMESTAMP(itime)<'.$timeNow.' GROUP BY day'); 
         while ($o = sql_fetch_object($res)) { 
            $days[$o->day] = 1; 
         } 
      } 
        
      // draw header
      ?> <!-- kalendar start -->
         <table class="calendar" summary="<?php echo htmlspecialchars($this->getOption('Summary'))?>">
         <caption> <a href="<?php echo createArchiveLink($blogid,$last_year.'-'.$last_month)?>"> &lt; </a> <a href="<?php echo createArchiveLink($blogid, strftime('%Y-%m',$timestamp))?>"><?php echo strftime('%B %Y',$timestamp)?></a> <a href="<?php echo createArchiveLink($blogid,$next_year.'-'.$next_month)?>"> &gt; </a> </caption>
            <tr class="calendardateheaders">

      <?php 
            // output localized weekday-abbreviations as column headers
            $weekdays = array('monday','tuesday','wednesday','thursday','friday','saturday','sunday'); 
            foreach($weekdays as $weekday) { 
               echo strftime('<th abbr="%A">%a</th>',strtotime($weekday)); 
            } 
      ?> 
            </tr>
         <tr>
      <?php 
        

      // draw empty cells for all days before start
      $firstDay = getDate(mktime(0,0,0,$month,1,$year)); 
        
      // sunday should come as last in row
      if ($firstDay['wday'] == 0) 
         $firstDay['wday'] = 7; 
          
      $wday = 1; 
      while ($wday < $firstDay['wday']) { 
         $wday++; 
         echo '<td> </td>'; 
      } 
        
      $mday = 1; 
      while (checkdate($month, $mday, $year)) { 
          
         if (($linkall == 'yes') || $days[$mday]) 
            echo '<td><a href="',createArchiveLink($blogid,$year.'-'.$month.'-'.$mday) ,'">' ,  $mday, '</a></td>'; 
         else 
            echo '<td>',$mday,'</td>'; 
          
          
         $mday++; $wday++; 
         if (($wday > 7) && (checkdate($month, $mday, $year))) { 
            echo '</tr><tr>'; 
            $wday = 1; 
         } 
      } 
        
      while ($wday++ < 8) 
         echo '<td> </td>'; 
      echo '</tr>'; 
    
      // footer
      echo '</table>'; 
      echo "\n<!-- kalendar end -->\n";
   } 
    
} 
?>