<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

/*
 A simple chat system, displays last 15 MESSAGEs in a descending order.
 Intended to be used on a main page, where it allows comments being entered
 for site as whole, not for individual articles. This script also
 checks if MESSAGE already exists, and rejects insert in such a case.

 Usage:  Single chat:
            <%Chat%> 
             
         Multiple, independent shoutboxes:
            <%Chat%(chatid)> , 
            e.g. <%Chat%(1)> for main page messages and
                 <%Chat%(2)> for contact list messages
            e.g. <%Chat%(memberid))>
            e.g. <%Chat%(blogid))>
            e.g. <%Chat%(blogid*10+memberid))>
 
 This script uses 2 style classes, .chattable, and .chatform, samples
 are included here (just copy&paste this into default.css), it uses
 also .formbutton and .formfield styles common to all Nucleus:
 
 .chattable{
   background-color: #FFF8F0;
   border: 1px solid #9F9F9F;
   border-bottom: 1px solid #F4F4F4;
   font-size: 11px;
   height: 240px;
   line-height: 18px;
   overflow: auto;
   position: relative;
   width: auto;
 }
 .chatform{
   text-align: right;
 }

 .formbutton{background-color:#BFBFBF;border:1px solid #A9A9A9;color:#353535}
 .formbutton:hover{background-color:#FFDA00;border:1px solid #000000;color:#000000}
 .formfield{background-color:#F4F4F4;border:1px solid #9F9F9F;border-bottom:1px solid #FAFAFA;color:#4A4A4A;margin:1px}
 .formfield:focus{background-color:#FFFFFF;border:1px solid #000000}
 
*/

class NP_Chat extends NucleusPlugin {

 function getNAME() { return 'Chat';  }
 function getAuthor()  { return 'Radek HULAN';  }
 function getURL() {  return 'http://hulan.cz/blog/'; }
 function getVersion() { return '0.2.0'; }
 function getDescription() { 
  return 'Chat / shoutbox. NAME and MESSAGE are required, EMAIL/URI optional';
 }
 
 function install() {
   $this->createOption('ChatNAME','Label for NAME:','text','Name: ');
   $this->createOption('ChatEMAIL','Label for EMAIL/URI:','text','Email/URI: ');
   $this->createOption('ChatMESSAGE','Label for MESSAGE (can be blank):','text','');
   $this->createOption('ChatTEXTAREA','Default MESSAGE (can be blank):','text','[message]');
   $this->createOption('ChatBUTTON','Send button text:','text','Send message!');
   $this->createOption('ChatNUMBER','Number of MESSAGEs to show:','text','15');
 }

 function getTableList() {	return array(sql_table('MINICHAT')); } 
 
	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

 function unInstall() { 
 }

 function doSkinVar($skinType, $chatid = 0) {
      /* insert new MESSAGE into a table  */
      if (isset($_POST['MESSAGE'])){
        $myMESSAGE=substr(sql_escape(strip_tags(undoMagic($_POST['MESSAGE']))),0,255);
        $myNAME=substr(sql_escape(strip_tags(undoMagic($_POST['NAME']))),0,20);
        $myEMAIL=substr(sql_escape(strip_tags(undoMagic($_POST['EMAIL']))),0,60);
        $prTEXTAREA = $this->getOption('ChatTEXTAREA');
        if($myMESSAGE==$prTEXTAREA){
          /* MESSAGE same as default one, so deleting.. */
          $myMESSAGE="";
        };
        /* was there any NAME and MESSAGE entered? */
        if(($myNAME!="") && ($myMESSAGE!="")){
          /* last MESSAGE of current user */
          $query = "SELECT MAX(UID) AS TOPUID FROM ".sql_table('MINICHAT')." WHERE (NAME='$myNAME')";
          $query = sql_query($query); 
          /* was there any MESSAGE from this user ?? */
       if($msg=sql_fetch_array( $query )){
            $pocet = $msg['TOPUID'];
            /* is current MESSAGE the same one as last one already inserted?? */
            $query = "SELECT MESSAGE FROM ".sql_table('MINICHAT')." WHERE UID='$pocet'";
            $query = sql_query($query);
            if($msg = sql_fetch_array( $query )){
              if($myMESSAGE==$msg['MESSAGE']){
                /* yes, same MESSAGE, ignore this, probably a browser reload */
                $myMESSAGE="";
              }
            }
          }
        } else
        {
          $myMESSAGE="";
        }
      } else {
        $myMESSAGE="";
      };
      /* insert a new MESSAGE */
      if (($myNAME!="") && ($myMESSAGE!="")) {
        $query = 'INSERT INTO '.sql_table('MINICHAT').' (NAME,MESSAGE,EMAIL) '."VALUES('$myNAME','$myMESSAGE','$myEMAIL')";
        sql_query($query);
      };
      
      /* show last 15 MESSAGEs */
      echo "<div class=\"chattable\">";
      $prNUMBER = $this->getOption('ChatNUMBER');
      $query = sql_query( "SELECT * FROM ".sql_table('MINICHAT')." ORDER BY UID DESC LIMIT 0,$prNUMBER" );
      while ( $msg = sql_fetch_array( $query )) {
          $myurl=$msg['EMAIL'];
          $msg['MESSAGE']=sql_unescape($msg['MESSAGE']);
          $msg['NAME']=sql_unescape($msg['NAME']);
          $msg['EMAIL']=sql_unescape($msg['EMAIL']);
          if($myurl==""){
            /* no EMAIL or http, so just show userNAME in bold */
            echo "<strong>".$msg['NAME']."</strong> - ".$msg['MESSAGE']."<br />";
          } else {
            /* check for email address */
            if (strpos($myurl,"@")===false){
              /* no @, so assume http */
              if (strpos(strtolower($myurl),"http")===false){
                $myurl="http://$myurl";
              };
            } else { $myurl="mailto:$myurl"; }
            echo "<a href=\"$myurl\">".$msg['NAME']."</a> - ".$msg['MESSAGE']."<br />";
          }
      };
      echo "</div>";

      /* show form to enter new NAME, EMAIL and MESSAGE */
      $prNAME = $this->getOption('ChatNAME');
      $prEMAIL = $this->getOption('ChatEMAIL');
      $prMESSAGE = $this->getOption('ChatMESSAGE');
      $prTEXTAREA = $this->getOption('ChatTEXTAREA');
      $prBUTTON = $this->getOption('ChatBUTTON');
  
      echo "<form method=\"post\" action=\"index.php\">";
      echo "<div class=\"chatform\">";
      echo "<label for=\"NAME\">$prNAME</label><input class=\"formfield\" type=\"text\" id=\"NAME\" name=\"NAME\" size=\"15\" maxlength=\"20\" /><br />";
      echo "<label for=\"EMAIL\">$prEMAIL</label><input class=\"formfield\" type=\"text\" id=\"EMAIL\" name=\"EMAIL\" size=\"15\" maxlength=\"60\" /><br />";
      echo "<label for=\"MESSAGE\">$prMESSAGE</label><textarea class=\"formfield\" id=\"MESSAGE\" name=\"MESSAGE\" cols=\"15\" rows=\"2\">$prTEXTAREA</textarea><br />";
      echo "<input class=\"formbutton\" type=\"submit\" value=\"$prBUTTON\" />";
      echo "</div>";
      echo "</form>";
 }
}
?>