<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_CommentPreview extends NucleusPlugin {

	function getName() 		{ return 'CommentPreview'; }
	function getAuthor()  	{ return 'Radek Hulan'; }
	function getURL()  		{ return 'http://hulan.cz/blog/item/comment-preview-for-nucleus-cms'; }
	function getVersion() 	{ return '0.1'; }
	function getDescription()
	{
		return 'Replacement for commentform with a WYSIWYG preview. THIS PLUGIN MUST BE INSTALLED AS THE FIST PLUGIN IN THE PLUGIN LIST!';
	}

	function supportsFeature($what) {
		switch($what)
		{
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

	function install() {
		$this->createOption('enable', 'Enable comment preview', 'yesno', 'yes');
		$this->createOption('expiration', 'Comment preview expiration in minutes', 'text', '10');
		$this->createOption('preview1', 'Comment preview text start:', 'textarea', "<h4>Preview and Confirm Your Comment!</h4>\n<blockquote id='commentpreview'>");
		$this->createOption('preview2', 'Comment preview text start:', 'textarea', "</blockquote>");
	}


	function getTableList() {
		return array( /* sql_table('plugin_cpreview') - no need to backup this */ );
	}

	function getEventList() {
		return array('PreAddComment','PrepareCommentForPreview');
	}
	
	function event_PrepareCommentForPreview(&$data){
		echo $this->getOption('preview1');
		$data['body'] = commentformatting($data['body']);
		echo $data['body'];
		echo $this->getOption('preview2');
	}
	
	function event_PreAddComment(&$data) {
		// preview disabled, quit
		if ($this->getOption('enable')!='yes') return;
		global $member;
	
		$comment 	= $data['comment'];
		$name		= sql_escape($comment['user']);
		$url			= sql_escape($comment['userid']);
	
		$body		= sql_escape(trim($comment['body']));
		$body   		= str_replace("\r","",$body);
	
		$ip			= sql_escape($comment['ip']);
		$memberid	= intval($comment['memberid']);
		$timestamp	= strval(time()-60*intval($this->getOption('expiration')));
		$itemid		= $comment['itemid'];
		$blogid 		= getBlogIDFromItemID($comment['itemid']);
	
		/* same preview, not older than 10 minutes, already exists? */
		$query=sql_query(
			   'select cnumber from '.sql_table('plugin_cpreview').' where '.
			   "cbody='$body' and cuser='$name' and cmail='$url' and cmember=$memberid and citem=$itemid and cip='$ip' and cblog=$blogid and ctime>$timestamp");
		if ($row=sql_fetch_object($query)){
			$cnumber=$row->cnumber;
			/* ok, let BLOG:CMS handle this, but delete preview commment first */
			$query='delete from '.sql_table('plugin_cpreview').' where cnumber='.strval($cnumber);
			sql_query($query);
			return;
		}
	
		/* user posting this comment first time, let's save it for preview */
		$timestamp=strval(time());
		$query='insert into '.sql_table('plugin_cpreview').' (cbody,cuser,cmail,cmember,citem,ctime,cip,cblog)'.
			   ' values '.
			   "('$body','$name','$url',$memberid,$itemid,$timestamp,'$ip',$blogid)";
		/* cnumber as a param */
		sql_query($query);
		$postid=strval(sql_insert_id());
		/* redirect and preview the comment */
		$url = fancyLink($itemid);
		if (strpos($url,'?')==false) $url.='?cpreview='.$postid.'#commentpreview'; else $url.='&cpreview='.$postid.'#commentpreview';
		header('Expires: 0');
		header('Pragma: no-cache');
		header('Location: '.$url);
		exit();
  }

}
?>