<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/


class NP_Contact extends NucleusPlugin {

	function supportsFeature($feature) { if ($feature=='SqlTablePrefix') return 1; else return 0;}
	function getName() {return 'Contact form'; 	}
	function getAuthor()  { return 'Radek HULAN'; }
	function getURL() {return 'http://hulan.cz/blog/'; }
	function getDescription() { return 'Contact form.';	}
	function getVersion() {    return '1.1'; }

	function install() {
		$this->createOption('email-not-valid', 'Email is not valid message', 'textarea', "<h3>&raquo; Email address is not valid...</h3>");
		$this->createOption('message-empty', 'Message is empty', 'textarea', "<h3>&raquo; Message is empty...</h3>");
		$this->createOption('message-sent', 'Message was sent', 'textarea', "<h3>&raquo; Your message was sent! Thank you!</h3>");
		$this->createOption('owner-email', 'Weblog owner email missing', 'textarea', "<h3>Your email address is not defined. Please define it!</h3>");
		
	}

	function initCaptcha(){
		// members are not authorized
		global $member;
		if ($member->isLoggedIn())
			return;
		// create captcha
		global $manager;
		$plugin =& $manager->getPlugin('NP_Captcha');
		if (!$plugin) 
			return false;
		$data = array();
		$data['type'] = 'membermailform-notloggedin';
		$plugin->event_FormExtra(&$data);
	}
	
	function doSkinVar($skinType, $email = '') {
		global $blog;
		$email = $blog->getNotifyAddress();
		if (strpos($email,';')!==false)
			$email = substr($email,0,strpos($email,';'));
		if ( !isValidMailAddress($email) ) {
			echo $this->getOption('owner-email');
			return;
		}
		// error reporting
		if ( isset($_POST['message']) && isset($_POST['name']) ){
			// Captcha challenge
			global $manager;
			$plugin =& $manager->getPlugin('NP_Captcha');
			if ($plugin) {
				$data = array();
				$data['type'] = 'membermail';
				$plugin->event_ValidateForm(&$data,'');
				if (isset($data['error'])) {
					echo '<h3>',$data['error'],'</h3>';
					$this->initCaptcha();
					return;
				}
			}
			if ( !empty($_POST['message']) && !empty($_POST['name']) ) {
				if ( !isValidMailAddress(postVar('email')) ) { 
					echo $this->getOption('email-not-valid');
					$this->initCaptcha();
					return;
				}
			} else {
				echo $this->getOption('message-empty');
				$this->initCaptcha();
				return;
			}
		}
		// send the email
		if (isset($_POST['message']) && isset($_POST['name'])){
			empty($_POST['name']) ? $name="N.A." : $name=postVar('name');
			empty($_POST['email']) ? $to="N.A." : $to=postVar('email');
			empty($_POST['telephone']) ? $telephone="N.A." : $telephone=postVar('telephone');
			empty($_POST['message']) ? $message="N.A." : $message=postVar('message');
			$xdns = substr(strtolower(@gethostbyaddr(serverVar("REMOTE_ADDR"))),0,255);
			$msg="Name: ".$name."\n".
				"Email: ".$to."\n".
				"Telephone: ".$telephone."\n".
				"IP address: ".serverVar("REMOTE_ADDR")."\n".
				"DNS: ".$xdns."\n".
				"Your message: ".$_POST['message'];
			// email myself
			$from = "From: $to \nContent-Type: text/plain; charset="._CHARSET;
			@mail($email,"new message from: $to",$msg,$from);
			// send copy to visitor
			$from = "From: $email \nContent-Type: text/plain; charset="._CHARSET;
			@mail($to,"message sent to: $email",$msg,$from);
			echo $this->getOption('message-sent');
		}
		$this->initCaptcha();
	}

}

?>