<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_Entities extends NucleusPlugin {

	function getName() { return 'Entities';  }
	function getAuthor()  { return 'Radek HULAN';  }
	function getURL() {  return 'http://hulan.cz/blog/'; }
	function getVersion() { return '1.0'; }
	function getDescription() { return 'This plugin will convert named 
    entities in articles and comments into their numerical values.'; }
 
	function supportsFeature($what) {
		if ($what=='SqlTablePrefix') return 1;
		return 0;
	}

	function getEventList() {
	  return array(
      'PreItem',
      'PreAddItem',
      'PreUpdateItem',
      'PreComment',
      'PreAddComment',
      'PreUpdateComment');
	}

	function install() {
      $this->createOption('itemreal','Parse Items real-time?','yesno','yes');
      $this->createOption('itemsave','Parse Items when saving?','yesno','yes');
      $this->createOption('commentreal','Parse Comments real-time?','yesno','yes');
      $this->createOption('commentsave','Parse Commetns when saving?','yesno','yes');
	}
 
	function init(){
		$this->_itemreal=$this->getOption('itemreal');
		$this->_itemsave=$this->getOption('itemsave');
		$this->_commentreal=$this->getOption('commentreal');
		$this->_commentsave=$this->getOption('commentsave');
	}
	
	function event_PreItem(&$data) {
		if ($this->_itemreal == 'yes') {
		  $content = array('title'=>&$data['item']->title,'body'=>&$data['item']->body,'more'=>&$data['item']->more);
		  $this->parseString($content);
		}
	}

	function event_PreAddItem(&$data) {
	  if ($this->_itemsave == 'yes') {
		 $content = array('title'=>&$data['title'],'body'=>&$data['body'],'more'=>&$data['more']);
		 $this->parseString($content);
	  }
	}
	
	function event_PreUpdateItem(&$data) {
		 $this->event_PreAddItem($data);
	}
	

	function event_PreComment(&$data) {
		if ($this->_commentreal == 'yes') {
			$data['comment']['body'] = entity_to_decimal_value($data['comment']['body']); 
		}
	}

	function event_PreAddComment(&$data) {
		if ($this->_commentsave == 'yes') {
			$data['comment']['body'] = entity_to_decimal_value($data['comment']['body']); 
		}
	}

	function event_PreUpdateComment(&$data) {
		if ($this->_commentsave == 'yes') {
			$data['body'] = entity_to_decimal_value($data['body']); 
		}
	}

	function parseString(&$content) {
		$keys=array('title','body','more');
		foreach ($keys as $key)
			$content[$key] = entity_to_decimal_value($content[$key]);
   }

}
?>