<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/


/*                                       */
/* NP_ExtraSkin                          */
/* ------------------------------------  */
/* An easy way to add extra skins        */
/* and templates to Nucleus!             */
/*                                       */
/* add this to your .htaccess            */
/*                                       */
/* <FilesMatch "^extra$">                */ 
/*  ForceType application/x-httpd-php    */
/* </FilesMatch>                         */


class NP_ExtraSkin extends NucleusPlugin {

	function getName() 		{ return 'ExtraSkin'; }
	function getAuthor()  	{ return 'Radek HULAN'; }
	function getURL()  		{ return 'http://hulan.cz/blog/'; }
	function getVersion() 	{ return '0.1'; }
	function getDescription() { return 'Plugin to create extra skins in Nucleus under /extra/ subdir, including skins parsing, and support for user-defined FancyURLs!';	}

	function supportsFeature($what) {
		switch($what)
		{ case 'SqlTablePrefix':
				return 1;
			default:
				return 0; }
	}

	function install() {
		$this->createOption('quickmenu', 'Show in quick menu', 'yesno', 'yes');
	}
	
	function getTableList() {
		return array(sql_table('plug_extra_skin'));
	}

	function getEventList() {
		return array('QuickMenu');
	}
	
	function hasAdminArea() {
		return 1;
	}
	
	function event_QuickMenu(&$data) {
		// only show when option enabled
		if ($this->getOption('quickmenu') != 'yes') return;
		global $member;
		// only show to admins
		if (!($member->isLoggedIn() && $member->isAdmin())) return;
		array_push(
			$data['options'], 
			array(
				'title' => 'ExtraSkin',
				'url' => $this->getAdminURL(),
				'tooltip' => 'Create extra skins.',
				'plugin' => 'NP_ExtraSkin'
			)
		);
	}

  function doParse($content,$skinType) {
    $handler = new ACTIONS($skinType);
    $parser = new PARSER(SKIN::getAllowedActionsForType($skinType), $handler);
    $handler->parser =& $parser;
    $parser->parse($content);      
  }
     
	function doSkinVar($skinType, $tablename='') {
    $tablename=sql_escape(sql_unescape($tablename));
    $query=sql_query("select tableid, skin from ".sql_table('plug_extra_skin')." where title='$tablename'");
    if ($row=sql_fetch_object($query)) $this->doParse(sql_unescape($row->skin),$skinType); 
	}
	
  function doTemplateVar(&$item,$tablename='') {
    $tablename=sql_escape(sql_unescape($tablename));
    $query=sql_query("select tableid, skin from ".sql_table('plug_extra_skin')." where title='$tablename'");
    if ($row=sql_fetch_object($query)) $this->doParse(sql_unescape($row->skin),'item'); 
  }
  	

}
?>