<?php
/*
Nucleus Plugin FlashVideo

With this plugin you can post a Flash Video (flv) by using the tag <%flashvideo(yourvideo.flv)%>

The plugin requires the FLASH VIDEO PLAYER (http://www.jeroenwijering.com/?item=Flash_Video_Player) from Jeroen Wijering. The player file 'flvplayer.swf' must be in the directory /media of your blog.

v0.1 (2006-03-15): inital realease
v0.2 (2006-03-21): support for fancy urls
v0.3 (2006-03-31): - using authorid instead of blogid (bug removed)
				   - parameters for individual width and height of the video added
v0.4 (2006-06-11): allow absolute URLs (starting with http://) 
v0.5 (2007-02-07): - additional parameters to style the player
				   - automatic search for preview images (required for the new
				   version of the fash video player)
				   (used version: FLASH VIDEO PLAYER 3.3) 
*/

class NP_FlashVideo extends NucleusPlugin {

	var $authorid;

	function getName()        { return 'FlashVideo'; }
	function getAuthor()      { return 'Kai Greve'; }
	function getURL()         { return 'http://kgblog.de/'; }
	function getVersion()     { return '0.5'; }
	function getDescription() { return 'Post a Flash Video (flv) by using the tag <%flashvideo(yourvideo.flv)%> or <%flashvideo(yourvideo.flv)|width|height%>'; }

	function install() {
		$this->createOption('width','Default width','text','320');
		$this->createOption('height','Default height','text','240');
		$this->createOption('flashvars','Use addtional settings to style your player (flashvars)?','yesno','no');
		
		$this->createOption('autostart','Autostart video','yesno','no');
		$this->createOption('repeat','Repeat video','yesno','no');

		$this->createOption('showdigits','Show the time display','yesno','no');

		$this->createOption('frontcolor','frontcolor','text','0xE0E0E0');
		$this->createOption('backcolor','backcolor','text','0x000000');
		$this->createOption('lightcolor','lightcolor','text','0xFF0000');
		
		$this->createOption('previewimages','Search preview images in the media directory?','yesno','yes');
		
		$this->createOption('wmvideo','Search WM video in the media directory?','yesno','yes');
		$this->createOption('wmtext','WM video link text?','text','Click here to play streaming WM video');
	}

	function getEventList() {
		return array('PreItem');
	}

	function unInstall() {
	}

	function flvCode($param) {
		global $CONF, $DIR_MEDIA;

		// explode parameters
		$para=explode('|',$param[1]);

		// filename
		$filename=$para[0];

		// size
		if (isset($para[1]) || isset($para[2])){
			$width=$para[1];
			$height=$para[2];       
		}
		else {
			$width=$this->getOption('width');
			$height=$this->getOption('height');
		}
		
		// additional Parameters (flashvars)
		if ($this->getOption('flashvars')=="yes") {
		
			$append="";
		
			// autostart
			if ($this->getOption('autostart')=="yes") {
				$append.="&amp;autostart=true";
			}
			else {
				$append.="&amp;autostart=false";
			}
			
			// repeat the video
			if ($this->getOption('repeat')=="yes") {
				$append.="&amp;repeat=true";
			}
			else {
				$append.="&amp;repeat=false";
			}
			
			// show time display
			if ($this->getOption('showdigits')=="yes") {
				$append.="&amp;showdigits=true";
			}
			else {
				$append.="&amp;showdigits=false";
			}
			
			// change frontcolor
			if ($this->getOption ('frontcolor')!="") {
				$append.='&amp;frontcolor='.$this->getOption ('frontcolor');	
			}
			
			// change backcolor
			if ($this->getOption ('backcolor')!="") {
				$append.='&amp;backcolor='.$this->getOption ('backcolor');
			}

			// change lightcolor (highlight for mouse rollover)
			if ($this->getOption ('lightcolor')!="") {
				$append.='&amp;lightcolor='.$this->getOption ('lightcolor');
			}
		}

		// url of the flashvideo
		if (substr($filename, 0, 7)=="http://") {
			$fileurl=$filename;
		}
		else {
			$fileurl=$CONF['MediaURL'].$this->authorid.'/'.$filename; 
		}
		
		// check for preview images
		if ($this->getOption ('previewimages')=="yes") {
			$filestub = substr ($filename, 0, strpos($filename,'.'));
			$filepath = $DIR_MEDIA.$this->authorid.'/'.$filestub;
		
			$extension = array ('jpg','jpeg','png');
			$image_exist = false;

			foreach ($extension as $ext) {
				if (file_exists ($filepath.'.'.$ext)) {
					$image = $CONF['MediaURL'].$this->authorid.'/'.$filestub.'.'.$ext;
					$image_exist = true;
				}
			}
		
			if ($image_exist) {
				$append.='&amp;image='.$image;
			}
		}
		
		// check for WM video
		$alternatecontent = '';
		if ($this->getOption ('wmvideo')=="yes") {
			if (strpos($fileurl,'.flv') !== false) { // original file is FLV
				$wmdir = str_replace($CONF['MediaURL'],$DIR_MEDIA,str_replace(".flv",".wmv",$fileurl));
				if (is_file($wmdir)) {
					$kb = intval(@filesize($wmdir) / 1024);
					$wmurl = str_replace("http:","mms:",str_replace(".flv",".wmv",$fileurl));
					$alternatecontent = "<a href='$wmurl'>".$this->getOption('wmtext')." ($kb KB) </a>";
				}
			}
		}
		

		// code for the flashvideo
		$code = '<object type="application/x-shockwave-flash" width="'.$width.'" height="'.$height.'" data="'.$CONF['MediaURL'].'flvplayer.swf?file='.$fileurl.$append.'"><param name="movie" value="'.$CONF['MediaURL'].'flvplayer.swf?file='.$fileurl.$append.'" /><param name="wmode" value="transparent" />'.$alternatecontent.'</object>';

		return $code;
	}

	function event_PreItem($data) {
		$this->currentItem = &$data["item"];
		$this->authorid = &$data["item"]->authorid;
		$this->currentItem->body = preg_replace_callback("#<\%flashvideo\((.*?)\)%\>#", array(&$this, 'flvCode'), $this->currentItem->body);
		$this->currentItem->more = preg_replace_callback("#<\%flashvideo\((.*?)\)%\>#", array(&$this, 'flvCode'), $this->currentItem->more);
	}

	function supportsFeature ($what) {
		switch ($what) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}
}
?>
