<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * Based on: 
  * ----------------------------------------------------------------
  * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/) 
  * Copyright (C) 2002-2003 The Nucleus Group
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_GZip extends NucleusPlugin {

var $obStarted;

	function getMinNucleusVersion()	{
		return 155;
	}

	function supportsFeature($feature) {
		switch($feature) {
			case 'SqlTablePrefix':
				return 1;
			default:
				return 0;
		}
	}

	// name of plugin
	function getName() {
		return 'gzip encoding'; 
	}
	
	// author of plugin
	function getAuthor()  { 
		return 'Wouter Demuynck'; 
	}
	
	// an URL to the plugin website
	// can also be of the form mailto:foo@bar.com
	function getURL() {
		return 'http://nucleuscms.org/'; 
	}
	
	// version of the plugin
	function getVersion() {
		return '2.0'; 
	}
	
	// a description to be shown on the installed plugins listing
	function getDescription() { 
		return 'Compresses the pages generated by Nucleus using gzip compression, if the requesting browser accepts this. This saves bandwidth.';
	}

	function getEventList() {
		return array('PreSkinParse', 'PostSkinParse');
	}
	
	function event_PreSkinParse(&$data) {
		$this->obStarted = smartStartGzip();
	}
	
	function event_PostSkinParse(&$data) {
		if ($this->obStarted) ob_end_flush();
	}	
}

?>