<?php

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

global $DIR_PLUGINS;
if (!is_dir($DIR_PLUGINS)) die('System is not configured properly - NP_Geshi.php');
require($DIR_PLUGINS.'geshi/geshi.php');

class NP_Geshi extends NucleusPlugin {

	function getName() { return 'Geshi';  }
	function getAuthor()  { return 'Radek HULAN';  }
	function getURL() {  return 'http://hulan.cz/blog/'; }
	function getVersion() { return '1.0'; }
	function getDescription() { return 'Highlights source code for multiple programming languages. Usage: &lt;pre PHP&gt; ... &lt;/pre&gt;'; }
 
	function supportsFeature($what) {
		if ($what=='SqlTablePrefix') return 1;
		return 0;
	}

	function getEventList() {
	  return array('PreItem','PreAddItem','PreUpdateItem');
	}

	function install() {
	  $this->createOption('rendermode','Code highlighting mode','select','realtime','Realtime Rendering|realtime|Parse and Save|save');
      $this->createOption('linenumbers','Enable line numbers?','yesno','yes');
	  $this->createOption('linktarget','Link target?','text','_blank');
	}
 
	function init(){
		$this->_rendermode=$this->getOption('rendermode');
		$this->_linenumbers=$this->getOption('linenumbers');
		$this->_linktarget=$this->getOption('linktarget');
	}
	
	function event_PreItem(&$data) {
		if ($this->_rendermode == 'realtime') {
		  $content = array('body'=>&$data['item']->body,'more'=>&$data['item']->more);
		  $this->parseString($content);
		}
	}

	function event_PreAddItem(&$data) {
	  if ($this->_rendermode == 'save') {
		 $content = array('body'=>&$data['body'],'more'=>&$data['more']);
		 $this->parseString($content);
	  }
	}
	
	function event_PreUpdateItem(&$data) {
		 $this->event_PreAddItem($data);
	}
	

   function parseString(&$content) {
		$keys=array('body','more');
		foreach ($keys as $key)
			$content[$key] = 
				preg_replace_callback('/<pre\s+(.*?)>(.*?)<\/pre>/si',array(&$this,'replaceString'),$content[$key]);
	}
	
	function replaceString($r){
	    global $DIR_PLUGINS;
		if (!is_dir($DIR_PLUGINS)) die('System is not configured properly');
		$geshi = new GeSHi($r[2], strtolower($r[1]), $DIR_PLUGINS."geshi".DIRECTORY_SEPARATOR);
		$geshi->set_encoding('UTF-8');
		$geshi->enable_classes(true);
		$geshi->set_header_type(GESHI_HEADER_PRE);
		if ($this->_linenumbers=='yes')
			$geshi->enable_line_numbers(GESHI_NORMAL_LINE_NUMBERS,10);
		else
			$geshi->enable_line_numbers(GESHI_NO_LINE_NUMBERS,0);
		$geshi->set_overall_class('code');
		if (!empty($this->_linktarget)) 
			$geshi->set_link_target($this->_linktarget);
		return $geshi->parse_code();
	}
  
}
?>