<?php 

/**
  * BLOG:CMS: PHP/MySQL Personal Content Management System (CMS)
  * http://blogcms.com/
  * ----------------------------------------------------------------
  *
  * Copyright (C) 2003-2005 Radek HULN
  * http://hulan.cz/contact/
  *
  * ----------------------------------------------------------------
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
**/

class NP_HeaderNavigation extends NucleusPlugin { 
   function getName() { return 'HeaderNavigation'; } 
   function getAuthor() { return 'Radek HULAN'; } 
   function getURL() { return 'http://hulan.cz/blog/'; } 
   function getVersion() { return '0.1'; } 
   function getDescription() { return 'Makes navigation to previous / next page, first, last page in INDEX skin, or to previous / next article / up in ITEM skin, or to previous / next archive / up in ARCHIVE skin.'; } 

	 function getEventList() { 
		return array(); 
	 }	

   function supportsFeature($feature) {
	   switch($feature) {
		case 'SqlTablePrefix':
			return 1;
		default:
			return 0;
	  }
   }

	function install() {
		$this->createBlogOption('urlhelp', 'Help page URL (or empty if none)', 'text', '');
		$this->createBlogOption('urlauthor', 'Author contact page URL (or empty for automatic member page)', 'text', '');
	}

  function header($params,$type){
     global $blog;
     $bloglink = createBlogLink($blog->getURL(), $params); 
     echo "<link rel='$type' href='$bloglink' />\n";
  }

  function doSkinVar($skinType,$amount=5) {
   if ($skinType=='error') return;
   global $catid,$blog; 
   $blogid = $blog->getID(); 
   $limit=getVar('limit');
   $offset=getVar('offset');
   $data = explode( "/", serverVar('REQUEST_URI'));
   for ( $i = 1;$i < count( $data);$i++) if ( $data[$i] == 'offset') $offset = intval( $data[$i + 1]);

   // web root
   $params=array();
   echo "<link rel='home' href='/' />\n";
   // blog root
   $params=array();
   $this->header($params,'contents');
   // blog root with category filter
   if ($catid>0) {
     $params['catid'] = $catid;
     $this->header($params,'index');
   }
   // help page
   $url=trim($this->getBlogOption($blogid,'urlhelp'));
   if (!empty($url)) echo "<link rel='help' href='$url' />\n";
     
   // INDEX skin
   if ($skinType=='index'){
     $entries=quickQuery("SELECT count(*) as result FROM ".sql_table('item')." WHERE iblog=".$blogid." AND idraft=0 AND itime<='".mysqldate($blog->getCorrectTime())."'".(($catid!=0)?" AND icat=$catid":""));
     // first page
     $params=array();
     if ($catid>0) $params['catid'] = $catid;
     if ($offset!=0) $this->header($params,'first');
     // previous page
     $params=array();
     if ($catid>0) $params['catid'] = $catid;
     if ($offset>0) $params['offset'] = $offset-$amount;  else $params['offset']=0;
     if ($params['offset']<1) $params['offset']=0;
     if ($params['offset']!=$offset) $this->header($params,'prev');
     // next page
     if ($catid>0) $params['catid'] = $catid;
     $params['offset'] = $offset+$amount;
     $totalpagecount = intval($entries/$amount); 
     if ($params['offset']>$entries) $params['offset']=$totalpagecount*$amount;
     if ($params['offset']!=$offset) $this->header($params,'next');
     // last page
     if ($catid>0) $params['catid'] = $catid;
     $params['offset']=$totalpagecount*$amount;
     if ($params['offset']!=$offset) $this->header($params,'last');
   }
  
   // ITEM skin
   if ($skinType=='item'){
     // author
     $url=trim($this->getBlogOption($blogid,'urlauthor'));
     if (!empty($url)) 
       echo "<link rel='author' href='$url' />\n";
     else {
       global $itemid;
       if (isset($itemid)) {
         $query=sql_query("select iauthor from ".sql_table("item")." where inumber=".$itemid);
         if ($row=sql_fetch_object($query)) echo "<link rel='author' href='".createMemberLink($row->iauthor)."'/>\n";
       } 
     } 
     // previous
     global $itemidprev;
     if (isset($itemidprev)) echo "<link rel='prev' href='".fancyLink($itemidprev)."'/>\n";
     // next
     global $itemidnext;
     if (isset($itemidnext)) echo "<link rel='next' href='".fancyLink($itemidnext)."'/>\n";
     // up
     $params=array();
     if ($catid>0) $params['catid']=$catid;
     $this->header($params,'up');
   }
  
   // ARCHIVE skin
   if ($skinType=='archive' || $skinType=='archivelist'){
    // previous
    global $archiveprev;
    if (isset($archiveprev)){
      $link = createArchiveLink($blogid,$archiveprev);
      echo "<link rel='prev' href='$link'/>\n";
    }
    // next
    global $archivenext;
    if (isset($archivenext)){
      $link = createArchiveLink($blogid,$archivenext);
      echo "<link rel='next' href='$link'/>\n";
    }
    // up
    $params=array();
    if ($catid>0) $params['catid']=$catid;
    $this->header($params,'up');
   }

  } // doSkinVar 
} // class 

?>